# 月线行情

**文档ID**: 145
**原始链接**: https://tushare.pro/document/2?doc_id=145

---

## 月线行情

接口：monthly描述：获取A股月线数据限量：单次最大4500行，总量不限制积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码 （ts_code,trade_date两个参数任选一）</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期 （每月最后一个交易日日期，YYYYMMDD格式）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>月收盘价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>月开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>月最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>月最低价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>上月收盘价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>月涨跌额</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>月涨跌幅 （未复权，如果是复权请用 <a href="https://tushare.pro/document/2?doc_id=109">通用行情接口</a> ）</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>月成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>月成交额</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.monthly(ts_code='000001.SZ', start_date='20180101', end_date='20181101', fields='ts_code,trade_date,open,high,low,close,vol,amount')

```

或者

```

df = pro.monthly(trade_date='20181031', fields='ts_code,trade_date,open,high,low,close,vol,amount')

```

数据样例

```
      ts_code trade_date  close   open   high    low          vol  \
0   000001.SZ   20181031  10.91  10.70  11.46   9.70  27801557.09   
1   000001.SZ   20180930  11.05  10.09  11.27   9.68  18821004.99   
2   000001.SZ   20180831  10.13   9.42  10.43   8.64  21896873.02   
3   000001.SZ   20180731   9.42   9.05   9.59   8.45  20430278.02   
4   000001.SZ   20180630   9.09  10.15  10.46   8.87  18179888.58   
5   000001.SZ   20180531  10.18  10.97  11.23  10.02  18267177.83   
6   000001.SZ   20180430  10.85  10.87  11.94  10.51  23495990.53   
7   000001.SZ   20180331  10.90  11.92  12.34  10.55  23129969.15   
8   000001.SZ   20180228  12.05  13.95  14.57  11.38  25624473.21   
9   000001.SZ   20180131  14.05  13.35  15.13  12.86  46145376.46   
10  000001.SZ   20171231  13.30  13.40  13.86  12.64  29661838.16   
11  000001.SZ   20171130  13.38  11.56  15.24  11.09  42481293.87   
12  000001.SZ   20171031  11.54  11.57  11.73  11.12  13951964.07   
13  000001.SZ   20170930  11.11  11.28  11.94  10.82  16101838.41   
14  000001.SZ   20170831  11.28  10.64  11.74   9.99  26281362.76   
15  000001.SZ   20170731  10.67   9.40  11.33   9.27  35360949.04   
16  000001.SZ   20170630   9.39   9.20   9.49   8.99  12718091.74   
17  000001.SZ   20170531   9.20   8.96   9.23   8.54  12252646.46   
18  000001.SZ   20170430   8.99   9.16   9.22   8.89   8024338.26   
19  000001.SZ   20170331   9.17   9.49   9.55   9.06  12889345.37   
20  000001.SZ   20170228   9.48   9.34   9.62   9.23   8460527.09   
21  000001.SZ   20170131   9.33   9.11   9.34   9.07   7629258.66 

          amount  
0   2.960878e+07  
1   1.942842e+07  
2   2.088672e+07  
3   1.832737e+07  
4   1.791251e+07  
5   1.965278e+07  
6   2.655691e+07  
7   2.692560e+07  
8   3.322504e+07  
9   6.454870e+07  
10  3.914290e+07  
11  5.604279e+07  
12  1.597217e+07  
13  1.827867e+07  
14  2.859479e+07  
15  3.736988e+07  
16  1.171552e+07  
17  1.083921e+07  
18  7.268941e+06  
19  1.197751e+07  
20  7.977982e+06  
21  7.001209e+06  

```
