# 日线行情

**文档ID**: 138
**原始链接**: https://tushare.pro/document/2?doc_id=138

---

## 期货日线行情

接口：fut_daily，可以通过数据工具调试和查看数据。描述：期货日线行情数据限量：单次最大2000条，总量不限制积分：用户需要至少2000积分才可以调取，未来可能调整积分，请尽量多的积累积分。具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期(YYYYMMDD格式，下同)</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>合约代码</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易所代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS合约代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨收盘价</td>
</tr>
<tr>
<td>pre_settle</td>
<td>float</td>
<td>Y</td>
<td>昨结算价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>settle</td>
<td>float</td>
<td>Y</td>
<td>结算价</td>
</tr>
<tr>
<td>change1</td>
<td>float</td>
<td>Y</td>
<td>涨跌1 收盘价-昨结算价</td>
</tr>
<tr>
<td>change2</td>
<td>float</td>
<td>Y</td>
<td>涨跌2 结算价-昨结算价</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量(手)</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额(万元)</td>
</tr>
<tr>
<td>oi</td>
<td>float</td>
<td>Y</td>
<td>持仓量(手)</td>
</tr>
<tr>
<td>oi_chg</td>
<td>float</td>
<td>Y</td>
<td>持仓量变化</td>
</tr>
<tr>
<td>delv_settle</td>
<td>float</td>
<td>N</td>
<td>交割结算价</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取CU1811合约20180101～20181113期间的行情
df = pro.fut_daily(ts_code='CU1811.SHF', start_date='20180101', end_date='20181113')

#获取2018年11月13日大商所全部合约行情数据
df = pro.fut_daily(trade_date='20181113', exchange='DCE', fields='ts_code,trade_date,pre_close,pre_settle,open,high,low,close,settle,vol')

```

数据示例

```
     ts_code    trade_date  pre_close  pre_settle     open     high      low  \
0    CU1811.SHF   20181113    48900.0     49030.0  48910.0  49040.0  48700.0   
1    CU1811.SHF   20181112    49270.0     49340.0  49130.0  49200.0  48860.0   
2    CU1811.SHF   20181109    49440.0     49500.0  49340.0  49530.0  49120.0   
3    CU1811.SHF   20181108    49470.0     49460.0  49600.0  49680.0  49350.0   
4    CU1811.SHF   20181107    49670.0     49630.0  49640.0  49850.0  49260.0   
5    CU1811.SHF   20181106    49780.0     49890.0  49800.0  49860.0  49500.0   
6    CU1811.SHF   20181105    49820.0     49340.0  49820.0  50290.0  49720.0   
7    CU1811.SHF   20181102    48680.0     48720.0  48780.0  49930.0  48750.0   
8    CU1811.SHF   20181101    49100.0     49120.0  49050.0  49170.0  48510.0   
9    CU1811.SHF   20181031    49650.0     49680.0  49480.0  49480.0  48900.0   
10   CU1811.SHF   20181030    49700.0     49830.0  50020.0  50050.0  49530.0   
11   CU1811.SHF   20181029    49680.0     49930.0  49680.0  50100.0  49560.0   
12   CU1811.SHF   20181026    49750.0     49680.0  49960.0  50300.0  49670.0   
13   CU1811.SHF   20181025    50270.0     50090.0  50070.0  50170.0  49350.0   
14   CU1811.SHF   20181024    50100.0     50330.0  49920.0  50290.0  49850.0   
15   CU1811.SHF   20181023    50540.0     50450.0  50710.0  50780.0  50040.0   
16   CU1811.SHF   20181022    50270.0     50080.0  50480.0  50610.0  50250.0   
17   CU1811.SHF   20181019    50130.0     50280.0  50000.0  50310.0  49850.0   
18   CU1811.SHF   20181018    50290.0     50230.0  50380.0  50560.0  50000.0   
19   CU1811.SHF   20181017    50190.0     50510.0  50330.0  50380.0  50030.0   
20   CU1811.SHF   20181016    50570.0     50780.0  50780.0  50960.0  50130.0   

     close   settle  change1  change2       vol      amount        oi  \
0    49030.0  48830.0      0.0   -200.0   17270.0   421721.70   16110.0   
1    48900.0  49030.0   -440.0   -310.0   27710.0   679447.85   22940.0   
2    49270.0  49340.0   -230.0   -160.0   22530.0   555910.15   30100.0   
3    49440.0  49500.0    -20.0     40.0   22290.0   551708.00   34800.0   
4    49470.0  49460.0   -160.0   -170.0   26850.0   664040.10   38330.0   
5    49670.0  49630.0   -220.0   -260.0   21920.0   543949.90   42890.0   
6    49780.0  49890.0    440.0    550.0   30430.0   759128.50   46570.0   
7    49820.0  49340.0   1100.0    620.0   33220.0   819667.00   50030.0   
8    48680.0  48720.0   -440.0   -400.0   34450.0   839294.60   54440.0   
9    49100.0  49120.0   -580.0   -560.0   57280.0  1406889.52   56170.0   
10   49650.0  49680.0   -180.0   -150.0   55614.0  1381482.82   64048.0   
11   49700.0  49830.0   -230.0   -100.0   53786.0  1340288.82   73114.0   
12   49680.0  49930.0      0.0    250.0   49496.0  1235819.76   80648.0   
13   49750.0  49680.0   -340.0   -410.0   91260.0  2266903.68   84580.0   
14   50270.0  50090.0    -60.0   -240.0   94348.0  2363108.67   95734.0   
15   50100.0  50330.0   -350.0   -120.0   82700.0  2081209.96  116458.0   
16   50540.0  50450.0    460.0    370.0   90744.0  2289330.09  131412.0   
17   50270.0  50080.0    -10.0   -200.0  109650.0  2745775.65  140034.0   
18   50130.0  50280.0   -100.0     50.0  120742.0  3035613.40  147102.0   
19   50290.0  50230.0   -220.0   -280.0  111464.0  2799654.18  160952.0   
20   50190.0  50510.0   -590.0   -270.0  149838.0  3784650.23  168606.0   

     oi_chg  
0       0.0  
1    -440.0  
2    -230.0  
3     -20.0  
4    -160.0  
5    -220.0  
6     440.0  
7    1100.0  
8    -440.0  
9    -580.0  
10   -180.0  
11   -230.0  
12      0.0  
13   -340.0  
14    -60.0  
15   -350.0  
16    460.0  
17    -10.0  
18   -100.0  
19   -220.0  
20   -590.0  

```
