# 新闻通讯（长篇）

**文档ID**: 195
**原始链接**: https://tushare.pro/document/2?doc_id=195

---

## 新闻通讯

接口：major_news描述：获取长篇通讯信息，覆盖主要新闻资讯网站，提供超过8年历史新闻。限量：单次最大400行记录，可循环提取保存到本地。积分：本接口需单独开权限（跟积分没关系），具体请参阅权限说明

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>src</td>
<td>str</td>
<td>N</td>
<td>新闻来源（新华网、凤凰财经、同花顺、新浪财经、华尔街见闻、中证网、财新网、第一财经、财联社）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>新闻发布开始时间，e.g. 2018-11-21 00:00:00</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>新闻发布结束时间，e.g. 2018-11-22 00:00:00</td>
</tr>
</tbody>
</table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>title</td>
<td>str</td>
<td>Y</td>
<td>标题</td>
</tr>
<tr>
<td>content</td>
<td>str</td>
<td>N</td>
<td>内容 (默认不显示，需要在fields里指定)</td>
</tr>
<tr>
<td>pub_time</td>
<td>str</td>
<td>Y</td>
<td>发布时间</td>
</tr>
<tr>
<td>src</td>
<td>str</td>
<td>Y</td>
<td>来源网站</td>
</tr>
</tbody>
</table>
接口调用

```
pro = ts.pro_api()

df = pro.major_news(src='新浪财经', start_date='2018-11-21 00:00:00', end_date='2018-11-22 00:00:00')

#提取新闻内容
df = pro.major_news(src='新浪财经', start_date='2018-11-21 00:00:00', end_date='2018-11-22 00:00:00', fields='title,content')

```

数据样例

```
                                            title  ...                                   src_site
0                     旺能环境：中标2.5亿元蚌埠市餐厨废弃物及污泥处理特许经营项目  ...    益盟操盘手
1                            博信股份：拟6900万元出售博成市政100%股权  ...    益盟操盘手
2                                      盒马鲜生“标签门”侵犯了谁？  ...     新浪财经
3                                   经济性不佳或致美多座核电站提前关停  ...    中国储能网
4                                江森自控：新时代智慧医院白皮书（附下载）  ...    199IT
5                    Gartner L2：只有13%的企业能提供具有高度针对性的消息  ...    199IT
6                              懂车帝：2018汽车行业大数据报告（附下载）  ...    199IT
7                                     争议五星酒店“2000元”罚单  ...     北京商报
8                                    李超：加快推动资本市场数字化转型  ...    证券时报网
9                                    财险市场变革“冲击”传统估值模型  ...    证券时报网
10                                  A股是重要投资方向主要关注两个领域  ...    证券时报网
11                              三季度网贷交易量普跌拍拍贷、乐信抗跌能力强  ...    证券时报网
12                                机构升级智能交易 一键超额快赎货币基金  ...    证券时报网
13                                发行股份重组停牌时间不超过10个交易日  ...    证券时报网
14                                         深沪证券市场每日行情  ...    证券时报网
15             关于新华恒稳添利债券型证券投资基金增加A类份额并修改基金合同和托管协议的公告  ...    证券时报网
16  关于新增诺亚正行（上海）基金销售投资顾问有限公司为富安达新兴成长灵活配置混合型证券投资基金代...  ...    证券时报网
17                                   华宝基金管理有限公司公告（系列）  ...    证券时报网
18               兴业鑫天盈货币市场基金调整大额申购(含转换转入和定期定额投资)限额的公告  ...    证券时报网
19  贵州百灵企业集团制药股份有限公司关于部分董事、监事、高级管理人员、证券事务代表增持公司股份计...  ...    证券时报网
20                广州智光电气股份有限公司关于召开公司2018年第五次临时股东大会的通知  ...    证券时报网

```
