# 指数月线行情

**文档ID**: 172
**原始链接**: https://tushare.pro/document/2?doc_id=172

---

## 指数月线行情

接口：index_monthly描述：获取指数月线行情,每月更新一次限量：单次最大1000行记录,可多次获取,总量不限制积分：用户需要至少600积分才可以调取，积分越多频次越高，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS指数代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘点位</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘点位</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高点位</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低点位</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨日收盘点</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌点位</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>成交量（手）</td>
<td></td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>成交额（千元）</td>
<td></td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.index_monthly(ts_code='000001.SH', start_date='20180101', end_date='20190330', fields='ts_code,trade_date,open,high,low,close,vol,amount')

```

或者

```

df = pro.index_monthly(trade_date='20190329', fields='ts_code,trade_date,open,high,low,close,vol,amount')

```

数据样例

```
      ts_code  trade_date     close      open      high       low  \
0   000001.SH   20190329  3090.758  2954.402  3129.940  2930.835   
1   000001.SH   20190228  2940.954  2597.778  2997.488  2590.554   
2   000001.SH   20190131  2584.572  2497.881  2630.318  2440.907   
3   000001.SH   20181228  2493.896  2647.132  2666.078  2462.845   
4   000001.SH   20181130  2588.188  2617.033  2703.512  2555.322   
5   000001.SH   20181031  2602.783  2768.208  2771.938  2449.197   
6   000001.SH   20180928  2821.350  2716.404  2827.341  2644.296   
7   000001.SH   20180831  2725.250  2882.506  2897.400  2653.112   
8   000001.SH   20180731  2876.401  2841.580  2915.297  2691.021   
9   000001.SH   20180629  2847.418  3084.754  3128.715  2782.381   
10  000001.SH   20180531  3095.474  3087.409  3219.740  3041.000   
11  000001.SH   20180427  3082.232  3169.779  3220.845  3041.625   
12  000001.SH   20180330  3168.897  3235.089  3333.875  3091.458   
13  000001.SH   20180228  3259.408  3478.670  3495.093  3062.743   
14  000001.SH   20180131  3480.833  3314.031  3587.032  3314.031   

             vol        amount  
0   8.691925e+11  8.300906e+12  
1   4.421808e+11  3.816145e+12  
2   3.385641e+11  2.804232e+12  
3   2.575119e+11  2.236021e+12  
4   4.052823e+11  3.352502e+12  
5   2.740242e+11  2.449081e+12  
6   2.148359e+11  2.152910e+12  
7   2.821389e+11  2.872973e+12  
8   3.049095e+11  3.259243e+12  
9   2.623979e+11  3.100450e+12  
10  2.979289e+11  3.810441e+12  
11  2.698985e+11  3.372116e+12  
12  3.704084e+11  4.396937e+12  
13  2.888959e+11  3.262255e+12  
14  4.797771e+11  5.772056e+12  

```
