# 指数实时日线

**文档ID**: 403
**原始链接**: https://tushare.pro/document/2?doc_id=403

---

接口：rt_idx_k描述：获取交易所指数实时日线行情，支持按代码或代码通配符一次性提取全部交易所指数实时日k线行情积分：本接口是单独开权限的数据，单独申请权限请参考权限列表

### 输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>指数代码，支持通配符方式，e.g. 0*.SH、3*.SZ、000001.SH</td>
</tr>
</tbody>
</table>
### 输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>指数代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>指数名称</td>
</tr>
<tr>
<td>trade_time</td>
<td>str</td>
<td>Y</td>
<td>交易时间</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>现价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨收</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额（元）</td>
</tr>
</tbody>
</table>
### 代码示例

```
#获取单个指数实时行情
df = pro.rt_idx_k(ts_code='000001.SH')

#获取多个指数实时行情,以上证综指和深证A指为例
df = pro.rt_idx_k(ts_code='000001.SH,399107.SZ')

#获取上交所所有指数实时行情，同时指定输出字段
df = pro.rt_idx_k(ts_code='0*.SH', fields='ts_code,name,close,vol')

```

### 数据结果

```
       ts_code    name       close           vol
0    000851.SH  百发100   19517.5514  2.035695e+07
1    000934.SH    中证金融   6203.0781  6.711314e+07
2    000010.SH  上证180    9773.2466  1.135439e+08
3    000065.SH    上证龙头   3527.1942  5.541939e+07
4    000033.SH    上证材料   3232.1719  2.889464e+07
..         ...     ...         ...           ...
195  000888.SH    上证收益   4420.1632  4.787276e+08
196  000011.SH    基金指数   7103.0192  1.107185e+09
197  000008.SH    综合指数   3668.1847  1.011677e+08
198  000075.SH    医药等权   7170.0801  4.000854e+06
199  000029.SH  180价值    4396.8748  5.572026e+07

```
