# 指数基本信息

**文档ID**: 94
**原始链接**: https://tushare.pro/document/2?doc_id=94

---

## 指数基本信息

接口：index_basic，可以通过数据工具调试和查看数据。描述：获取指数基础信息。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>指数代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>N</td>
<td>指数简称</td>
</tr>
<tr>
<td>market</td>
<td>str</td>
<td>N</td>
<td>交易所或服务商(默认SSE)</td>
</tr>
<tr>
<td>publisher</td>
<td>str</td>
<td>N</td>
<td>发布商</td>
</tr>
<tr>
<td>category</td>
<td>str</td>
<td>N</td>
<td>指数类别</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>TS代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>简称</td>
</tr>
<tr>
<td>fullname</td>
<td>str</td>
<td>指数全称</td>
</tr>
<tr>
<td>market</td>
<td>str</td>
<td>市场</td>
</tr>
<tr>
<td>publisher</td>
<td>str</td>
<td>发布方</td>
</tr>
<tr>
<td>index_type</td>
<td>str</td>
<td>指数风格</td>
</tr>
<tr>
<td>category</td>
<td>str</td>
<td>指数类别</td>
</tr>
<tr>
<td>base_date</td>
<td>str</td>
<td>基期</td>
</tr>
<tr>
<td>base_point</td>
<td>float</td>
<td>基点</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>发布日期</td>
</tr>
<tr>
<td>weight_rule</td>
<td>str</td>
<td>加权方式</td>
</tr>
<tr>
<td>desc</td>
<td>str</td>
<td>描述</td>
</tr>
<tr>
<td>exp_date</td>
<td>str</td>
<td>终止日期</td>
</tr>
</tbody></table>
市场说明(market)

<table>
<thead>
<tr>
<th>市场代码</th>
<th>说明</th>
</tr>
</thead>
<tbody><tr>
<td>MSCI</td>
<td>MSCI指数</td>
</tr>
<tr>
<td>CSI</td>
<td>中证指数</td>
</tr>
<tr>
<td>SSE</td>
<td>上交所指数</td>
</tr>
<tr>
<td>SZSE</td>
<td>深交所指数</td>
</tr>
<tr>
<td>CICC</td>
<td>中金指数</td>
</tr>
<tr>
<td>SW</td>
<td>申万指数</td>
</tr>
<tr>
<td>OTH</td>
<td>其他指数</td>
</tr>
</tbody></table>
指数列表

- 主题指数

- 规模指数

- 策略指数

- 风格指数

- 综合指数

- 成长指数

- 价值指数

- 有色指数

- 化工指数

- 能源指数

- 其他指数

- 外汇指数

- 基金指数

- 商品指数

- 债券指数

- 行业指数

- 贵金属指数

- 农副产品指数

- 软商品指数

- 油脂油料指数

- 非金属建材指数

- 煤焦钢矿指数

- 谷物指数


接口使用

```

pro = ts.pro_api()

df = pro.index_basic(market='SW')

```

数据样例

```
       ts_code    name              market     publisher   category     base_date  base_point  \
5    801010.SI    农林牧渔             SW      申万   一级行业指数  19991230      1000.0   
6    801011.SI    林业Ⅱ               SW     申万  二级行业指数  19991230      1000.0   
7    801012.SI    农产品加工           SW      申万   二级行业指数  19991230      1000.0   
8    801013.SI    农业综合Ⅱ           SW      申万  二级行业指数  19991230      1000.0   
9    801014.SI    饲料Ⅱ               SW     申万  二级行业指数  19991230      1000.0   
10   801015.SI    渔业                 SW      申万   二级行业指数  19991230      1000.0   
11   801016.SI    种植业               SW      申万   二级行业指数  19991230      1000.0   
12   801017.SI    畜禽养殖Ⅱ           SW      申万  二级行业指数  20111010      1000.0   
13   801018.SI    动物保健Ⅱ           SW      申万研  二级行业指数  19991230      1000.0   
14   801020.SI    采掘                 SW      申万   一级行业指数  19991230      1000.0   
15   801021.SI    煤炭开采Ⅱ           SW      申万  二级行业指数  19991230      1000.0   
16   801022.SI    其他采掘Ⅱ           SW      申万  二级行业指数  19991230      1000.0   
17   801023.SI    石油开采Ⅱ           SW      申万  二级行业指数  19991230      1000.0   
18   801024.SI    采掘服务Ⅱ           SW      申万  二级行业指数  19991230      1000.0
```
