# 指数周线行情

**文档ID**: 171
**原始链接**: https://tushare.pro/document/2?doc_id=171

---

## 指数周线行情

接口：index_weekly描述：获取指数周线行情限量：单次最大1000行记录，可分批获取，总量不限制积分：用户需要至少600积分才可以调取，积分越多频次越高，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS指数代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘点位</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘点位</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高点位</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低点位</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨日收盘点</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌点位</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量（手）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额（千元）</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.index_weekly(ts_code='000001.SH', start_date='20180101', end_date='20190329', fields='ts_code,trade_date,open,high,low,close,vol,amount')

```

或者

```

df = pro.index_weekly(trade_date='20190329', fields='ts_code,trade_date,open,high,low,close,vol,amount')

```

数据样例

```
      ts_code  trade_date     close       open       high        low  \
0   000001.SH   20190329  3090.7580  3058.8016  3093.0329  2987.7717   
1   000001.SH   20190322  3104.1487  3027.8012  3125.0192  3009.5071   
2   000001.SH   20190315  3021.7512  2969.0802  3093.3913  2963.5834   
3   000001.SH   20190308  2969.8614  3015.9427  3129.9395  2969.5815   
4   000001.SH   20190301  2994.0050  2838.3896  2997.4882  2838.3896   
5   000001.SH   20190222  2804.2262  2699.8171  2804.2262  2699.8171   
6   000001.SH   20190215  2682.3850  2613.1742  2729.4550  2613.1742   
7   000001.SH   20190201  2618.2323  2615.7118  2630.3183  2559.9820   
8   000001.SH   20190125  2601.7234  2599.0575  2618.9801  2569.7004   
9   000001.SH   20190118  2596.0056  2553.3284  2598.8836  2532.4333   
10  000001.SH   20190111  2553.8313  2528.6987  2574.4079  2515.5083   
11  000001.SH   20190104  2514.8682  2497.8805  2515.3160  2440.9066   
12  000001.SH   20181228  2493.8962  2506.7372  2532.0022  2462.8448   
13  000001.SH   20181221  2516.2506  2587.2632  2599.1479  2498.6937   
14  000001.SH   20181214  2593.7407  2589.1940  2645.8367  2576.2424   
15  000001.SH   20181207  2605.8876  2647.1319  2666.0784  2599.2775   
16  000001.SH   20181130  2588.1875  2580.8424  2617.5479  2555.3223   
17  000001.SH   20181123  2579.4831  2681.8988  2703.5116  2577.3511   
18  000001.SH   20181116  2679.1097  2593.2004  2695.5689  2590.2106  

             vol        amount  
0   1.688357e+11  1.688151e+12  
1   1.886363e+11  1.861600e+12  
2   2.104949e+11  2.043644e+12  
3   2.666471e+11  2.400174e+12  
4   2.265186e+11  1.976327e+12  
5   1.394586e+11  1.194304e+12  
6   9.758357e+10  8.413281e+11  
7   7.093562e+10  5.928545e+11  
8   7.608258e+10  6.350025e+11  
9   8.076279e+10  6.593113e+11  
10  8.366105e+10  6.847728e+11  
11  4.032072e+10  3.438140e+11  
12  6.014621e+10  5.129771e+11  
13  5.782961e+10  5.008462e+11  
14  6.147029e+10  5.296716e+11  
15  7.806582e+10  6.925260e+11  
16  7.004342e+10  5.716554e+11  
17  9.709342e+10  8.023547e+11  
18  1.112811e+11  8.857952e+11 

```
