# 影院日度票房

**文档ID**: 116
**原始链接**: https://tushare.pro/document/2?doc_id=116

---

## 影院每日票房

接口：bo_cinema描述：获取每日各影院的票房数据数据历史： 数据从2018年9月开始，更多历史数据正在补充数据权限：用户需要至少500积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期(格式:YYYYMMDD)</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>c_name</td>
<td>str</td>
<td>Y</td>
<td>影院名称</td>
</tr>
<tr>
<td>aud_count</td>
<td>int</td>
<td>Y</td>
<td>观众人数</td>
</tr>
<tr>
<td>att_ratio</td>
<td>float</td>
<td>Y</td>
<td>上座率</td>
</tr>
<tr>
<td>day_amount</td>
<td>float</td>
<td>Y</td>
<td>当日票房</td>
</tr>
<tr>
<td>day_showcount</td>
<td>float</td>
<td>Y</td>
<td>当日场次</td>
</tr>
<tr>
<td>avg_price</td>
<td>float</td>
<td>Y</td>
<td>场均票价（元）</td>
</tr>
<tr>
<td>p_pc</td>
<td>float</td>
<td>Y</td>
<td>场均人次</td>
</tr>
<tr>
<td>rank</td>
<td>int</td>
<td>Y</td>
<td>排名</td>
</tr>
</tbody></table>
接口使用

```
pro = ts.pro_api()
#或者
#pro = ts.pro_api('your token')

df = pro.bo_cinema(date='20181014')
```

数据示例

```
        date        c_name                aud_count  att_ratio  day_amount  \
0   20181014    Jackie Chan北京耀莱        4973      20.70   215721.00   
1   20181014    金逸北京大悦城IMAX店       3160      29.65   197890.50   
2   20181014    广州飞扬影城（正佳分店）   3279      23.30   173564.30   
3   20181014   首都电影院西单店            3412      30.01   167779.68   
4   20181014   北京寰映合生汇店            2554      30.69   161035.50   
5   20181014    金逸北京荟聚IMAX店         2710      18.34   150530.10   
6   20181014    南京新街口国际影城         3685      23.58   144884.50   
7   20181014    武商摩尔国际电影城         4232      23.22   144577.00   
8   20181014    广州飞扬影城               2775      22.38   144180.00   
9   20181014    中影国际影城武汉光谷天河店 4078      37.00   137562.00   
10  20181014   中影国际影城珠海华发2店     3228      34.78   136909.00   
11  20181014    卢米埃北京长楹天街IMAX影城 2197      18.04   132217.00   
12  20181014   中影国际影城北京昌平永旺店  3002      35.76   130213.40   
13  20181014   CGV影城 深圳壹方城店        2423      19.03   130132.00   
14  20181014   北京市金泉港国际影城        2538      16.75   129530.00   
15  20181014    北京UME国际影城双井店      2052      17.98   129479.59   
16  20181014   深圳市百老汇电影中心影城    2515      19.71   128600.00   
17  20181014    广州市百丽宫猎德影院       2007      24.84   125094.00   
18  20181014    郑州奥斯卡熙地港国际影城   3286      27.60   124663.00  
```
