# 开盘竞价成交（当日）

**文档ID**: 369
**原始链接**: https://tushare.pro/document/2?doc_id=369

---

## 当日集合竞价

接口：stk_auction描述：获取当日个股和ETF的集合竞价成交情况，每天9点25~29分之间可以获取当日的集合竞价成交数据限量：单次最大返回8000行数据，可根据日期或代码循环获取历史积分：本接口是单独开权限的数据，已经开通了股票分钟权限的用户可自动获得本接口权限，单独申请权限请参考权限列表。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>数据日期</td>
</tr>
<tr>
<td>vol</td>
<td>int</td>
<td>Y</td>
<td>成交量（股）</td>
</tr>
<tr>
<td>price</td>
<td>int</td>
<td>Y</td>
<td>成交均价（元）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额（元）</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨收价（元）</td>
</tr>
<tr>
<td>turnover_rate</td>
<td>float</td>
<td>Y</td>
<td>换手率（%）</td>
</tr>
<tr>
<td>volume_ratio</td>
<td>float</td>
<td>Y</td>
<td>量比</td>
</tr>
<tr>
<td>float_share</td>
<td>float</td>
<td>Y</td>
<td>流通股本（万股）</td>
</tr>
</tbody></table>
接口示例

```

#获取2025年2月18日开盘集合竞价成交情况
df = pro.stk_auction(trade_date='20250218',fields='ts_code, trade_date,vol,price,amount,turnover_rate,volume_ratio')


```

数据示例

```
        ts_code trade_date     vol    price      amount  turnover_rate  volume_ratio
0     600071.SH   20250218    8700   23.240   202188.00       0.003090      0.150628
1     300053.SZ   20250218   53300   13.750   732875.00       0.008388      0.230996
2     159558.SZ   20250218   18700    1.211    22645.70            NaN           NaN
3     600879.SH   20250218  195900    9.190  1800320.00       0.005938      0.373839
4     159707.SZ   20250218  160800    0.628   100982.00            NaN           NaN
...         ...        ...     ...      ...         ...            ...           ...
6507  300616.SZ   20250218  142700   14.370  2050600.00       0.091494      1.184760
6508  836957.BJ   20250218     300   12.310     3693.00       0.000702      0.012952
6509  123039.SZ   20250218      20  119.777     2395.54            NaN           NaN
6510  603655.SH   20250218    1400   23.390    32746.00       0.001321      0.107119
6511  300949.SZ   20250218   25600   41.210  1054980.00       0.042667      0.830128

```
