# 市场游资最全名录

**文档ID**: 311
**原始链接**: https://tushare.pro/document/2?doc_id=311

---

## 游资名录

接口：hm_list描述：获取游资分类名录信息限量：单次最大1000条数据，目前总量未超过500积分：5000积分可以调取，积分获取办法请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>name</td>
<td>str</td>
<td>N</td>
<td>游资名称</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>游资名称</td>
</tr>
<tr>
<td>desc</td>
<td>str</td>
<td>Y</td>
<td>说明</td>
</tr>
<tr>
<td>orgs</td>
<td>None</td>
<td>Y</td>
<td>关联机构</td>
</tr>
</tbody></table>
接口示例

```
#代码示例
pro = ts.pro_api()

df = pro.hm_list()

```

数据列表

<table>
<thead>
<tr>
<th>名称</th>
<th>说明</th>
<th>关联机构</th>
</tr>
</thead>
<tbody><tr>
<td>龙飞虎</td>
<td>龙飞虎(克拉美书)股灾期间曾为桃县精神领袖，留有颇多名言，可见人品股品。</td>
<td>华泰证券股份有限公司南京六合雄州西路证券营业部</td>
</tr>
<tr>
<td>高送转专家</td>
<td>擅长在高送转个股进行波段操作</td>
<td>财通证券股份有限公司常熟枫林路证券营业部</td>
</tr>
<tr>
<td>高毅邻山</td>
<td>价投大神“茅台03"，真名冯柳。自述曾有9年时间多达93%的年复利回报。眼光犀利独到，风格以中长线为主，碰上短线风口会主动配合炒作迅速推升股价。</td>
<td>国信证券股份有限公司深圳罗湖宝安北路证券营业部</td>
</tr>
<tr>
<td>骑牛</td>
<td>敢于追涨，锁仓，也敢于割肉。</td>
<td>中国银河证券股份有限公司重庆民族路证券营业部</td>
</tr>
<tr>
<td>首板挖掘</td>
<td>善于发掘低位首板或跟风板，市场上活跃的挖掘资金，擅长在题材爆发后挖掘补涨机会，一旦出现高位分歧就会及时离场。</td>
<td>申万宏源证券有限公司北京劲松九区证券营业部、湘财证券股份有限公司武汉友谊大道证券营业部、国都证券股份有限公司北京阜外大街证券营业部、华鑫证券有限责任公司泉州宝洲路证券营业部、华鑫证券有限责任公司江苏分公司、华鑫证券有限责任公司山东分公司、兴业证券股份有限公司厦门分公司、中信证券股份有限公司金华分公司、中信建投证券股份有限公司西安南大街证券营业部、东莞证券股份有限公司深圳后海工业八路证券营业部、东莞证券股份有限公司厦门分公司、东方财富证券股份有限公司江苏分公司、万和证券股份有限公司福建分公司</td>
</tr>
<tr>
<td>飞云江路</td>
<td>知名游资，近来崛起的江浙资金席位，接力操作为主，尤擅点火操作，资金规模适中，但活跃力度较高。</td>
<td>华鑫证券有限责任公司杭州飞云江路证券营业部</td>
</tr>
<tr>
<td>隐秀路</td>
<td>杭州隐秀路，60后，代表作南天信息，深桑达。隐秀路有人称其为散户收割机，也反映出不一样的手法操作，市场理解超于常人，信创概念股个人保守估计浮盈约1亿。操作手法一流，将极限做到极致，喜欢一家独大。</td>
<td>华鑫证券有限责任公司杭州隐秀路证券营业部</td>
</tr>
<tr>
<td>陈小群</td>
<td>活跃于网络论坛的实力游资，擅长趋势龙头，分歧打板介入，理解力尤其优秀。</td>
<td>中国银河证券股份有限公司大连黄河路证券营业部、中国银河证券股份有限公司大连金马路证券营业部</td>
</tr>
<tr>
<td>金田路</td>
<td>交易手法简单粗暴，追龙头，专做高位接力板，敢收敢割，在市场好的时候敢在高位连续加仓，遭遇行情不好的时候割的非常果断，毫不犹豫。</td>
<td>光大证券股份有限公司深圳金田路证券营业部、中天证券股份有限公司深圳分公司、中天证券股份有限公司台州市府大道证券营业部</td>
</tr>
<tr>
<td>量化打板</td>
<td>量化打板，绝大多数操作以首板二板为主，次日不能秒板开盘都会先兑现一半，上板纠错买回部分仓位，不能走强则直接清仓。</td>
<td>华鑫证券有限责任公司上海分公司、华创证券有限责任公司上海第二分公司</td>
</tr>
<tr>
<td>量化基金</td>
<td>20年参与京粮控股首次携假机构入场，凭借机构席位溢价次日获得一字板，到现在量化基金已经是市场上非常活跃的一股力量，内部资金成分复杂，多家机构混杂在其中，但是整体策略同样是起到助涨助跌的作用，会频繁做T。</td>
<td>华泰证券股份有限公司总部、中国国际金融股份有限公司上海黄浦区湖滨路证券营业部、中国国际金融股份有限公司上海分公司、中国中金财富证券有限公司北京宋庄路证券营业部、东北证券股份有限公司绍兴金柯桥大道证券营业部</td>
</tr>
<tr>
<td>赵老哥</td>
<td>以短线点火打板为主，擅长主线题材炒作，主抓龙头股。主要参与市场风口的龙头股接力板，激发市场资金持续接力。盘中操作手法主要以急速暴量扫货封板为主，利用资金优势万手大单排板。</td>
<td>银泰证券有限责任公司上海嘉善路证券营业部、湘财证券股份有限公司上海陆家嘴证券营业部、浙商证券股份有限公司绍兴分公司、浙商证券股份有限公司湖州双子大厦证券营业部、华泰证券股份有限公司浙江分公司、中国银河证券股份有限公司绍兴证券营业部、中国银河证券股份有限公司北京阜成路证券营业部</td>
</tr>
<tr>
<td>西湖国贸</td>
<td>顶级价投型资金，顶级理解力，善于挖掘低位的趋势牛股，波段持股为主。</td>
<td>财信证券股份有限公司杭州西湖国贸中心证券营业部</td>
</tr>
<tr>
<td>葛卫东</td>
<td>葛卫东偏爱科技股，其次是医药股，基本以中、长线投资为主，买入股票后往往会持有几年时间直至股价起飞\r\n</td>
<td>国泰君安证券股份有限公司上海分公司</td>
</tr>
<tr>
<td>著名刺客</td>
<td>活跃于股吧、论坛的小游资，擅长龙头股锁仓。</td>
<td>海通证券股份有限公司北京阜外大街证券营业部、东莞证券股份有限公司北京分公司</td>
</tr>
<tr>
<td>落升(江南神鹰)</td>
<td>落升(江南神鹰)03年的股评红遍网络05年底隐居隐居3年狂赚112倍他的故事网上有详细记载据观察其后自然人名罗申，取的是谐音，大熊市战绩斐然，令人惊叹，游资界早年网红派。</td>
<td>光大证券股份有限公司金华宾虹路证券营业部</td>
</tr>
<tr>
<td>苏州帮</td>
<td>以做短线为主，常见高抛低吸，做T营业部。</td>
<td>海通证券股份有限公司杭州市心北路证券营业部、广发证券股份有限公司苏州东吴北路证券营业部、华泰证券股份有限公司苏州人民路证券营业部、兴业证券股份有限公司上海金陵东路证券营业部、东吴证券股份有限公司苏州西北街证券营业部、东吴证券股份有限公司常州通江中路证券营业部</td>
</tr>
<tr>
<td>苏南帮</td>
<td>短庄游资，资金体量较大且人员众多，席位多为江苏本地席位联动操作，3/4板多为强顶一字板。</td>
<td>长江证券股份有限公司武汉友谊路证券营业部、长江证券股份有限公司南京中山东路证券营业部、申万宏源西部证券有限公司南宁英华路证券营业部、海通证券股份有限公司武汉光谷证券营业部、海通证券股份有限公司南京广州路证券营业部、天风证券股份有限公司深圳福华路证券营业部、天风证券股份有限公司深圳后海证券营业部、国泰君安证券股份有限公司深圳登良路证券营业部、国泰君安证券股份有限公司南京金融城证券营业部、南京证券股份有限公司张家港东环路证券营业部、华泰证券股份有限公司镇江句容华阳北路证券营业部、华泰证券股份有限公司无锡金融一街证券营业部、华泰证券股份有限公司宁波柳汀街证券营业部、华泰证券股份有限公司南宁民族大道证券营业部、华泰证券股份有限公司南京江宁天元东路证券营业部、华泰证券股份有限公司南京庐山路证券营业部、华泰证券股份有限公司南京中华路证券营业部、中国银河证券股份有限公司北京学院南路证券营业部、东莞证券股份有限公司苏州聚茂街路证券营业部、东莞证券股份有限公司福建分公司、东莞证券股份有限公司浙江分公司、东莞证券股份有限公司四川分公司、东海证券股份有限公司南京洪武北路证券营业部、上海证券有限责任公司黄浦区延安东路证券营业部、上海证券有限责任公司南京胜太路证券营业部、上海证券有限责任公司南京溧水致远路证券营业部</td>
</tr>
<tr>
<td>红岭路</td>
<td>联同作战，喜欢运作的强势主力之一，往往在核心个股第一波爆量后吸筹进场，随后维护股价，等待时机启动二波。</td>
<td>平安证券股份有限公司深圳蛇口招商路招商大厦证券营业部、平安证券股份有限公司深圳分公司、华泰证券股份有限公司深圳彩田路证券营业部</td>
</tr>
<tr>
<td>粉葛</td>
<td>擅长趋势热门股，打板交易</td>
<td>东亚前海证券有限责任公司深圳分公司</td>
</tr>
<tr>
<td>章盟主</td>
<td>江浙地区元老级顶级游资之一，90年代5万元入市。现在资金体量百亿，20年20万倍，操作霸气，尤好在权重大票上主升浪上重仓出击。</td>
<td>海通证券股份有限公司上海徐汇区建国西路证券营业部、方正证券股份有限公司杭州延安路证券营业部、国泰君安证券股份有限公司宁波广福街证券营业部、国泰君安证券股份有限公司上海江苏路证券营业部、中信证券股份有限公司杭州延安路证券营业部、中信证券股份有限公司杭州富春路证券营业部</td>
</tr>
<tr>
<td>竞价抢筹</td>
<td>量化交易，尤其擅长分歧回暖日竞价最后时间扫货，有能力制造弱转强分时吸引市场资金流入</td>
<td>中国银河证券股份有限公司北京中关村大街证券营业部</td>
</tr>
<tr>
<td>益田路</td>
<td>顶级情绪资金，对价投亦有独到理解。益田路游资基本上多是以自买自卖的形式出现在龙虎榜上。</td>
<td>华鑫证券有限责任公司深圳益田路证券营业部</td>
</tr>
<tr>
<td>申港广东分</td>
<td>情绪周期先行者,实力彪悍执行力务必坚决</td>
<td>申港证券股份有限公司广东分公司</td>
</tr>
<tr>
<td>瑞鹤仙</td>
<td>2011年入市，在当时的熊市中依然所向披靡，入市3年资金就从数十万达到上亿。以白衣骑士自居，操作风格独来独往。</td>
<td>诚通证券股份有限公司宜昌东山大道证券营业部、中国银河证券股份有限公司宜昌新世纪证券营业部、中信建投证券股份有限公司宜昌解放路证券营业部</td>
</tr>
<tr>
<td>玉兰路</td>
<td>近来崛起的资金席位，接力操作为主，风格激进，擅长龙头股锁仓</td>
<td>东莞证券股份有限公司南京分公司</td>
</tr>
<tr>
<td>独股一剑</td>
<td>网名，独股一剑，天涯论坛最早布道者，影响了一大批后来者，几乎是桃县半数超短手的启蒙老师，最早是天涯直播交割单火起来的。乔帮主便是在07年入市7年之后接触其交割单后顿悟，大开大合，一年过亿的。</td>
<td>华泰证券股份有限公司北京月坛南街证券营业部</td>
</tr>
<tr>
<td>牛散朱彬</td>
<td>朱彬实际控制并使用的账户“朱彬”“朱某宏”和“林某丽”证券账户（以下简称账户组）由朱彬实际控制并使用。其中朱某宏、林某丽是朱彬的父母，账户组内的资金主要为朱彬所有。账户组所使用的交易终端在中泰证券宁波江东北路营业部大户室，与账户组交易资料核对一致，并由朱彬予以确认。</td>
<td>中泰证券股份有限公司宁波江东北路证券营业部</td>
</tr>
<tr>
<td>牛散唐汉若</td>
<td>牛散唐汉若，喜欢巨量出击，创小板玩得不错，但也有乐视网（300104）硬封割肉的时候，敢干敢割死队成员之一，资金量也在10位之上，硬派选手，圈内盛传千股跌停之下7个亿死扛浙富控股。</td>
<td>首创证券股份有限公司北京雍和宫证券营业部、华泰证券股份有限公司北京雍和宫证券营业部</td>
</tr>
<tr>
<td>炒股养家</td>
<td>目前资金量极大，对市场和个股都有很独到的理解力，通道优势较强，常常利用通道使个股一字涨停，隔日高位逐步离场。善于挖掘题材龙头。</td>
<td>浙商证券股份有限公司绍兴解放北路证券营业部、华鑫证券有限责任公司马鞍山分公司、华鑫证券有限责任公司西安南二环证券营业部、华鑫证券有限责任公司珠海海滨南路证券营业部、华鑫证券有限责任公司南昌分公司、华鑫证券有限责任公司北京光华路证券营业部、华鑫证券有限责任公司上海莘庄证券营业部、华鑫证券有限责任公司上海茅台路证券营业部、华鑫证券有限责任公司上海红宝石路证券营业部、华鑫证券有限责任公司上海松江证券营业部、华鑫证券有限责任公司上海宛平南路证券营业部、华创证券有限责任公司上海大连路证券营业部</td>
</tr>
<tr>
<td>炒新一族</td>
<td>市场上专做次新股的几个游资，近期参与了彩讯、锋龙，仙鹤股份的接力，主要是上海的几个席位，分别是上海共和新路、上海武定路、上海澳门路。这几个席位经常联合出动，利用资金优势拉升开板次新，风格也是超短为主，一日游居多。</td>
<td>华泰证券股份有限公司无锡解放西路证券营业部、华泰证券股份有限公司上海静安区广中西路证券营业部、华泰证券股份有限公司上海武定路证券营业部、华泰证券股份有限公司上海普陀区江宁路证券营业部</td>
</tr>
<tr>
<td>湖里大道</td>
<td>厦门一线游资，眼光独到，出手大气</td>
<td>兴业证券股份有限公司厦门湖里大道证券营业部</td>
</tr>
<tr>
<td>湖州劳动路</td>
<td>湖州实力游资，做票以接力居多，风格剽悍，尤好操控，常常与江浙资金联动出没。</td>
<td>华鑫证券有限责任公司湖州劳动路浙北金融中心证券营业部、华鑫证券有限责任公司深圳分公司、华鑫证券有限责任公司南京清凉门大街证券营业部</td>
</tr>
<tr>
<td>温州帮</td>
<td>2016年操作次新股一战成名，手法彪悍，经常连续拉升3个涨停板。操作手法往往多席位联合出动，同时盘踞在数只次新股，建仓迅速，深度控盘，快速对倒拉升。</td>
<td>银泰证券有限责任公司济南大纬二路证券营业部、财信证券股份有限公司上海大连路证券营业部、西南证券股份有限公司温州汤家桥路证券营业部、第一创业证券股份有限公司青岛秦岭路证券营业部、申万宏源证券有限公司温州车站大道证券营业部、申万宏源证券有限公司扬州分公司、平安证券股份有限公司上海常熟路证券营业部、华鑫证券有限责任公司乐清双雁路证券营业部、华泰证券股份有限公司郑州经三路证券营业部、    申万宏源西部证券福州古田路证券营业部</td>
</tr>
<tr>
<td>深股通专用</td>
<td>深港通，是深港股票市场交易互联互通机制的简称，指深圳证券交易所和香港联合交易所有限公司建立技术连接，使内地和香港投资者可以通过当地证券公司或经纪商买卖规定范围内的对方交易所上市的股票。</td>
<td>深股通专用</td>
</tr>
<tr>
<td>深圳帮</td>
<td>深圳营业部做T做的飞起，经常可以看见深圳帮做T，同样活跃还有上海帮、杭州帮，所操作标的彼此之间重合度很高。</td>
<td>财通证券股份有限公司绍兴柯桥区钱清钱门大道证券营业部、恒泰证券股份有限公司深圳梅林路证券营业部、恒泰证券股份有限公司武汉新华路证券营业部、华龙证券股份有限公司深圳民田路证券营业部、华泰证券股份有限公司福州五一北路证券营业部</td>
</tr>
<tr>
<td>涪陵广场路</td>
<td>西南地区，巨型打板游资，资金实力雄厚，出手频率不高，但尤好重仓大手笔出手，风格剽悍，经常单笔近亿，曾在美锦能源、泰禾集团、北斗星通上大手笔出手。</td>
<td>方正证券股份有限公司重庆金开大道证券营业部、中信建投证券股份有限公司重庆涪陵证券营业部</td>
</tr>
<tr>
<td>涅盘重升</td>
<td>90后知名选手，曾有四年百倍战绩</td>
<td>长城证券股份有限公司资阳蜀乡大道证券营业部、上海证券有限责任公司苏州太湖西路证券营业部</td>
</tr>
<tr>
<td>浙江帮</td>
<td>浙江帮的特点是出货的时候下方喜欢挂出非常多的自己的买单，撑住盘面不下跌，再用快速拉升法快速拉高股价，吸引散户追高，用密集的中小单抛货，躲过散户的眼睛，从浙江帮选股的特点来看，他们喜欢选一些低价股，这样会有非常多的买卖单，进出也是非常频繁密集，这样是很容易躲过散户的眼睛的。</td>
<td>西部证券股份有限公司西安高新路证券营业部、申万宏源证券有限公司瑞安罗阳大道证券营业部、浙商证券股份有限公司路桥数码街证券营业部、兴业证券股份有限公司石狮宝岛中路证券营业部、九州证券股份有限公司厦门分公司、万联证券股份有限公司广州番禺清河东路证券营业部</td>
</tr>
<tr>
<td>流沙河</td>
<td>成名于网络论坛，异常活跃的游资席位。专一的打板选手，主做低位板。喜欢做顶板、秒板，快速拉升的分时强势个股。</td>
<td>中信证券股份有限公司北京远大路证券营业部</td>
</tr>
<tr>
<td>沪股通专用</td>
<td>沪港通是指上海证券交易所和香港联合交易所允许两地投资者通过当地证券公司（或经纪商）买卖规定范围内的对方交易所上市的股票，是沪港股票市场交易互联互通机制。</td>
<td>沪股通专用</td>
</tr>
<tr>
<td>毛老板</td>
<td>成都毛老板（现改名塞力斯）对强基本面个股有自己独到的理解，更早之前毛老板是造妖大师金田路，后面转型趋势打法淡出短线市场</td>
<td>申万宏源证券有限公司深圳金田路证券营业部、广发证券股份有限公司上海东方路证券营业部、国泰君安证券股份有限公司北京光华路证券营业部、万和证券股份有限公司成都通盈街证券营业部</td>
</tr>
<tr>
<td>歌神</td>
<td>分时看的准，情绪面把控的很到位。</td>
<td>兴业证券股份有限公司杭州体育场路证券营业部、中国中金财富证券有限公司杭州江河汇证券营业部、中信证券股份有限公司杭州金城路证券营业部</td>
</tr>
<tr>
<td>欢乐海岸</td>
<td>极少涉及首板，一般都是高位板；经常多席位联动，大手笔封单，总额经常上亿；介入后经常锁仓，也不轻易砸盘，往往离场之后尾盘也会拉升进行善后。</td>
<td>第一创业证券股份有限公司深圳福华一路总部证券营业部、招商证券股份有限公司深圳深南大道车公庙证券营业部、广发证券股份有限公司深圳福华一路证券营业部、平安证券股份有限公司深圳金田路证券营业部、国金证券股份有限公司深圳湾一号证券营业部、华泰证券股份有限公司深圳科苑南路华润大厦证券营业部、华泰证券股份有限公司深圳深南大道基金大厦证券营业部、华泰证券股份有限公司深圳分公司、中泰证券股份有限公司深圳科苑南路证券营业部、中泰证券股份有限公司深圳宝源南路证券营业部、中泰证券股份有限公司深圳分公司、中国中金财富证券有限公司深圳宝安兴华路证券营业部、中国中金财富证券有限公司云浮新兴东堤北路证券营业部、中信证券股份有限公司深圳科技园证券营业部、中信证券股份有限公司深圳后海证券营业部、中信证券股份有限公司深圳分公司</td>
</tr>
<tr>
<td>杭州帮</td>
<td>杭州系短线游资，资金量较大，喜欢动用多个营业部同时操作一股，波段操作，整体成功率较高。偏好上市3年以上的老股票，规模上，大盘股与小盘股都是他的最爱，整体分布较为平均。</td>
<td>浙商证券股份有限公司杭州萧山永久路证券营业部、光大证券股份有限公司杭州延安路证券营业部、中国银河证券股份有限公司杭州景芳证券营业部、中国银河证券股份有限公司杭州天城东路证券营业部、中国银河证券股份有限公司杭州凤起路证券营业部、中信证券股份有限公司杭州庆春路证券营业部、中信建投证券股份有限公司杭州庆春路证券营业部</td>
</tr>
<tr>
<td>机构专用</td>
<td>新交易规则规定，机构席位是指基金专用席位、券商自营专用席位、社保专用席位、券商理财专用席位、保险机构专用席位、保险机构租用席位、QFII专用席位等机构投资者买卖证券的专用通道和席位。</td>
<td>机构专用5、机构专用4、机构专用3、机构专用2、机构专用1、机构专用</td>
</tr>
<tr>
<td>方新侠</td>
<td>与赵老哥同期的顶级游资，操作手法大开大合，擅长大成交趋势股。2020年主导了省广集团大二波、未名医药等票。</td>
<td>兴业证券股份有限公司陕西分公司、中信证券股份有限公司西安朱雀大街证券营业部</td>
</tr>
<tr>
<td>新生代</td>
<td>新晋市场主力，擅长低位题材挖掘潜伏及打造板块补涨，通常喜欢提前埋伏底仓。</td>
<td>银泰证券有限责任公司成都顺城大街证券营业部、安信证券股份有限公司广州猎德大道证券营业部、华泰证券股份有限公司上海牡丹江路证券营业部、中国银河证券股份有限公司上海新闸路证券营业部、中信证券(山东)有限责任公司莱州文化东路证券营业部</td>
</tr>
<tr>
<td>敢死队</td>
<td>宁波敢死队主要由4号人物组成,又并称为“超短F4”。1号人物叫徐翔,是敢死队中年纪最轻的一位。2号人物姓吴,大约35岁。两人大约在1999年从其他营业部转到银河证券宁波解放南路营业部,当时资金不过几十万元,4年后,两人账户上的钱都变成了数千万元。3号人物徐海鸥,1975年出生,上大学时就开始炒股,1997年毕业于北京商学院后没找工作,就直接回宁波专职炒股。而马信琪在这三位之前,2002年5月,被临近的天一证券(现为光大证券)解放南路营业部挖走,数位大户亦追随而去。4人并称“超短F4”。敢死队以吃庄家为生,</td>
<td>平安证券股份有限公司深圳深南东路罗湖商务中心证券营业部、中泰证券股份有限公司上海建国中路证券营业部</td>
</tr>
<tr>
<td>撬板王</td>
<td>风格上喜欢撬跌停板，尤其是连续跌停的个股，人称撬板王</td>
<td>兴业证券股份有限公司苏州分公司、兴业证券股份有限公司深圳分公司</td>
</tr>
<tr>
<td>招商深南东</td>
<td>作为国内A股市场游资主力，招商证券深南东路手法相对温和，在选股方面并不热衷于次新股，跟踪上市时间三年以上个股较多，选择热点板块其中的人气个股，但大多为上涨行情还没有启动，或者已进入调整期的个股；其操作套路还是集中优势资金趋势加速，吸引跟盘资金接盘出货。</td>
<td>招商证券股份有限公司深圳深南东路证券营业部</td>
</tr>
<tr>
<td>成都系</td>
<td>超短游资，具备短时间内引导个股价格的能力，风格稳定，以超跌板为主，盘中都是直线拉升涨停，引导资金合力封板。擅长做首板个股并且盘中喜欢直线拉升，次日冲高后爱砸盘，偏爱中小盘个股。</td>
<td>宏信证券有限责任公司成都紫竹北街证券营业部、国融证券股份有限公司青岛分公司、国联证券股份有限公司成都锦城大道证券营业部、国泰君安证券股份有限公司成都天府二街证券营业部、国泰君安证券股份有限公司成都北一环路证券营业部、华泰证券股份有限公司成都天府广场证券营业部、华泰证券股份有限公司德阳长江西路钻石广场证券营业部、中国银河证券股份有限公司成都科华北路证券营业部、中信建投证券股份有限公司成都马家花园证券营业部</td>
</tr>
<tr>
<td>成泉系</td>
<td>做均线多头发散向上的个股并惯提前建仓；涨停板往往不封死，反复打开并再度封板；次日继续涨停概率较低。</td>
<td>华泰证券股份有限公司北京西三环国际财经中心证券营业部、中泰证券股份有限公司北京自贸试验区证券营业部、中国国际金融股份有限公司北京建国门外大街证券营业部、中信证券股份有限公司北京金融大街证券营业部</td>
</tr>
<tr>
<td>思明南路</td>
<td>2022年90后游资，风格多变但选股水平极高，参与的个股大多有基本面支撑。</td>
<td>东莞证券股份有限公司湖北分公司、东亚前海证券有限责任公司上海分公司</td>
</tr>
<tr>
<td>徐留胜</td>
<td>著名牛散、顶级游资徐留胜，曾被证监会处罚罚没1.1亿。通常喜好大手笔出手后波段锁仓</td>
<td>华泰证券股份有限公司深圳益田路荣超商务中心证券营业部</td>
</tr>
<tr>
<td>徐晓</td>
<td>大手笔、低频率、资金实力雄厚、出手胜率极高，有主导热点板块龙头股趋势行情的能力</td>
<td>国元证券股份有限公司上海虹桥路证券营业部</td>
</tr>
<tr>
<td>广东帮</td>
<td>操作手法上习惯用“大阳线——调整数日——大阳线”反复拉升</td>
<td>财通证券股份有限公司温岭中华路证券营业部、申万宏源证券有限公司杭州密渡桥路证券营业部、申万宏源证券有限公司上海黄浦区中华路证券营业部、德邦证券股份有限公司上海岳州路证券营业部、华福证券有限责任公司厦门湖滨南路证券营业部、东方证券股份有限公司上海黄浦区中华路证券营业部</td>
</tr>
<tr>
<td>山东帮</td>
<td>因为当时山东席位为旗舰，故被称为“山东帮”，次新股手法,往往是多席位联合行动,同时盘踞在数只次新股上面,建仓迅速,深度控盘,快速对倒拉升。</td>
<td>方正证券股份有限公司温州小南路证券营业部、广发证券股份有限公司荣成石岛证券营业部、国海证券股份有限公司济宁邹城市太平东路证券营业部、国海证券股份有限公司济南历山路证券营业部、国海证券股份有限公司泰安擂鼓石大街证券营业部、国海证券股份有限公司山东分公司、华泰证券股份有限公司厦门厦禾路证券营业部、中泰证券股份有限公司荣成石岛黄海中路证券营业部、中信证券股份有限公司厦门分公司、中信证券(山东)有限责任公司荣成成山大道证券营业部、东海证券股份有限公司厦门祥福路证券营业部、东方证券股份有限公司厦门仙岳路证券营业部</td>
</tr>
<tr>
<td>屠文斌</td>
<td>屠文斌是叱咤风云的老牌游资，偏好大流通的板块中军，可观察其出手来判断板块地位。</td>
<td>中国银河证券股份有限公司上海杨浦区靖宇东路证券营业部</td>
</tr>
<tr>
<td>小鳄鱼</td>
<td>新生代90后游资，常常活跃在各大论坛社区，手法剽悍，资金体量过亿。在趋势性行情下也能与时俱进，对基本面的理解非常不错，胜率较高。</td>
<td>长江证券股份有限公司上海世纪大道证券营业部、南京证券股份有限公司南京大钟亭证券营业部、中国中金财富证券有限公司南京龙蟠中路证券营业部、东方证券股份有限公司上海浦东新区源深路证券营业部</td>
</tr>
<tr>
<td>小棉袄</td>
<td>价值投机型顶级选手，从钠电池到人工智能。逻辑牛股一个不落</td>
<td>上海证券有限责任公司上海分公司</td>
</tr>
<tr>
<td>宁波解放南</td>
<td>老牌游资席位，江浙宁波敢死队资金，喜好万手倒序单联排打板，冲击制造涨停的股票，买卖市场活跃情绪标</td>
<td>光大证券股份有限公司宁波解放南路证券营业部</td>
</tr>
<tr>
<td>宁波桑田路</td>
<td>宁波知名的游资，资金量超过10亿，操作风格彪悍凌厉，是众多知名游资里面溢价比较高的席位，交易风格多为打板为主，不拘泥于是高位板，还是低位板，可以锁仓做T很久，也可以跑的飞快</td>
<td>国盛证券有限责任公司宁波桑田路证券营业部</td>
</tr>
<tr>
<td>宁波和源路</td>
<td>杀伐果断的短线选手，高位接力敢于重仓，对日内情绪节点有深刻认识，一旦个股预期走弱出货也是毫不拖泥带水。此前常用该席位的短线资金已纷纷退出，但仍有大量通道资金在使用有关席位，主要用于排一字板。</td>
<td>甬兴证券有限公司宁波和源路证券营业部</td>
</tr>
<tr>
<td>境外机构</td>
<td>境外机构是指境外官方、非官方金融机构、金融组织以及投资基金，其通过QFII和RQFII获准投资或港股通等通道投资A股市场。其资金体量大而擅长中长线投资，爱好核心资产投资。</td>
<td>瑞银证券有限责任公司上海花园石桥路证券营业部、海通证券股份有限公司国际部、国泰君安证券股份有限公司总部、北京高华证券有限责任公司北京金融大街证券营业部</td>
</tr>
<tr>
<td>和平路</td>
<td>喜欢重仓出击妖股、龙头股，且喜欢波段操作；擅长趋势交易，打板，半路，低吸</td>
<td>东兴证券股份有限公司晋江和平路证券营业部</td>
</tr>
<tr>
<td>叶庆均</td>
<td>叶庆均席位，这个席位做的股票大都是热门风口股。</td>
<td>中国银河证券股份有限公司宁波大闸南路证券营业部</td>
</tr>
<tr>
<td>古北路</td>
<td>顶级游资，2016年11月份前还默默无闻，随后却异军突起，成为龙虎榜常客，在年初的雄安板块炒作中一战成名，擅长制造板块行情，和其他一线游资联动，敢于锁仓，隐藏身后的游资大佬，孙氏父子、赵老哥分身席位诸多传言，江湖多揣测。</td>
<td>中信证券股份有限公司上海红宝石路证券营业部、中信证券股份有限公司上海牡丹江路证券营业部、中信证券股份有限公司上海凯滨路证券营业部</td>
</tr>
<tr>
<td>华鑫宁波分</td>
<td>1、确定主线热点题材，选择强势个股低吸。2、确定题材龙头，会进行打板，享受龙头溢价。3、锁定市场主线热点，敢于持续锁仓等待其发酵拉抬。4、利用交易通道优势，一字排板上市新股炒作与利好复牌个股。敢于主动引导市场，资金格局较大</td>
<td>华鑫证券有限责任公司宁波分公司</td>
</tr>
<tr>
<td>北京炒家</td>
<td>北京炒家，网传是前字节跳动员工，擅长自媒体运营，听声音年龄应该是80后之间</td>
<td>长城证券股份有限公司绵阳飞云大道证券营业部</td>
</tr>
<tr>
<td>北京帮</td>
<td>有大格局的游资，资金雄厚。</td>
<td>海通证券股份有限公司北京知春路营业部、招商证券股份有限公司北京车公庄西路证券营业部、广发证券股份有限公司潮州潮枫路证券营业部、中国银河证券股份有限公司北京朝阳门北大街证券营业部、万和证券股份有限公司成都蜀汉路证券营业部</td>
</tr>
<tr>
<td>列夫</td>
<td>从市场最整体到情绪整体、板块整体、个股个性、高低位置，主做市场龙头</td>
<td>海通证券股份有限公司绍兴劳动路证券营业部</td>
</tr>
<tr>
<td>作手新一</td>
<td>新生代小游资，资金体量相对较小，但常常活跃在各大社交论坛，知名度相对较高。</td>
<td>国泰君安证券股份有限公司南京太平南路证券营业部、中国中金财富证券有限公司南京中央路证券营业部</td>
</tr>
<tr>
<td>佛山系</td>
<td>能够在短时间内主导个股走势，风格超短，嗅觉敏感。擅长短线，早盘快速拉板，制造日内龙头，一根线拉板，从小资金做起的典范。擅长做一板个股，往往以一日游为主，次日冲高快速获利出局；</td>
<td>长江证券股份有限公司武汉武珞路证券营业部、长江证券股份有限公司惠州金山湖证券营业部、长江证券股份有限公司佛山普澜二路证券营业部、诚通证券股份有限公司佛山南海大道证券营业部、湘财证券股份有限公司佛山星辰路证券营业部、海通证券股份有限公司广州珠江西路证券营业部、方正证券股份有限公司北京安定门外大街证券营业部、国盛证券有限责任公司合肥翠微路证券营业部、国泰君安证券股份有限公司顺德大良证券营业部、华泰证券股份有限公司广州兴民路证券营业部、光大证券股份有限公司佛山绿景路证券营业部、光大证券股份有限公司佛山季华六路证券营业部、东莞证券股份有限公司东莞横沥中山东路证券营业部、    长江证券股份有限公司佛山南海大道证券营业部</td>
</tr>
<tr>
<td>余哥</td>
<td>2022年新晋游资，95后，资金增长速度之快令人咋舌，擅长机构游资合力大妖股，市场理解力顶级。</td>
<td>申港证券股份有限公司浙江分公司、甬兴证券有限公司青岛同安路证券营业部</td>
</tr>
<tr>
<td>交易猿</td>
<td>操作手法，大多都是满仓资金梭哈一只股票，且这只股票前期已经有巨大涨幅，流通盘、成交量巨大的大票，做大票的半路主升浪。\r\n\r\n</td>
<td>华泰证券股份有限公司天津东丽开发区二纬路证券营业部</td>
</tr>
<tr>
<td>乔帮主</td>
<td>一线游资，资金量上亿，风格凶悍，纪律严格，低吸配合打板。</td>
<td>招商证券股份有限公司深圳蛇口工业三路证券营业部</td>
</tr>
<tr>
<td>中信总部</td>
<td>中信证券股份有限公司总部(非营业场所)</td>
<td>中信证券股份有限公司总部(非营业场所)</td>
</tr>
<tr>
<td>上海超短帮</td>
<td>以短线速度建仓吸凑,持股周期在3-5日内,经常协同机构专用席位拉升；资金实力雄厚，通常选取一些有明显的基本面支撑的标的，携手机构席位，以小波段运作为主，整体成功率较高</td>
<td>申万宏源证券有限公司上海闵行区东川路证券营业部、国泰君安证券股份有限公司济宁吴泰闸路证券营业部、国泰君安证券股份有限公司上海新闸路证券营业部、东方证券股份有限公司无锡新生路证券营业部、东方证券股份有限公司上海浦东新区银城中路证券营业部</td>
</tr>
<tr>
<td>上海溧阳路</td>
<td>老牌游资席位，整体席位资金较杂，多路资金并存，但是总体已超短隔夜操作为主，资金实力雄厚，体量较大，具体的操盘手法是喜欢操作龙头股，找到龙头后，反复进出看好的个股。</td>
<td>中信证券股份有限公司上海溧阳路证券营业部</td>
</tr>
<tr>
<td>上塘路</td>
<td>顶级节奏大师，市场上扫板封板率最高的几路资金之一。整体操作以套利为主，稳中求进，纪律严明。上塘对次新的理解非常之深，擅长把握市场情绪，对首板的理解也居市场前列</td>
<td>财通证券股份有限公司杭州上塘路证券营业部</td>
</tr>
<tr>
<td>一瞬流光</td>
<td>擅长龙头战法，分歧买入，跟随趋势，波段买卖</td>
<td>浙商证券股份有限公司海宁水月亭西路证券营业部、中泰证券股份有限公司湖北分公司</td>
</tr>
<tr>
<td>zhouyu1933</td>
<td></td>
<td>长城证券股份有限公司仙桃钱沟路证券营业部</td>
</tr>
<tr>
<td>T王</td>
<td>此类席位每天做T，其乐无穷。</td>
<td>国金证券股份有限公司上海奉贤区金碧路证券营业部、国金证券股份有限公司上海互联网证券分公司、东方财富证券股份有限公司拉萨团结路第二证券营业部、东方财富证券股份有限公司拉萨团结路第一证券营业部、东方财富证券股份有限公司拉萨东环路第二证券营业部、东方财富证券股份有限公司拉萨东环路第一证券营业部、东方财富证券股份有限公司拉萨东城区江苏大道证券营业部、东方财富证券股份有限公司山南香曲东路证券营业部</td>
</tr>
<tr>
<td>N周二</td>
<td>擅长低吸和打板，短线趋势交易</td>
<td>中信证券股份有限公司杭州凤起路证券营业部</td>
</tr>
<tr>
<td>bike770</td>
<td>论坛知名短线选手，小资金做大的典范，曾完成四年一千倍的超级战绩。</td>
<td>国泰君安证券股份有限公司南宁民族大道证券营业部</td>
</tr>
<tr>
<td>Asking</td>
<td></td>
<td>兴业证券股份有限公司福州湖东路证券营业部</td>
</tr>
<tr>
<td>92科比</td>
<td>淘股吧知名选手，理解力惊人，完全理解投机本质，真正为交易而生。低吸、追涨、打板样样精通，是典型的打板高手，根据市场所处阶段切换手法。</td>
<td>兴业证券股份有限公司南京天元东路证券营业部</td>
</tr>
</tbody></table>