# 实时排名（爬虫）

**文档ID**: 317
**原始链接**: https://tushare.pro/document/2?doc_id=317

---

## 实时涨跌幅排名(爬虫版)

接口：realtime_list，由于采集和拼接当日以来的成交全历史，因此接口提取数据时需要一定时间，请耐心等待，请将tushare升级到1.3.3版本以上。描述：本接口是tushare org版实时接口的顺延，数据来自网络，且不进入tushare服务器，属于爬虫接口，数据包括该股票当日开盘以来的所有分笔成交数据。权限：0积分完全开放，但需要有tushare账号，如果没有账号请先注册。说明：由于该接口是纯爬虫程序，跟tushare服务器无关，因此tushare不对数据内容和质量负责。数据主要用于研究和学习使用，如做商业目的，请自行解决合规问题。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>src</td>
<td>str</td>
<td>N</td>
<td>数据源 （sina-新浪 dc-东方财富，默认dc）</td>
</tr>
</tbody></table>
东财数据输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>股票名称</td>
</tr>
<tr>
<td>price</td>
<td>float</td>
<td>当前价格</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>涨跌额</td>
</tr>
<tr>
<td>volume</td>
<td>int</td>
<td>成交量（单位：手）</td>
</tr>
<tr>
<td>amount</td>
<td>int</td>
<td>成交金额（元）</td>
</tr>
<tr>
<td>swing</td>
<td>float</td>
<td>振幅</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>今日最低价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>今日最高价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>今日开盘价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>今日收盘价</td>
</tr>
<tr>
<td>vol_ratio</td>
<td>int</td>
<td>量比</td>
</tr>
<tr>
<td>turnover_rate</td>
<td>float</td>
<td>换手率</td>
</tr>
<tr>
<td>pe</td>
<td>int</td>
<td>市盈率PE</td>
</tr>
<tr>
<td>pb</td>
<td>float</td>
<td>市净率PB</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>总市值（元）</td>
</tr>
<tr>
<td>float_mv</td>
<td>float</td>
<td>流通市值（元）</td>
</tr>
<tr>
<td>rise</td>
<td>float</td>
<td>涨速</td>
</tr>
<tr>
<td>5min</td>
<td>float</td>
<td>5分钟涨幅</td>
</tr>
<tr>
<td>60day</td>
<td>float</td>
<td>60天涨幅</td>
</tr>
<tr>
<td>1tyear</td>
<td>float</td>
<td>1年涨幅</td>
</tr>
</tbody></table>
新浪数据输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>股票名称</td>
</tr>
<tr>
<td>price</td>
<td>float</td>
<td>当前价格</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>涨跌额</td>
</tr>
<tr>
<td>buy</td>
<td>float</td>
<td>买入价</td>
</tr>
<tr>
<td>sale</td>
<td>float</td>
<td>卖出价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>今日收盘价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>今日开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>今日最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>今日最低价</td>
</tr>
<tr>
<td>volume</td>
<td>int</td>
<td>成交量（单位：股）</td>
</tr>
<tr>
<td>amount</td>
<td>int</td>
<td>成交金额（元）</td>
</tr>
<tr>
<td>time</td>
<td>str</td>
<td>当前时间</td>
</tr>
</tbody></table>
接口用法

```

import tushare as ts

#东财数据
df = ts.realtime_list(src='dc')


#sina数据
df = ts.realtime_list(src='sina')

```
