# 实时成交（爬虫）

**文档ID**: 316
**原始链接**: https://tushare.pro/document/2?doc_id=316

---

## 实时成交数据(爬虫版)

接口：realtime_tick，由于采集和拼接当日以来的成交全历史，因此接口提取数据时需要一定时间，请耐心等待。请将tushare升级到1.3.3版本以上。描述：本接口是tushare org版实时接口的顺延，数据来自网络，且不进入tushare服务器，属于爬虫接口，数据包括该股票当日开盘以来的所有分笔成交数据。权限：0积分完全开放，但需要有tushare账号，如果没有账号请先注册。说明：由于该接口是纯爬虫程序，跟tushare服务器无关，因此tushare不对数据内容和质量负责。数据主要用于研究和学习使用，如做商业目的，请自行解决合规问题。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码，需按tushare<a href="https://tushare.pro/document/2?doc_id=14">股票代码标准</a>输入，比如：000001.SZ表示平安银行，600000.SH表示浦发银行，单次只能输入一个股票</td>
</tr>
<tr>
<td>src</td>
<td>str</td>
<td>N</td>
<td>数据源 （sina-新浪 dc-东方财富，默认sina）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>time</td>
<td>str</td>
<td>交易时间</td>
</tr>
<tr>
<td>price</td>
<td>float</td>
<td>现价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>价格变动</td>
</tr>
<tr>
<td>volume</td>
<td>int</td>
<td>成交量（单位：手）</td>
</tr>
<tr>
<td>amount</td>
<td>int</td>
<td>成交金额（元）</td>
</tr>
<tr>
<td>type</td>
<td>str</td>
<td>类型：买入/卖出/中性</td>
</tr>
</tbody></table>
接口用法

```

import tushare as ts

#设置你的token，登录tushare在个人用户中心里拷贝
ts.set_token('你的token')

#sina数据
df = ts.realtime_tick(ts_code='600000.SH')


#东财数据
df = ts.realtime_tick(ts_code='600000.SH', src='dc')

```

数据样例

```
      TIME      PRICE  CHANGE  VOLUME   AMOUNT TYPE
0     09:25:01   6.57   -0.01     429   281853   卖盘
1     09:30:01   6.56   -0.01      42    27552   卖盘
2     09:30:04   6.58    0.02      57    37597   买盘
3     09:30:07   6.57   -0.01      61    40077   卖盘
4     09:30:10   6.58    0.01     867   569936   买盘
...        ...    ...     ...     ...      ...  ...
3749  14:56:40   6.58   -0.02     112    73696   卖盘
3750  14:56:46   6.60    0.02      64    42240   买盘
3751  14:56:49   6.60    0.00      11     7260   买盘
3752  14:56:52   6.60    0.00      18    11880   买盘
3753  15:00:01   6.58   -0.02    2107  1386406   买盘

```
