# 实时分钟行情

**文档ID**: 340
**原始链接**: https://tushare.pro/document/2?doc_id=340

---

## 期货实时分钟行情

接口：rt_fut_min描述：获取全市场期货合约实时分钟数据，支持1min/5min/15min/30min/60min行情，提供Python SDK、 http Restful API和websocket三种方式，如果需要主力合约分钟，请先通过主力mapping接口获取对应的合约代码后提取分钟。限量：每分钟可以请求500次，支持多个合约同时提取权限：需单独开权限，正式权限请参阅权限说明。

rt_fut_min输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码，e.g.CU2310.SHF，支持多个合约（逗号分隔）</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>分钟频度（1MIN/5MIN/15MIN/30MIN/60MIN）</td>
</tr>
</tbody></table>
同时提供当日开市以来所有历史分钟（即：分钟快照回放），接口名：rt_fut_min_daily，只支持一个个合约提取。

rt_fut_min_daily输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码，e.g.CU2310.SHF，仅支持一次一个合约的回放</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>分钟频度（1MIN/5MIN/15MIN/30MIN/60MIN）</td>
</tr>
<tr>
<td>date_str</td>
<td>str</td>
<td>N</td>
<td>回放日期（格式：YYYY-MM-DD，默认为交易当日，支持回溯一天）</td>
</tr>
</tbody></table>
freq参数说明

<table>
<thead>
<tr>
<th>freq</th>
<th>说明</th>
</tr>
</thead>
<tbody><tr>
<td>1MIN</td>
<td>1分钟</td>
</tr>
<tr>
<td>5MIN</td>
<td>5分钟</td>
</tr>
<tr>
<td>15MIN</td>
<td>15分钟</td>
</tr>
<tr>
<td>30MIN</td>
<td>30分钟</td>
</tr>
<tr>
<td>60MIN</td>
<td>60分钟</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>频度</td>
</tr>
<tr>
<td>time</td>
<td>str</td>
<td>Y</td>
<td>交易时间</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>vol</td>
<td>int</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额</td>
</tr>
<tr>
<td>oi</td>
<td>float</td>
<td>Y</td>
<td>持仓量</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

#单个合约
df = pro.df = pro.rt_fut_min(ts_code='CU2501.SHF', freq='1MIN')

#多个合约
df = pro.df = pro.rt_fut_min(ts_code='CU2501.SHF,CU2502.SHF', freq='1MIN')

```
