# 实时分钟

**文档ID**: 374
**原始链接**: https://tushare.pro/document/2?doc_id=374

---

## A股实时分钟

接口：rt_min描述：获取全A股票实时分钟数据，包括1~60min限量：单次最大1000行数据，可以通过股票代码提取数据，支持逗号分隔的多个代码同时提取权限：正式权限请参阅权限说明

注：支持股票当日开盘以来的所有历史分钟数据提取，接口名：rt_min_daily（仅支持一个个股票提取，不同同时提取多个）

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>1MIN,5MIN,15MIN,30MIN,60MIN （大写）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>支持单个和多个：600000.SH 或者 600000.SH,000001.SZ</td>
</tr>
</tbody></table>
freq参数说明

<table>
<thead>
<tr>
<th>freq</th>
<th>说明</th>
</tr>
</thead>
<tbody><tr>
<td>1MIN</td>
<td>1分钟</td>
</tr>
<tr>
<td>5MIN</td>
<td>5分钟</td>
</tr>
<tr>
<td>15MIN</td>
<td>15分钟</td>
</tr>
<tr>
<td>30MIN</td>
<td>30分钟</td>
</tr>
<tr>
<td>60MIN</td>
<td>60分钟</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>time</td>
<td>None</td>
<td>Y</td>
<td>交易时间</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量(股）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额（元）</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

#获取浦发银行60000.SH的实时分钟数据
df = pro.rt_min(ts_code='600000.SH', freq='1MIN')

```
