# 大盘指数每日指标

**文档ID**: 128
**原始链接**: https://tushare.pro/document/2?doc_id=128

---

## 大盘指数每日指标

接口：index_dailybasic，可以通过数据工具调试和查看数据。描述：目前只提供上证综指，深证成指，上证50，中证500，中小板指，创业板指的每日指标数据数据来源：Tushare社区统计计算数据历史：从2004年1月开始提供数据权限：用户需要至少400积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期 （格式：YYYYMMDD，比如20181018，下同）</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
注：trade_date，ts_code 至少要输入一个参数，单次限量3000条（即，单一指数单次可提取超过12年历史），总量不限制。

输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>Y</td>
<td>当日总市值（元）</td>
</tr>
<tr>
<td>float_mv</td>
<td>float</td>
<td>Y</td>
<td>当日流通市值（元）</td>
</tr>
<tr>
<td>total_share</td>
<td>float</td>
<td>Y</td>
<td>当日总股本（股）</td>
</tr>
<tr>
<td>float_share</td>
<td>float</td>
<td>Y</td>
<td>当日流通股本（股）</td>
</tr>
<tr>
<td>free_share</td>
<td>float</td>
<td>Y</td>
<td>当日自由流通股本（股）</td>
</tr>
<tr>
<td>turnover_rate</td>
<td>float</td>
<td>Y</td>
<td>换手率</td>
</tr>
<tr>
<td>turnover_rate_f</td>
<td>float</td>
<td>Y</td>
<td>换手率(基于自由流通股本)</td>
</tr>
<tr>
<td>pe</td>
<td>float</td>
<td>Y</td>
<td>市盈率</td>
</tr>
<tr>
<td>pe_ttm</td>
<td>float</td>
<td>Y</td>
<td>市盈率TTM</td>
</tr>
<tr>
<td>pb</td>
<td>float</td>
<td>Y</td>
<td>市净率</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.index_dailybasic(trade_date='20181018', fields='ts_code,trade_date,turnover_rate,pe')

```

数据示例

```
    ts_code  trade_date  turnover_rate     pe
0  000001.SH   20181018           0.38  11.92
1  000300.SH   20181018           0.27  11.17
2  000905.SH   20181018           0.82  18.03
3  399001.SZ   20181018           0.88  17.48
4  399005.SZ   20181018           0.85  21.43
5  399006.SZ   20181018           1.50  29.56
6  399016.SZ   20181018           1.06  18.86
7  399300.SZ   20181018           0.27  11.17
```
