# 大宗交易明细

**文档ID**: 272
**原始链接**: https://tushare.pro/document/2?doc_id=272

---

## 大宗交易明细

接口：bond_blk_detail权限：用户满5000积分有数据权限，单次最大1000条，可根据日期循环提取，总量不限制描述：获取沪深交易所债券大宗交易数据，可以通过数据工具调试和查看数据。

注：本接口目前只有深交所的大宗交易明细，上交所明细已经包含在大宗交易接口里，未单独罗列。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>债券代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>债券代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>债券名称</td>
</tr>
<tr>
<td>price</td>
<td>float</td>
<td>Y</td>
<td>成交价（元）</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交数量（万股/万份/万张/万手）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额（万元）</td>
</tr>
<tr>
<td>buy_dp</td>
<td>str</td>
<td>Y</td>
<td>买方营业部</td>
</tr>
<tr>
<td>sell_dp</td>
<td>str</td>
<td>Y</td>
<td>卖方营业部</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.bond_blk_detail(start_date='20210701', end_date='20210930')

```

数据样例

```
     trade_date  ts_code    name     price     vol    amount                        buy_dp          sell_dp
0     20210930  149642.SZ  21长城08  100.07   50.00   5003.50                       机构专用             机构专用
1     20210930  149642.SZ  21长城08  100.00   65.00   6500.00                       机构专用             机构专用
2     20210930  149641.SZ  21长城07  100.00  100.00  10000.00                       机构专用             机构专用
3     20210930  149633.SZ  21广发10   99.83   25.00   2495.75                       机构专用             机构专用
4     20210930  149633.SZ  21广发10   99.82   25.00   2495.50                       机构专用             机构专用
..         ...        ...     ...     ...     ...       ...                        ...              ...
995   20210924  138246.SZ  东道02D1  110.17   26.30   2897.47  中国国际金融股份有限公司上海黄浦区湖滨路证券营业部             机构专用
996   20210924  137995.SZ  21即墨A3  101.75   15.00   1526.25      华泰证券股份有限公司临沂金雀山路证券营业部             机构专用
997   20210924  137995.SZ  21即墨A3  101.74   15.00   1526.10                       机构专用             机构专用
998   20210924  137995.SZ  21即墨A3  101.73   15.00   1525.95                       机构专用  华泰证券股份有限公司山东分公司
999   20210924  137942.SZ   美满03次  103.61   30.00   3108.30  中国国际金融股份有限公司上海黄浦区湖滨路证券营业部
```
