# 大宗交易

**文档ID**: 271
**原始链接**: https://tushare.pro/document/2?doc_id=271

---

## 债券大宗交易

接口：bond_blk权限：用户满5000积分有数据权限，单次最大1000条，可根据日期循环提取，总量不限制描述：获取沪深交易所债券大宗交易数据，可以通过数据工具调试和查看数据。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>债券代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>债券代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>债券名称</td>
</tr>
<tr>
<td>price</td>
<td>float</td>
<td>Y</td>
<td>成交价（元）</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>累计成交数量（万股/万份/万张/万手）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>累计成交金额（万元）</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.bond_blk(start_date='20210701', end_date='20210930')

```

数据样例

```
    trade_date    ts_code    name     price    vol    amount
0     20210930  152497.SH   20黔西南   75.00  35.00  2625.00
1     20210930  152497.SH   20黔西南   75.00  20.00  1500.00
2     20210930  152497.SH   20黔西南   75.00  19.20  1440.00
3     20210930  152497.SH   20黔西南   75.00  18.00  1350.00
4     20210930  152497.SH   20黔西南   75.00  17.00  1275.00
..         ...        ...     ...     ...    ...      ...
995   20210917  136225.SZ   21奥创A   99.98   6.50   649.90
996   20210917  133073.SZ  21经开02   99.34  10.00   993.40
997   20210917  133068.SZ  21九江01  100.18  50.00  5009.05
998   20210917  133063.SZ  21新沂04  100.56   6.47   650.63
999   20210917  133050.SZ  21江滨01  100.25  50.00  5012.50
```
