# 外汇日线行情

**文档ID**: 179
**原始链接**: https://tushare.pro/document/2?doc_id=179

---

## 外汇日线行情

接口：fx_daily描述：获取外汇日线行情限量：单次最大提取1000行记录，可多次提取，总量不限制积分：用户需要至少2000积分才可以调取，但有流量控制，5000积分以上频次相对较高，积分越多权限越大，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（GMT，日期是格林尼治时间，比北京时间晚一天）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期（GMT）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期（GMT）</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易商，目前只有FXCM</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>外汇代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>bid_open</td>
<td>float</td>
<td>Y</td>
<td>买入开盘价</td>
</tr>
<tr>
<td>bid_close</td>
<td>float</td>
<td>Y</td>
<td>买入收盘价</td>
</tr>
<tr>
<td>bid_high</td>
<td>float</td>
<td>Y</td>
<td>买入最高价</td>
</tr>
<tr>
<td>bid_low</td>
<td>float</td>
<td>Y</td>
<td>买入最低价</td>
</tr>
<tr>
<td>ask_open</td>
<td>float</td>
<td>Y</td>
<td>卖出开盘价</td>
</tr>
<tr>
<td>ask_close</td>
<td>float</td>
<td>Y</td>
<td>卖出收盘价</td>
</tr>
<tr>
<td>ask_high</td>
<td>float</td>
<td>Y</td>
<td>卖出最高价</td>
</tr>
<tr>
<td>ask_low</td>
<td>float</td>
<td>Y</td>
<td>卖出最低价</td>
</tr>
<tr>
<td>tick_qty</td>
<td>int</td>
<td>Y</td>
<td>报价笔数</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易商</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()


#获取美元人民币交易对的日线行情
df = pro.fx_daily(ts_code='USDCNH.FXCM', start_date='20190101', end_date='20190524')

```

数据示例

```
         ts_code trade_date  bid_open  bid_close  bid_high  bid_low  ask_open  \
0    USDCNH.FXCM   20190524    6.9261     6.9326    6.9342   6.9248    6.9277   
1    USDCNH.FXCM   20190523    6.9309     6.9261    6.9431   6.9253    6.9376   
2    USDCNH.FXCM   20190522    6.9334     6.9309    6.9409   6.9236    6.9348   
3    USDCNH.FXCM   20190521    6.9373     6.9334    6.9463   6.9205    6.9408   
4    USDCNH.FXCM   20190520    6.9366     6.9373    6.9459   6.9358    6.9373   
5    USDCNH.FXCM   20190517    6.9259     6.9476    6.9489   6.9211    6.9313   
6    USDCNH.FXCM   20190516    6.9029     6.9259    6.9315   6.9011    6.9079   
7    USDCNH.FXCM   20190515    6.9029     6.9029    6.9173   6.8937    6.9050   
8    USDCNH.FXCM   20190514    6.9114     6.9029    6.9191   6.8872    6.9128   
9    USDCNH.FXCM   20190513    6.8628     6.9114    6.9183   6.8628    6.8642   
10   USDCNH.FXCM   20190510    6.8341     6.8424    6.8646   6.8166    6.8409   
11   USDCNH.FXCM   20190509    6.8052     6.8341    6.8636   6.8012    6.8096   
12   USDCNH.FXCM   20190508    6.7941     6.8052    6.8101   6.7810    6.7958   
13   USDCNH.FXCM   20190507    6.7699     6.7941    6.8021   6.7699    6.7772   
14   USDCNH.FXCM   20190506    6.8017     6.7699    6.8213   6.7679    6.8037   
15   USDCNH.FXCM   20190503    6.7451     6.7335    6.7508   6.7333    6.7457   
16   USDCNH.FXCM   20190502    6.7322     6.7471    6.7476   6.7250    6.7343   
17   USDCNH.FXCM   20190501    6.7360     6.7322    6.7409   6.7177    6.7379   
18   USDCNH.FXCM   20190430    6.7383     6.7360    6.7485   6.7347    6.7393   
19   USDCNH.FXCM   20190429    6.7357     6.7383    6.7447   6.7325    6.7362   
20   USDCNH.FXCM   20190426    6.7488     6.7342    6.7503   6.7280    6.7515   

     ask_close  ask_high  ask_low  tick_qty  
0       6.9330    6.9347   6.9252     18080  
1       6.9277    6.9436   6.9261    105229  
2       6.9376    6.9414   6.9242    111350  
3       6.9348    6.9468   6.9209    222996  
4       6.9408    6.9465   6.9362     79531  
5       6.9490    6.9495   6.9217    157554  
6       6.9313    6.9328   6.9021    120162  
7       6.9079    6.9179   6.8943    121021  
8       6.9050    6.9201   6.8880    300896  
9       6.9128    6.9186   6.8639    155367  
10      6.8469    6.8651   6.8177    229059  
11      6.8409    6.8639   6.8016    205422  
12      6.8096    6.8105   6.7815    147058  
13      6.7958    6.8026   6.7722    310025  
14      6.7772    6.8224   6.7685    165912  
15      6.7351    6.7528   6.7339     88842  
16      6.7478    6.7483   6.7256     99287  
17      6.7343    6.7442   6.7183     94834  
18      6.7379    6.7491   6.7362    163001  
19      6.7393    6.7452   6.7331     60621  
20      6.7437    6.7515   6.7285    133640  

```
