# 外汇基础信息（海外）

**文档ID**: 178
**原始链接**: https://tushare.pro/document/2?doc_id=178

---

## 外汇基础信息（海外）

接口：fx_obasic描述：获取海外外汇基础信息，目前只有FXCM交易商的数据数量：单次可提取全部数据积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>交易商</td>
</tr>
<tr>
<td>classify</td>
<td>str</td>
<td>N</td>
<td>分类</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
</tbody></table>
classify分类说明

<table>
<thead>
<tr>
<th>序号</th>
<th>分类代码</th>
<th>分类名称</th>
<th>样例</th>
</tr>
</thead>
<tbody><tr>
<td>1</td>
<td>FX</td>
<td>外汇货币对</td>
<td>USDCNH（美元人民币对）</td>
</tr>
<tr>
<td>2</td>
<td>INDEX</td>
<td>指数</td>
<td>US30（美国道琼斯工业平均指数）</td>
</tr>
<tr>
<td>3</td>
<td>COMMODITY</td>
<td>大宗商品</td>
<td>SOYF（大豆）</td>
</tr>
<tr>
<td>4</td>
<td>METAL</td>
<td>金属</td>
<td>XAUUSD （黄金）</td>
</tr>
<tr>
<td>5</td>
<td>BUND</td>
<td>国库债券</td>
<td>Bund（长期欧元债券）</td>
</tr>
<tr>
<td>6</td>
<td>CRYPTO</td>
<td>加密数字货币</td>
<td>BTCUSD (比特币)</td>
</tr>
<tr>
<td>7</td>
<td>FX_BASKET</td>
<td>外汇篮子</td>
<td>USDOLLAR （美元指数）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>外汇代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>名称</td>
</tr>
<tr>
<td>classify</td>
<td>str</td>
<td>Y</td>
<td>分类</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>交易商</td>
</tr>
<tr>
<td>min_unit</td>
<td>float</td>
<td>Y</td>
<td>最小交易单位</td>
</tr>
<tr>
<td>max_unit</td>
<td>float</td>
<td>Y</td>
<td>最大交易单位</td>
</tr>
<tr>
<td>pip</td>
<td>float</td>
<td>Y</td>
<td>点</td>
</tr>
<tr>
<td>pip_cost</td>
<td>float</td>
<td>Y</td>
<td>点值</td>
</tr>
<tr>
<td>traget_spread</td>
<td>float</td>
<td>Y</td>
<td>目标差价</td>
</tr>
<tr>
<td>min_stop_distance</td>
<td>float</td>
<td>Y</td>
<td>最小止损距离（点子）</td>
</tr>
<tr>
<td>trading_hours</td>
<td>str</td>
<td>Y</td>
<td>交易时间</td>
</tr>
<tr>
<td>break_time</td>
<td>str</td>
<td>Y</td>
<td>休市时间</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#获取差价合约(CFD)中指数产的基础信息
df = pro.fx_obasic(exchange='FXCM', classify='INDEX', fields='ts_code,name,min_unit,max_unit,pip,pip_cost')

```

数据示例

```
        ts_code                  name     min_unit  max_unit  pip  pip_cost
0    AUS200.FXCM  澳大利亚标准普尔200指数       1.0    2000.0  1.0       0.1
1     CHN50.FXCM      富时中国A50指数       1.0     100.0  1.0       0.1
2     ESP35.FXCM    西班牙IBEX35指数       1.0    5000.0  1.0       0.1
3   EUSTX50.FXCM      欧洲斯托克50指数       1.0    5000.0  1.0       0.1
4     FRA40.FXCM      法国CAC40指数       1.0    5000.0  1.0       0.1
5     GER30.FXCM        德国DAX指数       1.0    1000.0  1.0       0.1
6     HKG33.FXCM         香港恒生指数       1.0     300.0  1.0       1.0
7    JPN225.FXCM        日经225指数      10.0    1000.0  1.0      10.0
8    NAS100.FXCM    美国纳斯达克100指数       1.0    5000.0  1.0       0.1
9    SPX500.FXCM      美国标普500指数       1.0    5000.0  0.1       0.1
10    UK100.FXCM      英国富时100指数       1.0    4000.0  1.0       0.1
11     US30.FXCM      道琼斯工业平均指数       1.0    4000.0  1.0       0.1
12   US2000.FXCM     美国罗素2000指数       1.0    5000.0  0.1       0.1

```
