# 复权行情

**文档ID**: 146
**原始链接**: https://tushare.pro/document/2?doc_id=146

---

## A股复权行情

接口名称：pro_bar接口说明：复权行情通过通用行情接口实现，利用Tushare Pro提供的复权因子进行动态计算，因此http方式无法调取。若需要静态复权行情（支持http），请访问股票技术因子接口。Python SDK版本要求： >= 1.2.26

复权说明

<table>
<thead>
<tr>
<th>类型</th>
<th>算法</th>
<th>参数标识</th>
</tr>
</thead>
<tbody><tr>
<td>不复权</td>
<td>无</td>
<td>空或None</td>
</tr>
<tr>
<td>前复权</td>
<td>当日收盘价 × 当日复权因子 / 最新复权因子</td>
<td>qfq</td>
</tr>
<tr>
<td>后复权</td>
<td>当日收盘价 × 当日复权因子</td>
<td>hfq</td>
</tr>
</tbody></table>
接口参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>证券代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期 (格式：YYYYMMDD)</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期 (格式：YYYYMMDD)</td>
</tr>
<tr>
<td>asset</td>
<td>str</td>
<td>Y</td>
<td>资产类别：E股票 I沪深指数 C数字货币 FT期货 FD基金 O期权，默认E</td>
</tr>
<tr>
<td>adj</td>
<td>str</td>
<td>N</td>
<td>复权类型(只针对股票)：None未复权 qfq前复权 hfq后复权 , 默认None</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>数据频度 ：1MIN表示1分钟（1/5/15/30/60分钟） D日线 ，默认D</td>
</tr>
<tr>
<td>ma</td>
<td>list</td>
<td>N</td>
<td>均线，支持任意周期的均价和均量，输入任意合理int数值</td>
</tr>
</tbody></table>
接口用例

日线复权

```

#取000001的前复权行情
df = ts.pro_bar(ts_code='000001.SZ', adj='qfq', start_date='20180101', end_date='20181011')

#取000001的后复权行情
df = ts.pro_bar(ts_code='000001.SZ', adj='hfq', start_date='20180101', end_date='20181011')

```

周线复权

```

#取000001的周线前复权行情
df = ts.pro_bar( ts_code='000001.SZ', freq='W', adj='qfq', start_date='20180101', end_date='20181011')

#取000001的周线后复权行情
df = ts.pro_bar(ts_code='000001.SZ', freq='W', adj='hfq', start_date='20180101', end_date='20181011')

```

月线复权

```

#取000001的月线前复权行情
df = ts.pro_bar(ts_code='000001.SZ', freq='M', adj='qfq', start_date='20180101', end_date='20181011')

#取000001的月线后复权行情
df = ts.pro_bar(ts_code='000001.SZ', freq='M', adj='hfq', start_date='20180101', end_date='20181011')

```
