# 复权因子

**文档ID**: 28
**原始链接**: https://tushare.pro/document/2?doc_id=28

---

## 复权因子

接口：adj_factor，可以通过数据工具调试和查看数据。更新时间：盘前9点15~20分完成当日复权因子入库描述：本接口由Tushare自行生产，获取股票复权因子，可提取单只股票全部历史复权因子，也可以提取单日全部股票的复权因子。积分要求：2000积分起，5000以上可高频调取

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期(YYYYMMDD，下同)</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
注：日期都填YYYYMMDD格式，比如20181010

输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>交易日期</td>
</tr>
<tr>
<td>adj_factor</td>
<td>float</td>
<td>复权因子</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

#提取000001全部复权因子
df = pro.adj_factor(ts_code='000001.SZ', trade_date='')


#提取2018年7月18日复权因子
df = pro.adj_factor(ts_code='', trade_date='20180718')

```

或者

```

df = pro.query('adj_factor',  trade_date='20180718')

```

数据样例

```
        ts_code trade_date  adj_factor
0     000001.SZ   20180809     108.031
1     000001.SZ   20180808     108.031
2     000001.SZ   20180807     108.031
3     000001.SZ   20180806     108.031
4     000001.SZ   20180803     108.031
5     000001.SZ   20180802     108.031
6     000001.SZ   20180801     108.031
7     000001.SZ   20180731     108.031
8     000001.SZ   20180730     108.031
9     000001.SZ   20180727     108.031
10    000001.SZ   20180726     108.031
11    000001.SZ   20180725     108.031
12    000001.SZ   20180724     108.031
13    000001.SZ   20180723     108.031
14    000001.SZ   20180720     108.031
15    000001.SZ   20180719     108.031
16    000001.SZ   20180718     108.031
17    000001.SZ   20180717     108.031
18    000001.SZ   20180716     108.031
19    000001.SZ   20180713     108.031
20    000001.SZ   20180712     108.031

```
