# 备用行情

**文档ID**: 255
**原始链接**: https://tushare.pro/document/2?doc_id=255

---

## 备用行情

接口：bak_daily描述：获取备用行情，包括特定的行情指标(数据从2017年中左右开始，早期有几天数据缺失，近期正常)限量：单次最大7000行数据，可以根据日期参数循环获取，正式权限需要5000积分。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>offset</td>
<td>str</td>
<td>N</td>
<td>开始行数</td>
</tr>
<tr>
<td>limit</td>
<td>str</td>
<td>N</td>
<td>最大行数</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌额</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨收价</td>
</tr>
<tr>
<td>vol_ratio</td>
<td>float</td>
<td>Y</td>
<td>量比</td>
</tr>
<tr>
<td>turn_over</td>
<td>float</td>
<td>Y</td>
<td>换手率</td>
</tr>
<tr>
<td>swing</td>
<td>float</td>
<td>Y</td>
<td>振幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交额</td>
</tr>
<tr>
<td>selling</td>
<td>float</td>
<td>Y</td>
<td>内盘（主动卖，手）</td>
</tr>
<tr>
<td>buying</td>
<td>float</td>
<td>Y</td>
<td>外盘（主动买， 手）</td>
</tr>
<tr>
<td>total_share</td>
<td>float</td>
<td>Y</td>
<td>总股本(亿)</td>
</tr>
<tr>
<td>float_share</td>
<td>float</td>
<td>Y</td>
<td>流通股本(亿)</td>
</tr>
<tr>
<td>pe</td>
<td>float</td>
<td>Y</td>
<td>市盈(动)</td>
</tr>
<tr>
<td>industry</td>
<td>str</td>
<td>Y</td>
<td>所属行业</td>
</tr>
<tr>
<td>area</td>
<td>str</td>
<td>Y</td>
<td>所属地域</td>
</tr>
<tr>
<td>float_mv</td>
<td>float</td>
<td>Y</td>
<td>流通市值</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>Y</td>
<td>总市值</td>
</tr>
<tr>
<td>avg_price</td>
<td>float</td>
<td>Y</td>
<td>平均价</td>
</tr>
<tr>
<td>strength</td>
<td>float</td>
<td>Y</td>
<td>强弱度(%)</td>
</tr>
<tr>
<td>activity</td>
<td>float</td>
<td>Y</td>
<td>活跃度(%)</td>
</tr>
<tr>
<td>avg_turnover</td>
<td>float</td>
<td>Y</td>
<td>笔换手</td>
</tr>
<tr>
<td>attack</td>
<td>float</td>
<td>Y</td>
<td>攻击波(%)</td>
</tr>
<tr>
<td>interval_3</td>
<td>float</td>
<td>Y</td>
<td>近3月涨幅</td>
</tr>
<tr>
<td>interval_6</td>
<td>float</td>
<td>Y</td>
<td>近6月涨幅</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.bak_daily(trade_date='20211012', fields='trade_date,ts_code,name,close,open')

```

数据样例

```
    ts_code     trade_date      name  close   open
0     300605.SZ   20211012  恒锋信息  14.86  12.65
1     301017.SZ   20211012  漱玉平民  25.21  20.82
2     300755.SZ   20211012  华致酒行  40.45  37.01
3     300255.SZ   20211012  常山药业   8.39   7.26
4     688378.SH   20211012   奥来德  68.62  67.00
...         ...        ...   ...    ...    ...
4529  688257.SH   20211012  新锐股份   0.00   0.00
4530  688255.SH   20211012   凯尔达   0.00   0.00
4531  688211.SH   20211012  中科微至   0.00   0.00
4532  605567.SH   20211012  春雪食品   0.00   0.00
4533  605566.SH   20211012  福莱蒽特   0.00   0.00

```
