# 基金规模

**文档ID**: 207
**原始链接**: https://tushare.pro/document/2?doc_id=207

---

## 基金规模数据

接口：fund_share，可以通过数据工具调试和查看数据。描述：获取基金规模数据，包含上海和深圳ETF基金限量：单次最大提取2000行数据积分：用户需要至少2000积分可以调取，5000积分以上频次较高，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS基金代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>market</td>
<td>str</td>
<td>N</td>
<td>市场代码（SH上交所 ，SZ深交所）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>基金代码，支持多只基金同时提取，用逗号分隔</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易（变动）日期，格式YYYYMMDD</td>
</tr>
<tr>
<td>fd_share</td>
<td>float</td>
<td>Y</td>
<td>基金份额（万）</td>
</tr>
</tbody></table>
代码示例

```
#初始接口
pro = ts.pro_api()

#单只基金
df = pro.fund_share(ts_code='150018.SZ')

#多只基金
df = pro.fund_share(ts_code='150018.SZ,150008.SZ')

```

数据示例

```
        ts_code trade_date  fd_share
0     150018.SZ   20200214  206733.2898
1     150018.SZ   20200213  209274.0911
2     150018.SZ   20200212  211859.8666
3     150018.SZ   20200211  215224.2959
4     150018.SZ   20200210  216739.3881
...         ...        ...          ...
1995  150018.SZ   20111129  319525.0658
1996  150018.SZ   20111128  317324.2829
1997  150018.SZ   20111125  317324.2131
1998  150018.SZ   20111124  316113.2233
1999  150018.SZ   20111123  314305.3576

```
