# 基金经理

**文档ID**: 208
**原始链接**: https://tushare.pro/document/2?doc_id=208

---

## 基金经理

接口：fund_manager描述：获取公募基金经理数据，包括基金经理简历等数据限量：单次最大5000，支持分页提取数据积分：用户有500积分可获取数据，2000积分以上可以提高访问频次

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>基金代码，支持多只基金，逗号分隔</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期，格式：YYYYMMDD</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>N</td>
<td>基金经理姓名</td>
</tr>
<tr>
<td>offset</td>
<td>intint</td>
<td>N</td>
<td>开始行数</td>
</tr>
<tr>
<td>limit</td>
<td>int</td>
<td>N</td>
<td>每页行数</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>基金代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>基金经理姓名</td>
</tr>
<tr>
<td>gender</td>
<td>str</td>
<td>Y</td>
<td>性别</td>
</tr>
<tr>
<td>birth_year</td>
<td>str</td>
<td>Y</td>
<td>出生年份</td>
</tr>
<tr>
<td>edu</td>
<td>str</td>
<td>Y</td>
<td>学历</td>
</tr>
<tr>
<td>nationality</td>
<td>str</td>
<td>Y</td>
<td>国籍</td>
</tr>
<tr>
<td>begin_date</td>
<td>str</td>
<td>Y</td>
<td>任职日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>离任日期</td>
</tr>
<tr>
<td>resume</td>
<td>str</td>
<td>Y</td>
<td>简历</td>
</tr>
</tbody></table>
代码示例

```
#初始接口
pro = ts.pro_api()

#单只基金
df = pro.fund_manager(ts_code='150018.SZ')

#多只基金
df = pro.fund_manager(ts_code='150018.SZ,150008.SZ')

```

数据示例

```
    ts_code  ann_date   name  gender birth_year edu nationality begin_date  end_date                                             resume
0  150018.SZ  20100508   周毅      M       None  硕士          美国   20100507      None  CFA，硕士学位；毕业于北京大学，美国南卡罗莱纳大学，美国约翰霍普金斯大学。曾任美国普华永道...
1  150018.SZ  20190831   张凯      M       None  硕士          中国   20190829      None  CFA，硕士学位，毕业于清华大学。2009年7月加盟银华基金管理有限公司，从事量化策略研发和...
2  150018.SZ  20100927  路志刚      M       1969  博士          中国   20100507  20100927  暨南大学金融学博士。曾任广东建设实业集团公司财务主管，广州证券有限公司发行部、营业部经理，金...
```
