# 基金持仓

**文档ID**: 121
**原始链接**: https://tushare.pro/document/2?doc_id=121

---

## 公募基金持仓数据

接口：fund_portfolio描述：获取公募基金持仓数据，季度更新积分：5000积分以上每分钟请求200次，8000积分以上每分钟请求500次，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>基金代码 (ts_code,ann_date,period至少输入一个参数)</td>
</tr>
<tr>
<td>symbol</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日期（YYYYMMDD格式）</td>
</tr>
<tr>
<td>period</td>
<td>str</td>
<td>N</td>
<td>季度（每个季度最后一天的日期，比如20131231表示2013年年报）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始日期（YYYYMMDD格式）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告期结束日期（YYYYMMDD格式）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS基金代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>截止日期</td>
</tr>
<tr>
<td>symbol</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>mkv</td>
<td>float</td>
<td>Y</td>
<td>持有股票市值(元)</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>持有股票数量（股）</td>
</tr>
<tr>
<td>stk_mkv_ratio</td>
<td>float</td>
<td>Y</td>
<td>占股票市值比</td>
</tr>
<tr>
<td>stk_float_ratio</td>
<td>float</td>
<td>Y</td>
<td>占流通股本比例</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.fund_portfolio(ts_code='001753.OF')

```

数据示例

```
    ts_code  ann_date  end_date     symbol          mkv    amount  \
0    001753.OF  20180823  20180630  603019.SH   3130994.46   68258.0   
1    001753.OF  20180718  20180630  600845.SH   3594140.00  136400.0   
2    001753.OF  20180718  20180630  600596.SH   5428107.30  335690.0   
3    001753.OF  20180718  20180630  600588.SH   3811672.65  155515.0   
4    001753.OF  20180718  20180630  600271.SH   3770284.00  149200.0   
5    001753.OF  20180823  20180630  300616.SZ     10900.00     100.0   
6    001753.OF  20180718  20180630  300577.SZ   4544793.54  110257.0   
7    001753.OF  20180718  20180630  300476.SZ   3783780.00  245700.0   
8    001753.OF  20180823  20180630  300409.SZ   2895942.00   72200.0   
9    001753.OF  20180718  20180630  300208.SZ   5768280.00  588000.0   
10   001753.OF  20180823  20180630  300188.SZ   2535922.50  138575.0  

     stk_mkv_ratio  stk_float_ratio  
0             4.37             0.01  
1             5.02             0.02  
2             7.57             0.05  
3             5.32             0.01  
4             5.26             0.01  
5             0.02             0.00  
6             6.34             0.17  
7             5.28             0.07  
8             4.04             0.05  
9             8.05             0.10  
10            3.54             0.03 

```
