# 基金列表

**文档ID**: 19
**原始链接**: https://tushare.pro/document/2?doc_id=19

---

## 公募基金列表

接口：fund_basic，可以通过数据工具调试和查看数据。描述：获取公募基金数据列表，包括场内和场外基金积分：用户需要2000积分才可以调取，单次最大可以提取15000条数据，5000积分以上权限更高，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>基金代码</td>
</tr>
<tr>
<td>market</td>
<td>str</td>
<td>N</td>
<td>交易市场: E场内 O场外（默认E）</td>
</tr>
<tr>
<td>status</td>
<td>str</td>
<td>N</td>
<td>存续状态 D摘牌 I发行 L上市中</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>基金代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>简称</td>
</tr>
<tr>
<td>management</td>
<td>str</td>
<td>Y</td>
<td>管理人</td>
</tr>
<tr>
<td>custodian</td>
<td>str</td>
<td>Y</td>
<td>托管人</td>
</tr>
<tr>
<td>fund_type</td>
<td>str</td>
<td>Y</td>
<td>投资类型</td>
</tr>
<tr>
<td>found_date</td>
<td>str</td>
<td>Y</td>
<td>成立日期</td>
</tr>
<tr>
<td>due_date</td>
<td>str</td>
<td>Y</td>
<td>到期日期</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>Y</td>
<td>上市时间</td>
</tr>
<tr>
<td>issue_date</td>
<td>str</td>
<td>Y</td>
<td>发行日期</td>
</tr>
<tr>
<td>delist_date</td>
<td>str</td>
<td>Y</td>
<td>退市日期</td>
</tr>
<tr>
<td>issue_amount</td>
<td>float</td>
<td>Y</td>
<td>发行份额(亿)</td>
</tr>
<tr>
<td>m_fee</td>
<td>float</td>
<td>Y</td>
<td>管理费</td>
</tr>
<tr>
<td>c_fee</td>
<td>float</td>
<td>Y</td>
<td>托管费</td>
</tr>
<tr>
<td>duration_year</td>
<td>float</td>
<td>Y</td>
<td>存续期</td>
</tr>
<tr>
<td>p_value</td>
<td>float</td>
<td>Y</td>
<td>面值</td>
</tr>
<tr>
<td>min_amount</td>
<td>float</td>
<td>Y</td>
<td>起点金额(万元)</td>
</tr>
<tr>
<td>exp_return</td>
<td>float</td>
<td>Y</td>
<td>预期收益率</td>
</tr>
<tr>
<td>benchmark</td>
<td>str</td>
<td>Y</td>
<td>业绩比较基准</td>
</tr>
<tr>
<td>status</td>
<td>str</td>
<td>Y</td>
<td>存续状态D摘牌 I发行 L已上市</td>
</tr>
<tr>
<td>invest_type</td>
<td>str</td>
<td>Y</td>
<td>投资风格</td>
</tr>
<tr>
<td>type</td>
<td>str</td>
<td>Y</td>
<td>基金类型</td>
</tr>
<tr>
<td>trustee</td>
<td>str</td>
<td>Y</td>
<td>受托人</td>
</tr>
<tr>
<td>purc_startdate</td>
<td>str</td>
<td>Y</td>
<td>日常申购起始日</td>
</tr>
<tr>
<td>redm_startdate</td>
<td>str</td>
<td>Y</td>
<td>日常赎回起始日</td>
</tr>
<tr>
<td>market</td>
<td>str</td>
<td>Y</td>
<td>E场内O场外</td>
</tr>
</tbody></table>
接口用例

```

pro = ts.pro_api()

df = pro.fund_basic(market='E')

```

数据样例

```
    ts_code             name         management  custodian      fund_type found_date  \
1     512850.SH    中信建投北京50ETF     中信建投基金      招商银行       股票型   20180927   
2     168601.SZ    汇安裕阳三年定期开放       汇安基金    中国光大银行       混合型   20180927 
3     512860.SH    华安中国A股ETF       华安基金    中国农业银行       股票型   20180927   
4     159960.SZ    恒生国企     平安大华基金      中国银行       股票型   20180921   
5     501062.SH    南方瑞合三年       南方基金    中国建设银行       混合型   20180906   
6     510600.SH    沪50ETF     申万菱信基金    中国工商银行       股票型   20180903   
7     501061.SH    金选300C       中金基金    中国建设银行       股票型   20180830   
8     501060.SH    金选300A       中金基金    中国建设银行       股票型   20180830   
9     166802.SZ     浙商300       浙商基金      华夏银行       股票型   20180820 

```
