# 基金分红

**文档ID**: 120
**原始链接**: https://tushare.pro/document/2?doc_id=120

---

## 公募基金分红

接口：fund_div描述：获取公募基金分红数据积分：用户需要至少400积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>公告日（以下参数四选一）</td>
</tr>
<tr>
<td>ex_date</td>
<td>str</td>
<td>N</td>
<td>除息日</td>
</tr>
<tr>
<td>pay_date</td>
<td>str</td>
<td>N</td>
<td>派息日</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>基金代码</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>imp_anndate</td>
<td>str</td>
<td>Y</td>
<td>分红实施公告日</td>
</tr>
<tr>
<td>base_date</td>
<td>str</td>
<td>Y</td>
<td>分配收益基准日</td>
</tr>
<tr>
<td>div_proc</td>
<td>str</td>
<td>Y</td>
<td>方案进度</td>
</tr>
<tr>
<td>record_date</td>
<td>str</td>
<td>Y</td>
<td>权益登记日</td>
</tr>
<tr>
<td>ex_date</td>
<td>str</td>
<td>Y</td>
<td>除息日</td>
</tr>
<tr>
<td>pay_date</td>
<td>str</td>
<td>Y</td>
<td>派息日</td>
</tr>
<tr>
<td>earpay_date</td>
<td>str</td>
<td>Y</td>
<td>收益支付日</td>
</tr>
<tr>
<td>net_ex_date</td>
<td>str</td>
<td>Y</td>
<td>净值除权日</td>
</tr>
<tr>
<td>div_cash</td>
<td>float</td>
<td>Y</td>
<td>每股派息(元)</td>
</tr>
<tr>
<td>base_unit</td>
<td>float</td>
<td>Y</td>
<td>基准基金份额(万份)</td>
</tr>
<tr>
<td>ear_distr</td>
<td>float</td>
<td>Y</td>
<td>可分配收益(元)</td>
</tr>
<tr>
<td>ear_amount</td>
<td>float</td>
<td>Y</td>
<td>收益分配金额(元)</td>
</tr>
<tr>
<td>account_date</td>
<td>str</td>
<td>Y</td>
<td>红利再投资到账日</td>
</tr>
<tr>
<td>base_year</td>
<td>str</td>
<td>Y</td>
<td>份额基准年度</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.fund_div(ann_date='20181018')

```

数据示例

```
    ts_code  ann_date imp_anndate base_date div_proc record_date   ex_date  \
0  161618.OF  20181018    20181018  20180928       实施    20181022  20181022   
1  161619.OF  20181018    20181018  20180928       实施    20181022  20181022   
2  005485.OF  20181018    20181018  20181015       实施    20181022  20181022   
3  519330.OF  20181018    20181018  20181012       实施    20181022  20181022   
4  519331.OF  20181018    20181018  20181012       实施    20181022  20181022   
5  164702.SZ  20181018    20181018  20180930       实施    20181022  20181023   
6  005068.OF  20181018    20181018  20181016       实施    20181022  20181022   
7  519953.OF  20181018    20181018  20181016       实施    20181022  20181022   

   pay_date earpay_date net_ex_date  div_cash    base_unit    ear_distr  \
0  20181024        None        None    0.0170   14982.2740   5018943.83   
1  20181024        None        None    0.0150    2894.7015    823800.02   
2  20181024        None        None    0.0180  101004.4450  18689411.19   
3  20181024        None        None    0.0060  219742.3332  65922699.95   
4  20181024        None        None    0.0050       4.8656      1216.42   
5  20181024        None        None    0.0150   41287.3653   8058271.35   
6  20181024        None        None    0.0237    4953.9392   1174773.90   
7  20181024        None        None    0.0191   23038.2415   4408682.75
```
