# 基金净值

**文档ID**: 119
**原始链接**: https://tushare.pro/document/2?doc_id=119

---

## 公募基金净值

接口：fund_nav，可以通过数据工具调试和查看数据。描述：获取公募基金净值数据积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS基金代码 （二选一）</td>
</tr>
<tr>
<td>nav_date</td>
<td>str</td>
<td>N</td>
<td>净值日期 （二选一）</td>
</tr>
<tr>
<td>market</td>
<td>str</td>
<td>N</td>
<td>E场内 O场外</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>净值开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>净值结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>nav_date</td>
<td>str</td>
<td>Y</td>
<td>净值日期</td>
</tr>
<tr>
<td>unit_nav</td>
<td>float</td>
<td>Y</td>
<td>单位净值</td>
</tr>
<tr>
<td>accum_nav</td>
<td>float</td>
<td>Y</td>
<td>累计净值</td>
</tr>
<tr>
<td>accum_div</td>
<td>float</td>
<td>Y</td>
<td>累计分红</td>
</tr>
<tr>
<td>net_asset</td>
<td>float</td>
<td>Y</td>
<td>资产净值</td>
</tr>
<tr>
<td>total_netasset</td>
<td>float</td>
<td>Y</td>
<td>合计资产净值</td>
</tr>
<tr>
<td>adj_nav</td>
<td>float</td>
<td>Y</td>
<td>复权单位净值</td>
</tr>
</tbody></table>
代码示例

```

pro = ts.pro_api()

df = pro.fund_nav(ts_code='165509.SZ')

```

数据示例

```
        ts_code  ann_date  nav_date  unit_nav  accum_nav accum_div  \
0     165509.SZ  20181019  20181018     1.104      1.587      None   
1     165509.SZ  20181018  20181017     1.110      1.587      None   
2     165509.SZ  20181017  20181016     1.110      1.587      None   
3     165509.SZ  20181016  20181015     1.110      1.587      None   
4     165509.SZ  20181013  20181012     1.110      1.587      None   
5     165509.SZ  20181012  20181011     1.110      1.587      None   
6     165509.SZ  20181011  20181010     1.110      1.587      None   
7     165509.SZ  20181010  20181009     1.110      1.587      None   
8     165509.SZ  20181009  20181008     1.109      1.586      None   
9     165509.SZ  20180929  20180928     1.109      1.586      None   
10    165509.SZ  20180928  20180927     1.109      1.586      None  
```
