# 国际主要指数

**文档ID**: 211
**原始链接**: https://tushare.pro/document/2?doc_id=211

---

## 国际指数

接口：index_global，可以通过数据工具调试和查看数据。描述：获取国际主要指数日线行情限量：单次最大提取4000行情数据，可循环获取，总量不限制积分：用户积6000积分可调取，积分越高频次越高，请自行提高积分，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS指数代码，见下表</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期，YYYYMMDD格式，下同</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
<table>
<thead>
<tr>
<th>TS指数代码</th>
<th>指数名称</th>
</tr>
</thead>
<tbody><tr>
<td>XIN9</td>
<td>富时中国A50指数  (富时A50)</td>
</tr>
<tr>
<td>HSI</td>
<td>恒生指数</td>
</tr>
<tr>
<td>HKTECH</td>
<td>恒生科技指数</td>
</tr>
<tr>
<td>HKAH</td>
<td>恒生AH股H指数</td>
</tr>
<tr>
<td>DJI</td>
<td>道琼斯工业指数</td>
</tr>
<tr>
<td>SPX</td>
<td>标普500指数</td>
</tr>
<tr>
<td>IXIC</td>
<td>纳斯达克指数</td>
</tr>
<tr>
<td>FTSE</td>
<td>富时100指数</td>
</tr>
<tr>
<td>FCHI</td>
<td>法国CAC40指数</td>
</tr>
<tr>
<td>GDAXI</td>
<td>德国DAX指数</td>
</tr>
<tr>
<td>N225</td>
<td>日经225指数</td>
</tr>
<tr>
<td>KS11</td>
<td>韩国综合指数</td>
</tr>
<tr>
<td>AS51</td>
<td>澳大利亚标普200指数</td>
</tr>
<tr>
<td>SENSEX</td>
<td>印度孟买SENSEX指数</td>
</tr>
<tr>
<td>IBOVESPA</td>
<td>巴西IBOVESPA指数</td>
</tr>
<tr>
<td>RTS</td>
<td>俄罗斯RTS指数</td>
</tr>
<tr>
<td>TWII</td>
<td>台湾加权指数</td>
</tr>
<tr>
<td>CKLSE</td>
<td>马来西亚指数</td>
</tr>
<tr>
<td>SPTSX</td>
<td>加拿大S&amp;P/TSX指数</td>
</tr>
<tr>
<td>CSX5P</td>
<td>STOXX欧洲50指数</td>
</tr>
<tr>
<td>RUT</td>
<td>罗素2000指数</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS指数代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘点位</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘点位</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高点位</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低点位</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨日收盘点</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌点位</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>swing</td>
<td>float</td>
<td>Y</td>
<td>振幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量 （大部分无此项数据）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>N</td>
<td>成交额 （大部分无此项数据）</td>
</tr>
</tbody></table>
接口使用

```

pro = ts.pro_api()

#获取富时中国50指数
df = pro.index_global(ts_code='XIN9', start_date='20200201', end_date='20200220')

```

数据示例

```
     trade_date    open     close    high    low       pre_close  change  \
0    20200220  13750.45  14009.40  14023.88  13750.45   13750.45  258.95   
1    20200219  13712.13  13750.45  13815.63  13674.43   13712.13   38.32   
2    20200218  13859.23  13712.13  13859.32  13671.89   13859.23 -147.10   
3    20200217  13646.93  13859.23  13859.23  13632.23   13646.93  212.30   
4    20200214  13547.16  13646.93  13660.84  13518.83   13547.16   99.77   
5    20200213  13638.49  13547.16  13696.95  13535.21   13638.49  -91.33   
6    20200212  13603.43  13638.49  13639.14  13529.55   13603.43   35.06   
7    20200211  13420.83  13603.43  13661.80  13420.70   13420.83  182.60   
8    20200210  13426.71  13420.83  13455.79  13260.81   13426.71   -5.88   
9    20200207  13481.92  13426.71  13481.92  13286.61   13481.92  -55.21   
10   20200206  13301.97  13481.92  13532.73  13273.11   13301.97  179.95   
11   20200205  13187.05  13301.97  13389.27  13145.93   13187.05  114.92   
12   20200204  12815.75  13187.05  13195.82  12815.01   12815.75  371.30   
13   20200203  13791.36  12815.75  13791.36  12622.61   13791.36 -975.61   

    pct_chg ts_code  
0    1.8832    XIN9  
1    0.2795    XIN9  
2   -1.0614    XIN9  
3    1.5557    XIN9  
4    0.7365    XIN9  
5   -0.6696    XIN9  
6    0.2577    XIN9  
7    1.3606    XIN9  
8   -0.0438    XIN9  
9   -0.4095    XIN9  
10   1.3528    XIN9  
11   0.8715    XIN9  
12   2.8972    XIN9  
13  -7.0741    XIN9  

```
