# 国家政策库

**文档ID**: 406
**原始链接**: https://tushare.pro/document/2?doc_id=406

---

### 接口介绍

为更好地学习和熟悉国家有关部门发布的政策法规和各类批复意见，同时为大语言模型提供更精准的语料和专业知识库，我们搜集整理了由国家有关部门公开披露的政策法规文件，所有文字均为原始输出，未作任何二次加工处理，同时提供原始出处。

接口：npr，（National Policy Repository）描述：获取国家行政机关公开披露的各类法规、条例政策、批复、通知等文本数据。限量：单次最大500条，可根据参数循环提取积分：本接口需单独开权限（跟积分没关系），具体请参阅权限说明

### 输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
<th>可选内容</th>
</tr>
</thead>
<tbody>
<tr>
<td>org</td>
<td>str</td>
<td>N</td>
<td>发布机构</td>
<td>国务院办公厅/国务院办公厅/国务院、中央军委/国务院应急管理办公室</td>
</tr>
<tr>
<td>start_date</td>
<td>datetime</td>
<td>N</td>
<td>发布开始时间</td>
<td>格式样例：2024-11-21 00:00:00</td>
</tr>
<tr>
<td>end_date</td>
<td>datetime</td>
<td>N</td>
<td>发布结束时间</td>
<td>格式样例：2024-11-28 00:00:00</td>
</tr>
<tr>
<td>ptype</td>
<td>str</td>
<td>N</td>
<td>类型</td>
<td>对外经贸合作/农业、畜牧业、渔业/海关/城市规划/土地/科技/教育/卫生/民航 等110类</td>
</tr>
</tbody>
</table>
### 输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>pubtime</td>
<td>datetime</td>
<td>Y</td>
<td>发布时间</td>
</tr>
<tr>
<td>title</td>
<td>str</td>
<td>Y</td>
<td>标题</td>
</tr>
<tr>
<td>url</td>
<td>str</td>
<td>N</td>
<td>政策文件url</td>
</tr>
<tr>
<td>content_html</td>
<td>str</td>
<td>N</td>
<td>正文内容</td>
</tr>
<tr>
<td>pcode</td>
<td>str</td>
<td>Y</td>
<td>发文字号</td>
</tr>
<tr>
<td>puborg</td>
<td>str</td>
<td>Y</td>
<td>发文机关</td>
</tr>
<tr>
<td>ptype</td>
<td>str</td>
<td>Y</td>
<td>主题分类</td>
</tr>
</tbody>
</table>
### 代码示例

```
pro = ts.pro_api()

#获取由国务院发布的相关政策文件
df = pro.npr(org='国务院')

#获取由“国务院”发布的“科技”相关政策和批复文件
df = pro.npr(org='国务院', 
            ptype='科技', 
            end_date='2025-08-26 17:00:00', 
            fields='pubtime,title,pcode')

```

### 数据结果

```
            pubtime                                    title        pcode
0    2025-08-26 17:00:00            国务院关于深入实施“人工智能+”行动的意见  国发〔2025〕11号
1    2024-11-14 19:00:00                     国家自然科学基金条例      国令第796号
2    2024-05-30 18:57:00           国务院关于修改《国家科学技术奖励条例》的决定      国令第782号
3    2023-08-29 16:55:00  国务院关于印发《河套深港科技创新合作区深圳园区发展规划》的通知  国发〔2023〕12号
4    2023-06-16 16:57:00  国务院关于同意阿克苏阿拉尔高新技术产业开发区升级为国家高新技术产业开发区的批复  国函〔2023〕48号
..                   ...                                      ...          ...
111  2008-03-28 08:00:00    国务院关于同意上海高新技术产业开发区更名为上海张江高新技术产业开发区的批复  国函〔2006〕14号
112  2008-03-28 08:00:00                               国家自然科学基金条例      国令第487号
113  2008-03-28 08:00:00                   国务院关于2002年度国家科学技术奖励的决定   国发〔2003〕4号
114  2008-03-28 08:00:00  国务院关于印发全民科学素质行动计划纲要(2006—2010—2020年)的通知   国发〔2006〕7号
115  2008-03-28 08:00:00                   国务院关于2005年度国家科学技术奖励的决定   国发〔2006〕2号

```
