# 国债长期利率

**文档ID**: 222
**原始链接**: https://tushare.pro/document/2?doc_id=222

---

## 国债长期利率

接口：us_tltr描述：国债长期利率限量：单次最大可获取2000行数据，可循环获取权限：用户积累120积分可以使用，积分越高频次越高。具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>fields</td>
<td>str</td>
<td>N</td>
<td>指定字段</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>ltc</td>
<td>float</td>
<td>Y</td>
<td>收益率 LT COMPOSITE (&gt;10 Yrs)</td>
</tr>
<tr>
<td>cmt</td>
<td>float</td>
<td>Y</td>
<td>20年期CMT利率(TREASURY 20-Yr CMT)</td>
</tr>
<tr>
<td>e_factor</td>
<td>float</td>
<td>Y</td>
<td>外推因子EXTRAPOLATION FACTOR</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.us_tltr(start_date='20180101', end_date='20200327')


#获取5年期和20年期数据
df = pro.us_tltr(start_date='20180101', end_date='20200327', fields='ltc,cmt')

```

数据样例

```
          date   ltc   cmt e_factor
0     20200327  1.19  1.09     None
1     20200326  1.32  1.20     None
2     20200325  1.35  1.23     None
3     20200324  1.30  1.19     None
4     20200323  1.25  1.12     None
...        ...   ...   ...      ...
1995  20120404  2.98  3.02     None
1996  20120403  3.02  3.07     None
1997  20120402  2.96  3.00     None
1998  20120330  2.96  3.00     None
1999  20120329  2.89  2.93     None
```
