# 国债收益率曲线利率

**文档ID**: 219
**原始链接**: https://tushare.pro/document/2?doc_id=219

---

## 国债收益率曲线利率（日频）

接口：us_tycr描述：获取美国每日国债收益率曲线利率限量：单次最大可获取2000条数据权限：用户积累120积分可以使用，积分越高频次越高。具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期 （YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>fields</td>
<td>str</td>
<td>N</td>
<td>指定输出字段（e.g. fields='m1,y1'）</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>m1</td>
<td>float</td>
<td>Y</td>
<td>1月期</td>
</tr>
<tr>
<td>m2</td>
<td>float</td>
<td>Y</td>
<td>2月期</td>
</tr>
<tr>
<td>m3</td>
<td>float</td>
<td>Y</td>
<td>3月期</td>
</tr>
<tr>
<td>m4</td>
<td>float</td>
<td>Y</td>
<td>4月期（数据从20221019开始）</td>
</tr>
<tr>
<td>m6</td>
<td>float</td>
<td>Y</td>
<td>6月期</td>
</tr>
<tr>
<td>y1</td>
<td>float</td>
<td>Y</td>
<td>1年期</td>
</tr>
<tr>
<td>y2</td>
<td>float</td>
<td>Y</td>
<td>2年期</td>
</tr>
<tr>
<td>y3</td>
<td>float</td>
<td>Y</td>
<td>3年期</td>
</tr>
<tr>
<td>y5</td>
<td>float</td>
<td>Y</td>
<td>5年期</td>
</tr>
<tr>
<td>y7</td>
<td>float</td>
<td>Y</td>
<td>7年期</td>
</tr>
<tr>
<td>y10</td>
<td>float</td>
<td>Y</td>
<td>10年期</td>
</tr>
<tr>
<td>y20</td>
<td>float</td>
<td>Y</td>
<td>20年期</td>
</tr>
<tr>
<td>y30</td>
<td>float</td>
<td>Y</td>
<td>30年期</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.us_tycr(start_date='20180101', end_date='20200327')


#获取1月期和1年期数据
df = pro.us_tycr(start_date='20180101', end_date='20200327', fields='m1,y1')

```

数据样例

```
          date    m1    m2    m3    m6    y1    y2    y3    y5    y7   y10   y20   y30
0     20200327  0.01  0.03  0.03  0.02  0.11  0.25  0.30  0.41  0.60  0.72  1.09  1.29
1     20200326  0.01  0.01  0.00  0.04  0.13  0.30  0.36  0.51  0.72  0.83  1.20  1.42
2     20200325  0.00  0.00  0.00  0.07  0.19  0.34  0.41  0.56  0.77  0.88  1.23  1.45
3     20200324  0.01  0.01  0.01  0.09  0.25  0.38  0.44  0.52  0.75  0.84  1.19  1.39
4     20200323  0.01  0.04  0.02  0.08  0.17  0.28  0.31  0.38  0.63  0.76  1.12  1.33
...        ...   ...   ...   ...   ...   ...   ...   ...   ...   ...   ...   ...   ...
1995  20120405  0.07  None  0.08  0.14  0.19  0.35  0.50  1.01  1.56  2.19  2.97  3.32
1996  20120404  0.08  None  0.08  0.14  0.19  0.35  0.53  1.05  1.62  2.25  3.02  3.37
1997  20120403  0.07  None  0.08  0.15  0.20  0.36  0.56  1.10  1.68  2.30  3.07  3.41
1998  20120402  0.05  None  0.08  0.14  0.18  0.33  0.50  1.03  1.60  2.22  3.00  3.35
1999  20120330  0.05  None  0.07  0.15  0.19  0.33  0.51  1.04  1.61  2.23  3.00  3.35

```
