# 国债收益率曲线

**文档ID**: 201
**原始链接**: https://tushare.pro/document/2?doc_id=201

---

## 国债收益率曲线

接口：yc_cb描述：获取中债收益率曲线，目前可获取中债国债收益率曲线即期和到期收益率曲线数据限量：单次最大2000，总量不限制，可循环提取权限：属于单独的权限接口，请在群里联系群主或管理员

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>收益率曲线编码：1001.CB-国债收益率曲线</td>
</tr>
<tr>
<td>curve_type</td>
<td>str</td>
<td>N</td>
<td>曲线类型：0-到期，1-即期</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>查询起始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>查询结束日期</td>
</tr>
<tr>
<td>curve_term</td>
<td>float</td>
<td>N</td>
<td>期限</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>曲线编码</td>
</tr>
<tr>
<td>curve_name</td>
<td>str</td>
<td>Y</td>
<td>曲线名称</td>
</tr>
<tr>
<td>curve_type</td>
<td>str</td>
<td>Y</td>
<td>曲线类型：0-到期，1-即期</td>
</tr>
<tr>
<td>curve_term</td>
<td>float</td>
<td>Y</td>
<td>期限(年)</td>
</tr>
<tr>
<td>yield</td>
<td>float</td>
<td>Y</td>
<td>收益率(%)</td>
</tr>
</tbody></table>
接口示例

```
pro = ts.pro_api(your token)
#获取中债收益率曲线
df = pro.yc_cb(ts_code='1001.CB',curve_type='0',trade_date='20200203')

```

数据示例

```
    trade_date ts_code curve_name curve_type curve_term     yield
0      20200203        101  中债国债收益率曲线          0     0.0000  1.697300
1      20200203        101  中债国债收益率曲线          0     0.0800  1.770000
2      20200203        101  中债国债收益率曲线          0     0.1000  1.770100
3      20200203        101  中债国债收益率曲线          0     0.1700  1.770300
4      20200203        101  中债国债收益率曲线          0     0.2000  1.772300
...         ...        ...        ...        ...        ...       ...
1001   20200203        101  中债国债收益率曲线          1    49.6000  3.774100
1002   20200203        101  中债国债收益率曲线          1    49.7000  3.774700
1003   20200203        101  中债国债收益率曲线          1    49.8000  3.775400
1004   20200203        101  中债国债收益率曲线          1    49.9000  3.776100
1005   20200203        101  中债国债收益率曲线          1    50.0000  3.776800

```
