# 国债实际收益率曲线利率

**文档ID**: 220
**原始链接**: https://tushare.pro/document/2?doc_id=220

---

## 国债实际收益率曲线利率

接口：us_trycr描述：国债实际收益率曲线利率限量：单次最大可获取2000行数据，可循环获取权限：用户积累120积分可以使用，积分越高频次越高。具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>日期 （YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>fields</td>
<td>str</td>
<td>N</td>
<td>指定输出字段</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>Y</td>
<td>日期</td>
</tr>
<tr>
<td>y5</td>
<td>float</td>
<td>Y</td>
<td>5年期</td>
</tr>
<tr>
<td>y7</td>
<td>float</td>
<td>Y</td>
<td>7年期</td>
</tr>
<tr>
<td>y10</td>
<td>float</td>
<td>Y</td>
<td>10年期</td>
</tr>
<tr>
<td>y20</td>
<td>float</td>
<td>Y</td>
<td>20年期</td>
</tr>
<tr>
<td>y30</td>
<td>float</td>
<td>Y</td>
<td>30年期</td>
</tr>
</tbody></table>
接口调用

```

pro = ts.pro_api()

df = pro.us_trycr(start_date='20180101', end_date='20200327')


#获取5年期和20年期数据
df = pro.us_trycr(start_date='20180101', end_date='20200327', fields='y5,y20')

```

数据样例

```
          date     y5     y7    y10    y20    y30
0     20200327  -0.13  -0.20  -0.22  -0.12  -0.03
1     20200326  -0.21  -0.24  -0.24  -0.14  -0.05
2     20200325  -0.13  -0.18  -0.19  -0.09   0.00
3     20200324  -0.03  -0.11  -0.13  -0.09  -0.07
4     20200323   0.01  -0.03  -0.04  -0.02  -0.01
...        ...    ...    ...    ...    ...    ...
1995  20120404  -0.91  -0.46  -0.05   0.62   0.94
1996  20120403  -0.94  -0.48  -0.06   0.62   0.94
1997  20120402  -1.01  -0.55  -0.14   0.56   0.89
1998  20120330  -0.98  -0.53  -0.09   0.61   0.93
1999  20120329  -0.98  -0.53  -0.13   0.55   0.87
```
