# 周线行情

**文档ID**: 144
**原始链接**: https://tushare.pro/document/2?doc_id=144

---

## 周线行情

接口：weekly描述：获取A股周线行情，本接口每周最后一个交易日更新，如需要使用每天更新的周线数据，请使用日度更新的周线行情接口。限量：单次最大6000行，可使用交易日期循环提取，总量不限制积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码 （ts_code,trade_date两个参数任选一）</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期 （每周最后一个交易日期，YYYYMMDD格式）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>周收盘价</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>周开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>周最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>周最低价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>上一周收盘价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>周涨跌额</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>周涨跌 （未复权，未<em>100，如果是复权请用 <a href="https://tushare.pro/document/2?doc_id=109">通用行情接口</a>，如需%单位请</em>100 ）</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>周成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>周成交额</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.weekly(ts_code='000001.SZ', start_date='20180101', end_date='20181101', fields='ts_code,trade_date,open,high,low,close,vol,amount')

```

或者

```

df = pro.weekly(trade_date='20181123', fields='ts_code,trade_date,open,high,low,close,vol,amount')

```

数据样例

```
    ts_code   trade_date  close   open   high    low          vol  \
0   000001.SZ   20181026  11.18  10.81  11.46  10.71   9062500.14   
1   000001.SZ   20181019  10.76  10.39  10.78   9.92   7235319.55   
2   000001.SZ   20181012  10.30  10.70  10.79   9.70   7257596.97   
3   000001.SZ   20180928  11.05  10.52  11.27  10.48   5458134.13   
4   000001.SZ   20180921  10.67   9.80  10.70   9.68   5120305.29   
5   000001.SZ   20180914   9.84  10.01  10.10   9.81   3534261.76   
6   000001.SZ   20180907  10.01  10.09  10.55   9.93   4708303.81   
7   000001.SZ   20180831  10.13  10.02  10.43   9.97   6715867.92   
8   000001.SZ   20180824  10.03   8.90  10.28   8.87   6697713.52   
9   000001.SZ   20180817   8.81   9.12   9.16   8.64   3206923.44   
10  000001.SZ   20180810   9.23   8.94   9.35   8.88   3054338.56   
11  000001.SZ   20180803   8.91   9.32   9.50   8.88   3648566.35   
12  000001.SZ   20180727   9.25   9.04   9.59   9.00   5170189.41   
13  000001.SZ   20180720   9.11   8.85   9.20   8.61   3806004.47   
14  000001.SZ   20180713   8.88   8.69   9.03   8.58   4901983.84   
15  000001.SZ   20180706   8.66   9.05   9.05   8.45   5125563.53   
16  000001.SZ   20180629   9.09   9.91   9.92   8.87   5150575.93 

          amount  
0   1.002282e+07  
1   7.482596e+06  
2   7.483906e+06  
3   5.904901e+06  
4   5.225262e+06  
5   3.501724e+06  
6   4.796533e+06  
7   6.858804e+06  
8   6.358840e+06  
9   2.854248e+06  
10  2.787629e+06  
11  3.363448e+06  
12  4.826484e+06  
13  3.371040e+06  
14  4.346872e+06  
15  4.446723e+06  
16  4.764107e+06 

```
