# 周/月线行情(每日更新)

**文档ID**: 336
**原始链接**: https://tushare.pro/document/2?doc_id=336

---

## 股票周/月线行情(每日更新)

接口：stk_weekly_monthly描述：股票周/月线行情(每日更新)限量：单次最大6000,可使用交易日期循环提取，总量不限制积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期(格式：YYYYMMDD，每周或每月最后一天的日期）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始交易日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束交易日期</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>频率week周，month月</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>计算截至日期</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>频率(周week,月month)</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>(周/月)开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>(周/月)最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>(周/月)最低价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>(周/月)收盘价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>上一(周/月)收盘价</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>(周/月)成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>(周/月)成交额</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>(周/月)涨跌额</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>(周/月)涨跌幅(未复权,如果是复权请用 通用行情接口)</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

#获取20251024这周周线数据
df=pro.stk_weekly_monthly(trade_date='20251024',freq='week')

#获取202510月月线数据
df=pro.stk_weekly_monthly(trade_date='20251031',freq='month')


```

数据样例

```
            ts_code trade_date  end_date  ...      amount  change  pct_chg
    0     600137.SH   20251024  20251023  ...   429206.49    2.18    11.93
    1     600236.SH   20251024  20251023  ...   510772.77    0.25     3.49
    2     301262.SZ   20251024  20251023  ...  1140060.52    5.69    24.69
    3     600114.SH   20251024  20251023  ...  1786514.91   -0.41    -1.39
    4     301509.SZ   20251024  20251023  ...   225023.73    0.47     1.34
    ...         ...        ...       ...  ...         ...     ...      ...
    5428  920061.BJ   20251024  20251023  ...   153251.70   -0.51    -1.47
    5429  920100.BJ   20251024  20251023  ...   674924.90    5.01     7.45
    5430  603196.SH   20251024  20251023  ...   316237.47    0.85     3.69
    5431  603599.SH   20251024  20251023  ...   370038.63   -0.13    -1.10
    5432  301195.SZ   20251024  20251023  ...   186490.18    1.86     5.66

```
