# 周/月线复权行情(每日更新)

**文档ID**: 365
**原始链接**: https://tushare.pro/document/2?doc_id=365

---

## 股票周/月线行情(复权--每日更新)

接口：stk_week_month_adj描述：股票周/月线行情(复权--每日更新)限量：单次最大6000,可使用交易日期循环提取，总量不限制积分：用户需要至少2000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（格式：YYYYMMDD，每周或每月最后一天的日期）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始交易日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束交易日期</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>频率week周，month月</td>
</tr>
</tbody></table>
<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期（每周五或者月末日期）</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>Y</td>
<td>计算截至日期</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>频率(周week,月month)</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>(周/月)开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>(周/月)最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>(周/月)最低价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>(周/月)收盘价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>上一(周/月)收盘价【除权价，前复权】</td>
</tr>
<tr>
<td>open_qfq</td>
<td>float</td>
<td>Y</td>
<td>前复权(周/月)开盘价</td>
</tr>
<tr>
<td>high_qfq</td>
<td>float</td>
<td>Y</td>
<td>前复权(周/月)最高价</td>
</tr>
<tr>
<td>low_qfq</td>
<td>float</td>
<td>Y</td>
<td>前复权(周/月)最低价</td>
</tr>
<tr>
<td>close_qfq</td>
<td>float</td>
<td>Y</td>
<td>前复权(周/月)收盘价</td>
</tr>
<tr>
<td>open_hfq</td>
<td>float</td>
<td>Y</td>
<td>后复权(周/月)开盘价</td>
</tr>
<tr>
<td>high_hfq</td>
<td>float</td>
<td>Y</td>
<td>后复权(周/月)最高价</td>
</tr>
<tr>
<td>low_hfq</td>
<td>float</td>
<td>Y</td>
<td>后复权(周/月)最低价</td>
</tr>
<tr>
<td>close_hfq</td>
<td>float</td>
<td>Y</td>
<td>后复权(周/月)收盘价</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>(周/月)成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>(周/月)成交额</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>(周/月)涨跌额</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>(周/月)涨跌幅 【基于除权后的昨收计算的涨跌幅：（今收-除权昨收）/除权昨收 】</td>
</tr>
</tbody></table>
```

pro = ts.pro_api()

df=pro.stk_week_month_adj(ts_code='000001.SZ',freq='week')

```

数据样例

```
       ts_code  trade_date  freq   open   high    low  close  pre_close  open_qfq  high_qfq  low_qfq  close_qfq  open_hfq  high_hfq  low_hfq  close_hfq         vol      amount  change  pct_chg
0     000001.SZ   20250117  week  11.25  11.59  11.08  11.45      11.30     11.25     11.59    11.08      11.45   1437.57   1481.02  1415.85    1463.13  4353954.80  4963695.53    0.15     0.01
1     000001.SZ   20250110  week  11.38  11.63  11.22  11.30      11.38     11.38     11.63    11.22      11.30   1454.18   1486.13  1433.74    1443.96  4445402.00  5079074.95   -0.08    -0.01
2     000001.SZ   20250103  week  11.78  11.99  11.36  11.38      11.83     11.78     11.99    11.36      11.38   1505.30   1532.13  1451.63    1454.18  5801491.12  6781578.23   -0.45    -0.04
3     000001.SZ   20241227  week  11.64  12.02  11.64  11.83      11.62     11.64     12.02    11.64      11.83   1487.41   1535.96  1487.41    1511.69  6775611.59  8011303.78    0.21     0.02
4     000001.SZ   20241220  week  11.56  11.74  11.52  11.62      11.56     11.56     11.74    11.52      11.62   1477.18   1500.19  1472.07    1484.85  4036452.70  4689640.57    0.06     0.01
...         ...        ...   ...    ...    ...    ...    ...        ...       ...       ...      ...        ...       ...       ...      ...        ...         ...         ...     ...      ...
1687  000001.SZ   19910503  week  43.90  43.90  43.24  43.24      44.34      0.34      0.48     0.34       0.48     43.90     61.24    43.68      60.93       11.00       48.00   -1.10    -0.02
1688  000001.SZ   19910426  week  45.00  45.00  44.34  44.34      45.46      0.35      0.35     0.35       0.35     45.00     45.00    44.34      44.34       67.00      300.00   -1.12    -0.02
1689  000001.SZ   19910419  week  46.38  46.38  45.69  45.69      47.08      0.36      0.36     0.36       0.36     46.38     46.38    45.69      45.69        9.00       41.00   -1.39    -0.03
1690  000001.SZ   19910412  week  48.04  48.04  47.08  47.08      48.52      0.38      0.38     0.37       0.37     48.04     48.04    47.08      47.08       29.00      138.00   -1.44    -0.03
1691  000001.SZ   19910405  week  48.76  48.76  48.52  48.52      49.00      0.38      0.38     0.38       0.38     48.76     48.76    48.52      48.52        5.00       25.00   -0.48    -0.01

```
