# 同花顺行业概念板块

**文档ID**: 259
**原始链接**: https://tushare.pro/document/2?doc_id=259

---

## 同花顺概念和行业指数

接口：ths_index描述：获取同花顺板块指数。注：数据版权归属同花顺，如做商业用途，请主动联系同花顺，如需帮助请联系微信：waditu_a权限：本接口需有6000积分，单次最大返回5000行数据，一次可提取全部数据，请勿循环提取。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>指数代码</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>市场类型A-a股 HK-港股 US-美股</td>
</tr>
<tr>
<td>type</td>
<td>str</td>
<td>N</td>
<td>指数类型 N-概念指数 I-行业指数 R-地域指数 S-同花顺特色指数 ST-同花顺风格指数 TH-同花顺主题指数 BB-同花顺宽基指数</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>名称</td>
</tr>
<tr>
<td>count</td>
<td>int</td>
<td>Y</td>
<td>成分个数</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>交易所</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>Y</td>
<td>上市日期</td>
</tr>
<tr>
<td>type</td>
<td>str</td>
<td>Y</td>
<td>N概念指数S特色指数</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.ths_index()

```

数据样例

```
       ts_code     name       count exchange list_date type
0    885835.TI     参股银行    126        A  20190416    N
1    885472.TI    上海自贸区     51        A  20130813    N
2    885788.TI     网络直播     63        A  20180312    N
3    885881.TI      云办公     29        A  20200203    N
4    885785.TI     小米概念     91        A  20180306    N
..         ...      ...    ...      ...       ...  ...
266  885566.TI      大飞机     58        A  20140519    N
267  885841.TI  草地贪夜蛾防治     18        A  20190517    N
268  885760.TI    装配式建筑     50        A  20170918    N
269  885909.TI     辅助生殖     15        A  20201023    N
270  885883.TI   医疗废物处理     25        A  20200207    N

```
