# 同花顺涨跌停榜单

**文档ID**: 355
**原始链接**: https://tushare.pro/document/2?doc_id=355

---

## 涨跌停榜单（同花顺）

接口：limit_list_ths描述：获取同花顺每日涨跌停榜单数据，历史数据从20231101开始提供，增量每天16点左右更新限量：单次最大4000条，可根据日期或股票代码循环提取积分：8000积分以上每分钟500次，每天总量不限制，具体请参阅积分获取办法注意：本接口只限个人学习和研究使用，如需商业用途，请自行联系同花顺解决数据采购问题。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码</td>
</tr>
<tr>
<td>limit_type</td>
<td>str</td>
<td>N</td>
<td>涨停池、连扳池、冲刺涨停、炸板池、跌停池，默认：涨停池</td>
</tr>
<tr>
<td>market</td>
<td>str</td>
<td>N</td>
<td>HS-沪深主板 GEM-创业板 STAR-科创板</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>name</td>
<td>str</td>
<td>Y</td>
<td>股票名称</td>
</tr>
<tr>
<td>price</td>
<td>float</td>
<td>Y</td>
<td>收盘价(元)</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅%</td>
</tr>
<tr>
<td>open_num</td>
<td>int</td>
<td>Y</td>
<td>打开次数</td>
</tr>
<tr>
<td>lu_desc</td>
<td>str</td>
<td>Y</td>
<td>涨停原因</td>
</tr>
<tr>
<td>limit_type</td>
<td>str</td>
<td>Y</td>
<td>板单类别</td>
</tr>
<tr>
<td>tag</td>
<td>str</td>
<td>Y</td>
<td>涨停标签</td>
</tr>
<tr>
<td>status</td>
<td>str</td>
<td>Y</td>
<td>涨停状态（N连板、一字板）</td>
</tr>
<tr>
<td>first_lu_time</td>
<td>str</td>
<td>N</td>
<td>首次涨停时间</td>
</tr>
<tr>
<td>last_lu_time</td>
<td>str</td>
<td>N</td>
<td>最后涨停时间</td>
</tr>
<tr>
<td>first_ld_time</td>
<td>str</td>
<td>N</td>
<td>首次跌停时间</td>
</tr>
<tr>
<td>last_ld_time</td>
<td>str</td>
<td>N</td>
<td>最后跌停时间</td>
</tr>
<tr>
<td>limit_order</td>
<td>float</td>
<td>Y</td>
<td>封单量(元</td>
</tr>
<tr>
<td>limit_amount</td>
<td>float</td>
<td>Y</td>
<td>封单额(元</td>
</tr>
<tr>
<td>turnover_rate</td>
<td>float</td>
<td>Y</td>
<td>换手率%</td>
</tr>
<tr>
<td>free_float</td>
<td>float</td>
<td>Y</td>
<td>实际流通(元</td>
</tr>
<tr>
<td>lu_limit_order</td>
<td>float</td>
<td>Y</td>
<td>最大封单(元</td>
</tr>
<tr>
<td>limit_up_suc_rate</td>
<td>float</td>
<td>Y</td>
<td>近一年涨停封板率</td>
</tr>
<tr>
<td>turnover</td>
<td>float</td>
<td>Y</td>
<td>成交额</td>
</tr>
<tr>
<td>rise_rate</td>
<td>float</td>
<td>N</td>
<td>涨速</td>
</tr>
<tr>
<td>sum_float</td>
<td>float</td>
<td>N</td>
<td>总市值（亿元）</td>
</tr>
<tr>
<td>market_type</td>
<td>str</td>
<td>Y</td>
<td>股票类型：HS沪深主板、GEM创业板、STAR科创板</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.limit_list_ths(trade_date='20241125', limit_type='涨停池', fields='ts_code,trade_date,tag,status,lu_desc')

```

数据样例

```
     trade_date   ts_code              lu_desc         tag          status
0     20241125  603518.SH              服装家纺+电商    首板    换手板
1     20241125  003036.SZ  高端纺织机械设备+近年来收购了2家公司  4天4板    T字板
2     20241125  301268.SZ    精密结构件+华为+光伏+一体化压铸    首板    换手板
3     20241125  603655.SH     橡胶+汽车零部件+间接供货特斯拉  2天2板    换手板
4     20241125  600119.SH    上海国资+产业投资+物流+跨境电商  4天2板    换手板
..         ...        ...                  ...   ...    ...
149   20241125  002348.SZ        固态电池+玩具+互联网教育  4天2板    一字板
150   20241125  002175.SZ   “东方系”+芯片+智能制造+物业管理  4天4板    一字板
151   20241125  002155.SZ       湖南万古金矿田探矿获重大突破  3天3板    一字板
152   20241125  002117.SZ   智能机器人+拟向子公司增资+AI应用  2天2板    一字板
153   20241125  002103.SZ       IP产品+广告营销+跨境电商  7天5板    一字板

```
