# 同花顺概念和行业指数行情

**文档ID**: 260
**原始链接**: https://tushare.pro/document/2?doc_id=260

---

## 同花顺板块指数行情

接口：ths_daily描述：获取同花顺板块指数行情。注：数据版权归属同花顺，如做商业用途，请主动联系同花顺，如需帮助请联系微信：waditu_a限量：单次最大3000行数据（需6000积分），可根据指数代码、日期参数循环提取。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>指数代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD格式，下同）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>TS指数代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘点位</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘点位</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高点位</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低点位</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨日收盘点</td>
</tr>
<tr>
<td>avg_price</td>
<td>float</td>
<td>Y</td>
<td>平均价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌点位</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>turnover_rate</td>
<td>float</td>
<td>Y</td>
<td>换手率</td>
</tr>
<tr>
<td>total_mv</td>
<td>float</td>
<td>N</td>
<td>总市值</td>
</tr>
<tr>
<td>float_mv</td>
<td>float</td>
<td>N</td>
<td>流通市值</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()

df = pro.ths_daily(ts_code='865001.TI', start_date='20200101', end_date='20210101', fields='ts_code,trade_date,open,close,high,low,pct_change')

```

数据样例

```
       ts_code trade_date      close       open       high        low pct_change           vol
0    865001.TI   20201231  1664.7530  1660.7060  1671.2290  1649.4200     0.5646  13224.260000
1    865001.TI   20201230  1655.4070  1644.5950  1664.2290  1638.1100     0.3073  10815.800000
2    865001.TI   20201229  1650.3360  1686.1620  1686.1620  1639.0530    -1.6263  11763.170000
3    865001.TI   20201228  1677.6190  1682.5670  1689.8980  1667.2110     0.6698  11813.210000
4    865001.TI   20201224  1666.4570  1663.3270  1668.8490  1648.7920     0.6533   6571.630000
..         ...        ...        ...        ...        ...        ...        ...           ...
229  865001.TI   20200108  1315.8190  1313.4520  1323.2140  1312.7090     0.2567  33180.860000
230  865001.TI   20200107  1312.4500  1319.8580  1323.1850  1311.2390    -0.6790  20959.510000
231  865001.TI   20200106  1321.4230  1322.8090  1328.0270  1314.8890    -0.5953  21283.400000
232  865001.TI   20200103  1329.3370  1309.6150  1330.6640  1309.2810     0.6505  28610.530000
233  865001.TI   20200102  1320.7460  1342.6220  1343.1260  1308.6630    -1.1273  26149.740000    

```
