# 台湾电子产业月营收明细

**文档ID**: 87
**原始链接**: https://tushare.pro/document/2?doc_id=87

---

## 台湾电子产业月营收明细

接口：tmt_twincomedetail描述：获取台湾TMT行业上市公司各类产品月度营收情况。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>报告期</td>
</tr>
<tr>
<td>item</td>
<td>str</td>
<td>N</td>
<td>产品代码</td>
</tr>
<tr>
<td>symbol</td>
<td>str</td>
<td>N</td>
<td>公司代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告期结束日期</td>
</tr>
<tr>
<td>source</td>
<td>str</td>
<td>N</td>
<td>None</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>报告期</td>
</tr>
<tr>
<td>item</td>
<td>str</td>
<td>产品代码</td>
</tr>
<tr>
<td>symbol</td>
<td>str</td>
<td>公司代码</td>
</tr>
<tr>
<td>op_income</td>
<td>str</td>
<td>月度营收</td>
</tr>
<tr>
<td>consop_income</td>
<td>str</td>
<td>合并月度营收（默认不展示）</td>
</tr>
</tbody></table>
数据调用示例

```

pro = ts.pro_api()

#获取台湾松上电子PCB的月度营收数据
df = pro.tmt_twincomedetail(item='8', symbol='6156')

```

数据示例

```
        date item symbol  op_income
0   20180731    8   6156   429618.0
1   20180629    8   6156   367786.0
2   20180531    8   6156   415715.0
3   20180430    8   6156   395857.0
4   20180331    8   6156   405173.0
5   20180227    8   6156   252961.0
6   20180131    8   6156   472289.0
7   20171229    8   6156   408431.0
8   20171130    8   6156   390715.0
9   20171031    8   6156   298781.0
10  20170930    8   6156   367127.0
11  20170831    8   6156   396217.0
12  20170731    8   6156   373196.0
13  20170630    8   6156   380075.0
14  20170531    8   6156   443130.0
15  20170428    8   6156   426106.0
16  20170331    8   6156   418031.0
17  20170224    8   6156   298844.0
18  20170124    8   6156   327690.0
19  20161230    8   6156   431934.0
20  20161130    8   6156   417424.0
21  20161031    8   6156   362774.0
22  20160930    8   6156   392458.0
23  20160831    8   6156   408301.0
24  20160729    8   6156   293324.0
25  20160630    8   6156   329383.0
26  20160531    8   6156   323873.0
27  20160429    8   6156   372231.0
28  20160331    8   6156   388029.0
29  20160226    8   6156   225912.0
```

台湾公司代码

<table>
<thead>
<tr>
<th>symbol</th>
<th>name</th>
</tr>
</thead>
<tbody><tr>
<td>1333</td>
<td>恩得利</td>
</tr>
<tr>
<td>1336</td>
<td>台翰</td>
</tr>
<tr>
<td>1471</td>
<td>首利</td>
</tr>
<tr>
<td>1569</td>
<td>滨川</td>
</tr>
<tr>
<td>1582</td>
<td>信锦</td>
</tr>
<tr>
<td>1585</td>
<td>铠钜</td>
</tr>
<tr>
<td>1595</td>
<td>川宝</td>
</tr>
<tr>
<td>1785</td>
<td>光洋科</td>
</tr>
<tr>
<td>1815</td>
<td>富乔</td>
</tr>
<tr>
<td>2059</td>
<td>川湖</td>
</tr>
<tr>
<td>2301</td>
<td>光宝科</td>
</tr>
<tr>
<td>2302</td>
<td>丽正</td>
</tr>
<tr>
<td>2303</td>
<td>联电</td>
</tr>
<tr>
<td>2305</td>
<td>全友</td>
</tr>
<tr>
<td>2308</td>
<td>台达电</td>
</tr>
<tr>
<td>2312</td>
<td>金宝</td>
</tr>
<tr>
<td>2313</td>
<td>华通</td>
</tr>
<tr>
<td>2314</td>
<td>台扬</td>
</tr>
<tr>
<td>2315</td>
<td>神达电脑</td>
</tr>
<tr>
<td>2316</td>
<td>楠梓电</td>
</tr>
<tr>
<td>2317</td>
<td>鸿海</td>
</tr>
<tr>
<td>2321</td>
<td>东讯</td>
</tr>
<tr>
<td>2323</td>
<td>中环</td>
</tr>
<tr>
<td>2324</td>
<td>仁宝</td>
</tr>
<tr>
<td>2327</td>
<td>国巨</td>
</tr>
<tr>
<td>2328</td>
<td>广宇</td>
</tr>
<tr>
<td>2329</td>
<td>华泰</td>
</tr>
<tr>
<td>2330</td>
<td>台积电</td>
</tr>
<tr>
<td>2331</td>
<td>精英</td>
</tr>
<tr>
<td>2332</td>
<td>友讯</td>
</tr>
<tr>
<td>2337</td>
<td>旺宏</td>
</tr>
<tr>
<td>2338</td>
<td>光罩</td>
</tr>
<tr>
<td>2340</td>
<td>光磊</td>
</tr>
<tr>
<td>2342</td>
<td>茂矽</td>
</tr>
<tr>
<td>2344</td>
<td>华邦电</td>
</tr>
<tr>
<td>2345</td>
<td>智邦</td>
</tr>
<tr>
<td>2347</td>
<td>联强</td>
</tr>
<tr>
<td>2349</td>
<td>铼德</td>
</tr>
<tr>
<td>2351</td>
<td>顺德</td>
</tr>
<tr>
<td>2352</td>
<td>佳世达</td>
</tr>
<tr>
<td>2353</td>
<td>宏棋</td>
</tr>
<tr>
<td>2354</td>
<td>鸿准</td>
</tr>
<tr>
<td>2355</td>
<td>敬鹏</td>
</tr>
<tr>
<td>2356</td>
<td>英业达</td>
</tr>
<tr>
<td>2357</td>
<td>华硕</td>
</tr>
<tr>
<td>2359</td>
<td>所罗门</td>
</tr>
<tr>
<td>2360</td>
<td>致茂</td>
</tr>
<tr>
<td>2362</td>
<td>蓝天</td>
</tr>
<tr>
<td>2363</td>
<td>矽统</td>
</tr>
<tr>
<td>2364</td>
<td>伦飞</td>
</tr>
<tr>
<td>2365</td>
<td>昆盈</td>
</tr>
<tr>
<td>2367</td>
<td>?d华</td>
</tr>
<tr>
<td>2368</td>
<td>金像电</td>
</tr>
<tr>
<td>2369</td>
<td>菱生</td>
</tr>
<tr>
<td>2373</td>
<td>震旦行</td>
</tr>
<tr>
<td>2374</td>
<td>佳能</td>
</tr>
<tr>
<td>2375</td>
<td>智宝</td>
</tr>
<tr>
<td>2376</td>
<td>技嘉</td>
</tr>
<tr>
<td>2377</td>
<td>微星</td>
</tr>
<tr>
<td>2379</td>
<td>瑞昱</td>
</tr>
<tr>
<td>2380</td>
<td>虹光</td>
</tr>
<tr>
<td>2382</td>
<td>广达</td>
</tr>
<tr>
<td>2383</td>
<td>台光电</td>
</tr>
<tr>
<td>2385</td>
<td>群光</td>
</tr>
<tr>
<td>2387</td>
<td>精元</td>
</tr>
<tr>
<td>2388</td>
<td>威盛</td>
</tr>
<tr>
<td>2390</td>
<td>云辰</td>
</tr>
<tr>
<td>2392</td>
<td>正崴</td>
</tr>
<tr>
<td>2393</td>
<td>亿光</td>
</tr>
<tr>
<td>2395</td>
<td>研华</td>
</tr>
<tr>
<td>2397</td>
<td>友通</td>
</tr>
<tr>
<td>2399</td>
<td>映泰</td>
</tr>
<tr>
<td>2401</td>
<td>凌阳</td>
</tr>
<tr>
<td>2402</td>
<td>毅嘉</td>
</tr>
<tr>
<td>2404</td>
<td>汉唐</td>
</tr>
<tr>
<td>2405</td>
<td>浩鑫</td>
</tr>
<tr>
<td>2406</td>
<td>国硕</td>
</tr>
<tr>
<td>2408</td>
<td>南亚科</td>
</tr>
<tr>
<td>2409</td>
<td>友达</td>
</tr>
<tr>
<td>2412</td>
<td>中华电</td>
</tr>
<tr>
<td>2413</td>
<td>环科</td>
</tr>
<tr>
<td>2414</td>
<td>精技</td>
</tr>
<tr>
<td>2415</td>
<td>錩新</td>
</tr>
<tr>
<td>2417</td>
<td>圆刚</td>
</tr>
<tr>
<td>2419</td>
<td>仲琦</td>
</tr>
<tr>
<td>2420</td>
<td>新巨</td>
</tr>
<tr>
<td>2421</td>
<td>建准</td>
</tr>
<tr>
<td>2423</td>
<td>固纬</td>
</tr>
<tr>
<td>2424</td>
<td>陇华</td>
</tr>
<tr>
<td>2425</td>
<td>承启</td>
</tr>
<tr>
<td>2426</td>
<td>鼎元</td>
</tr>
<tr>
<td>2427</td>
<td>三商电</td>
</tr>
<tr>
<td>2428</td>
<td>兴勤</td>
</tr>
<tr>
<td>2429</td>
<td>铭旺科</td>
</tr>
<tr>
<td>2430</td>
<td>灿坤</td>
</tr>
<tr>
<td>2431</td>
<td>联昌</td>
</tr>
<tr>
<td>2433</td>
<td>互盛电</td>
</tr>
<tr>
<td>2434</td>
<td>统懋</td>
</tr>
<tr>
<td>2436</td>
<td>伟诠电</td>
</tr>
<tr>
<td>2438</td>
<td>翔耀</td>
</tr>
<tr>
<td>2439</td>
<td>美律</td>
</tr>
<tr>
<td>2440</td>
<td>太空梭</td>
</tr>
<tr>
<td>2441</td>
<td>超丰</td>
</tr>
<tr>
<td>2442</td>
<td>新美齐</td>
</tr>
<tr>
<td>2444</td>
<td>兆劲</td>
</tr>
<tr>
<td>2448</td>
<td>晶电</td>
</tr>
<tr>
<td>2449</td>
<td>京元电子</td>
</tr>
<tr>
<td>2450</td>
<td>神脑</td>
</tr>
<tr>
<td>2451</td>
<td>创见</td>
</tr>
<tr>
<td>2453</td>
<td>凌群</td>
</tr>
<tr>
<td>2454</td>
<td>联发科</td>
</tr>
<tr>
<td>2455</td>
<td>全新</td>
</tr>
<tr>
<td>2456</td>
<td>奇力新</td>
</tr>
<tr>
<td>2457</td>
<td>飞宏</td>
</tr>
<tr>
<td>2458</td>
<td>义隆</td>
</tr>
<tr>
<td>2459</td>
<td>敦吉</td>
</tr>
<tr>
<td>2460</td>
<td>建通</td>
</tr>
<tr>
<td>2461</td>
<td>光群雷</td>
</tr>
<tr>
<td>2462</td>
<td>良得电</td>
</tr>
<tr>
<td>2464</td>
<td>盟立</td>
</tr>
<tr>
<td>2465</td>
<td>丽台</td>
</tr>
<tr>
<td>2466</td>
<td>冠西电</td>
</tr>
<tr>
<td>2467</td>
<td>志圣</td>
</tr>
<tr>
<td>2468</td>
<td>华经</td>
</tr>
<tr>
<td>2471</td>
<td>资通</td>
</tr>
<tr>
<td>2472</td>
<td>立隆电</td>
</tr>
<tr>
<td>2474</td>
<td>可成</td>
</tr>
<tr>
<td>2475</td>
<td>华映</td>
</tr>
<tr>
<td>2476</td>
<td>钜祥</td>
</tr>
<tr>
<td>2477</td>
<td>美隆电</td>
</tr>
<tr>
<td>2478</td>
<td>大毅</td>
</tr>
<tr>
<td>2480</td>
<td>敦阳科</td>
</tr>
<tr>
<td>2481</td>
<td>强茂</td>
</tr>
<tr>
<td>2482</td>
<td>连宇</td>
</tr>
<tr>
<td>2483</td>
<td>百容</td>
</tr>
<tr>
<td>2484</td>
<td>希华</td>
</tr>
<tr>
<td>2485</td>
<td>兆赫</td>
</tr>
<tr>
<td>2486</td>
<td>一诠</td>
</tr>
<tr>
<td>2488</td>
<td>汉平</td>
</tr>
<tr>
<td>2489</td>
<td>瑞轩</td>
</tr>
<tr>
<td>2491</td>
<td>吉祥全</td>
</tr>
<tr>
<td>2492</td>
<td>华新科</td>
</tr>
<tr>
<td>2493</td>
<td>扬博</td>
</tr>
<tr>
<td>2495</td>
<td>普安</td>
</tr>
<tr>
<td>2496</td>
<td>卓越</td>
</tr>
<tr>
<td>2497</td>
<td>怡利电</td>
</tr>
<tr>
<td>2498</td>
<td>宏达电</td>
</tr>
<tr>
<td>2499</td>
<td>东贝</td>
</tr>
<tr>
<td>3002</td>
<td>欧格</td>
</tr>
<tr>
<td>3003</td>
<td>健和兴</td>
</tr>
<tr>
<td>3005</td>
<td>神基</td>
</tr>
<tr>
<td>3006</td>
<td>晶豪科</td>
</tr>
<tr>
<td>3008</td>
<td>大立光</td>
</tr>
<tr>
<td>3010</td>
<td>华立</td>
</tr>
<tr>
<td>3011</td>
<td>今皓</td>
</tr>
<tr>
<td>3013</td>
<td>晟铭电</td>
</tr>
<tr>
<td>3014</td>
<td>联阳</td>
</tr>
<tr>
<td>3015</td>
<td>全汉</td>
</tr>
<tr>
<td>3016</td>
<td>嘉晶</td>
</tr>
<tr>
<td>3017</td>
<td>奇鋐</td>
</tr>
<tr>
<td>3018</td>
<td>同开</td>
</tr>
<tr>
<td>3019</td>
<td>亚光</td>
</tr>
<tr>
<td>3021</td>
<td>鸿名</td>
</tr>
<tr>
<td>3022</td>
<td>威强电</td>
</tr>
<tr>
<td>3023</td>
<td>信邦</td>
</tr>
<tr>
<td>3024</td>
<td>忆声</td>
</tr>
<tr>
<td>3025</td>
<td>星通</td>
</tr>
<tr>
<td>3026</td>
<td>禾伸堂</td>
</tr>
<tr>
<td>3027</td>
<td>盛达</td>
</tr>
<tr>
<td>3028</td>
<td>增你强</td>
</tr>
<tr>
<td>3029</td>
<td>零壹</td>
</tr>
<tr>
<td>3030</td>
<td>德律</td>
</tr>
<tr>
<td>3031</td>
<td>佰鸿</td>
</tr>
<tr>
<td>3032</td>
<td>伟训</td>
</tr>
<tr>
<td>3033</td>
<td>威健</td>
</tr>
<tr>
<td>3034</td>
<td>联咏</td>
</tr>
<tr>
<td>3035</td>
<td>智原</td>
</tr>
<tr>
<td>3036</td>
<td>文晔</td>
</tr>
<tr>
<td>3037</td>
<td>欣兴</td>
</tr>
<tr>
<td>3038</td>
<td>全台</td>
</tr>
<tr>
<td>3041</td>
<td>扬智</td>
</tr>
<tr>
<td>3042</td>
<td>晶技</td>
</tr>
<tr>
<td>3043</td>
<td>科风</td>
</tr>
<tr>
<td>3044</td>
<td>健鼎</td>
</tr>
<tr>
<td>3045</td>
<td>台湾大</td>
</tr>
<tr>
<td>3046</td>
<td>建棋</td>
</tr>
<tr>
<td>3047</td>
<td>讯舟</td>
</tr>
<tr>
<td>3048</td>
<td>益登</td>
</tr>
<tr>
<td>3049</td>
<td>和鑫</td>
</tr>
<tr>
<td>3050</td>
<td>钰德</td>
</tr>
<tr>
<td>3051</td>
<td>力特</td>
</tr>
<tr>
<td>3054</td>
<td>立万利</td>
</tr>
<tr>
<td>3055</td>
<td>蔚华科</td>
</tr>
<tr>
<td>3057</td>
<td>乔鼎</td>
</tr>
<tr>
<td>3058</td>
<td>立德</td>
</tr>
<tr>
<td>3059</td>
<td>华晶科</td>
</tr>
<tr>
<td>3060</td>
<td>铭异</td>
</tr>
<tr>
<td>3062</td>
<td>建汉</td>
</tr>
<tr>
<td>3066</td>
<td>李洲</td>
</tr>
<tr>
<td>3067</td>
<td>全域</td>
</tr>
<tr>
<td>3071</td>
<td>协禧</td>
</tr>
<tr>
<td>3073</td>
<td>凯柏实业</td>
</tr>
<tr>
<td>3078</td>
<td>侨威</td>
</tr>
<tr>
<td>3081</td>
<td>联亚</td>
</tr>
<tr>
<td>3085</td>
<td>新零售</td>
</tr>
<tr>
<td>3088</td>
<td>艾讯</td>
</tr>
<tr>
<td>3089</td>
<td>元炬</td>
</tr>
<tr>
<td>3090</td>
<td>日电贸</td>
</tr>
<tr>
<td>3092</td>
<td>鸿硕</td>
</tr>
<tr>
<td>3093</td>
<td>港建</td>
</tr>
<tr>
<td>3094</td>
<td>联杰</td>
</tr>
<tr>
<td>3095</td>
<td>及成</td>
</tr>
<tr>
<td>3097</td>
<td>拍档</td>
</tr>
<tr>
<td>3105</td>
<td>稳懋</td>
</tr>
<tr>
<td>3114</td>
<td>好德</td>
</tr>
<tr>
<td>3115</td>
<td>宝岛极</td>
</tr>
<tr>
<td>3117</td>
<td>年程</td>
</tr>
<tr>
<td>3122</td>
<td>笙泉</td>
</tr>
<tr>
<td>3128</td>
<td>升锐</td>
</tr>
<tr>
<td>3130</td>
<td>一零四</td>
</tr>
<tr>
<td>3131</td>
<td>弘塑</td>
</tr>
<tr>
<td>3138</td>
<td>耀登</td>
</tr>
<tr>
<td>3141</td>
<td>晶宏</td>
</tr>
<tr>
<td>3144</td>
<td>新扬科</td>
</tr>
<tr>
<td>3147</td>
<td>大综</td>
</tr>
<tr>
<td>3149</td>
<td>正达</td>
</tr>
<tr>
<td>3150</td>
<td>钰宝</td>
</tr>
<tr>
<td>3152</td>
<td>景德</td>
</tr>
<tr>
<td>3158</td>
<td>嘉实</td>
</tr>
<tr>
<td>3163</td>
<td>波若威</td>
</tr>
<tr>
<td>3168</td>
<td>众福科</td>
</tr>
<tr>
<td>3169</td>
<td>亚信</td>
</tr>
<tr>
<td>3178</td>
<td>公准</td>
</tr>
<tr>
<td>3188</td>
<td>鑫龙腾</td>
</tr>
<tr>
<td>3189</td>
<td>景硕</td>
</tr>
<tr>
<td>3191</td>
<td>和进</td>
</tr>
<tr>
<td>3202</td>
<td>桦晟</td>
</tr>
<tr>
<td>3206</td>
<td>志丰</td>
</tr>
<tr>
<td>3207</td>
<td>耀胜</td>
</tr>
<tr>
<td>3209</td>
<td>全科</td>
</tr>
<tr>
<td>3211</td>
<td>顺达</td>
</tr>
<tr>
<td>3213</td>
<td>茂讯</td>
</tr>
<tr>
<td>3217</td>
<td>优群</td>
</tr>
<tr>
<td>3219</td>
<td>倚强</td>
</tr>
<tr>
<td>3221</td>
<td>台嘉硕</td>
</tr>
<tr>
<td>3224</td>
<td>三顾</td>
</tr>
<tr>
<td>3227</td>
<td>原相</td>
</tr>
<tr>
<td>3228</td>
<td>金丽科</td>
</tr>
<tr>
<td>3229</td>
<td>晟钛</td>
</tr>
<tr>
<td>3230</td>
<td>锦明</td>
</tr>
<tr>
<td>3231</td>
<td>纬创</td>
</tr>
<tr>
<td>3232</td>
<td>昱捷</td>
</tr>
<tr>
<td>3234</td>
<td>光环</td>
</tr>
<tr>
<td>3236</td>
<td>千如</td>
</tr>
<tr>
<td>3257</td>
<td>虹冠电</td>
</tr>
<tr>
<td>3259</td>
<td>鑫创</td>
</tr>
<tr>
<td>3260</td>
<td>威刚</td>
</tr>
<tr>
<td>3264</td>
<td>欣铨</td>
</tr>
<tr>
<td>3265</td>
<td>台星科</td>
</tr>
<tr>
<td>3268</td>
<td>海德威</td>
</tr>
<tr>
<td>3272</td>
<td>东硕</td>
</tr>
<tr>
<td>3276</td>
<td>宇环</td>
</tr>
<tr>
<td>3285</td>
<td>微端</td>
</tr>
<tr>
<td>3287</td>
<td>广寰科</td>
</tr>
<tr>
<td>3288</td>
<td>点晶</td>
</tr>
<tr>
<td>3289</td>
<td>宜特</td>
</tr>
<tr>
<td>3290</td>
<td>东浦</td>
</tr>
<tr>
<td>3294</td>
<td>英济</td>
</tr>
<tr>
<td>3296</td>
<td>胜德</td>
</tr>
<tr>
<td>3297</td>
<td>杭特</td>
</tr>
<tr>
<td>3299</td>
<td>帛汉</td>
</tr>
<tr>
<td>3303</td>
<td>岱棱</td>
</tr>
<tr>
<td>3305</td>
<td>升贸</td>
</tr>
<tr>
<td>3306</td>
<td>鼎天</td>
</tr>
<tr>
<td>3308</td>
<td>联德</td>
</tr>
<tr>
<td>3310</td>
<td>佳颖</td>
</tr>
<tr>
<td>3311</td>
<td>闳晖</td>
</tr>
<tr>
<td>3312</td>
<td>弘忆股</td>
</tr>
<tr>
<td>3313</td>
<td>斐成</td>
</tr>
<tr>
<td>3317</td>
<td>尼克森</td>
</tr>
<tr>
<td>3321</td>
<td>同泰</td>
</tr>
<tr>
<td>3322</td>
<td>建舜电</td>
</tr>
<tr>
<td>3323</td>
<td>加百裕</td>
</tr>
<tr>
<td>3324</td>
<td>双鸿</td>
</tr>
<tr>
<td>3325</td>
<td>旭品</td>
</tr>
<tr>
<td>3332</td>
<td>幸康</td>
</tr>
<tr>
<td>3338</td>
<td>泰硕</td>
</tr>
<tr>
<td>3339</td>
<td>泰谷</td>
</tr>
<tr>
<td>3349</td>
<td>宝德</td>
</tr>
<tr>
<td>3354</td>
<td>律胜</td>
</tr>
<tr>
<td>3356</td>
<td>奇偶</td>
</tr>
<tr>
<td>3357</td>
<td>台庆科</td>
</tr>
<tr>
<td>3360</td>
<td>尚立</td>
</tr>
<tr>
<td>3362</td>
<td>先进光</td>
</tr>
<tr>
<td>3363</td>
<td>上诠</td>
</tr>
<tr>
<td>3372</td>
<td>典范</td>
</tr>
<tr>
<td>3373</td>
<td>热映</td>
</tr>
<tr>
<td>3374</td>
<td>精材</td>
</tr>
<tr>
<td>3376</td>
<td>新日兴</td>
</tr>
<tr>
<td>3377</td>
<td>健格</td>
</tr>
<tr>
<td>3380</td>
<td>明泰</td>
</tr>
<tr>
<td>3383</td>
<td>新世纪</td>
</tr>
<tr>
<td>3388</td>
<td>崇越电</td>
</tr>
<tr>
<td>3390</td>
<td>旭软</td>
</tr>
<tr>
<td>3391</td>
<td>佳得</td>
</tr>
<tr>
<td>3402</td>
<td>汉科</td>
</tr>
<tr>
<td>3406</td>
<td>玉晶光</td>
</tr>
<tr>
<td>3413</td>
<td>京鼎</td>
</tr>
<tr>
<td>3416</td>
<td>融程电</td>
</tr>
<tr>
<td>3419</td>
<td>哗裕</td>
</tr>
<tr>
<td>3428</td>
<td>光燿科</td>
</tr>
<tr>
<td>3429</td>
<td>彦阳</td>
</tr>
<tr>
<td>3431</td>
<td>长天</td>
</tr>
<tr>
<td>3432</td>
<td>台端</td>
</tr>
<tr>
<td>3434</td>
<td>哲固</td>
</tr>
<tr>
<td>3437</td>
<td>荣创</td>
</tr>
<tr>
<td>3438</td>
<td>类比科</td>
</tr>
<tr>
<td>3441</td>
<td>联一光</td>
</tr>
<tr>
<td>3443</td>
<td>创意</td>
</tr>
<tr>
<td>3444</td>
<td>利机</td>
</tr>
<tr>
<td>3450</td>
<td>联钧</td>
</tr>
<tr>
<td>3452</td>
<td>益通</td>
</tr>
<tr>
<td>3454</td>
<td>晶睿</td>
</tr>
<tr>
<td>3455</td>
<td>由田</td>
</tr>
<tr>
<td>3465</td>
<td>祥业</td>
</tr>
<tr>
<td>3466</td>
<td>致振</td>
</tr>
<tr>
<td>3479</td>
<td>安勤</td>
</tr>
<tr>
<td>3481</td>
<td>群创</td>
</tr>
<tr>
<td>3483</td>
<td>力致</td>
</tr>
<tr>
<td>3484</td>
<td>崧腾</td>
</tr>
<tr>
<td>3485</td>
<td>叙丰</td>
</tr>
<tr>
<td>3490</td>
<td>单井</td>
</tr>
<tr>
<td>3491</td>
<td>升达科</td>
</tr>
<tr>
<td>3492</td>
<td>长盛</td>
</tr>
<tr>
<td>3494</td>
<td>诚研</td>
</tr>
<tr>
<td>3498</td>
<td>阳程</td>
</tr>
<tr>
<td>3499</td>
<td>环天科</td>
</tr>
<tr>
<td>3501</td>
<td>维熹</td>
</tr>
<tr>
<td>3504</td>
<td>扬明光</td>
</tr>
<tr>
<td>3508</td>
<td>位速</td>
</tr>
<tr>
<td>3511</td>
<td>矽玛</td>
</tr>
<tr>
<td>3512</td>
<td>皇龙</td>
</tr>
<tr>
<td>3514</td>
<td>昱晶</td>
</tr>
<tr>
<td>3515</td>
<td>华擎</td>
</tr>
<tr>
<td>3516</td>
<td>亚帝欧</td>
</tr>
<tr>
<td>3518</td>
<td>柏腾</td>
</tr>
<tr>
<td>3519</td>
<td>绿能</td>
</tr>
<tr>
<td>3520</td>
<td>振维</td>
</tr>
<tr>
<td>3521</td>
<td>鸿翊</td>
</tr>
<tr>
<td>3522</td>
<td>御顶</td>
</tr>
<tr>
<td>3523</td>
<td>迎辉</td>
</tr>
<tr>
<td>3526</td>
<td>凡甲</td>
</tr>
<tr>
<td>3527</td>
<td>聚积</td>
</tr>
<tr>
<td>3528</td>
<td>安驰</td>
</tr>
<tr>
<td>3529</td>
<td>力旺</td>
</tr>
<tr>
<td>3530</td>
<td>晶相光</td>
</tr>
<tr>
<td>3531</td>
<td>先益</td>
</tr>
<tr>
<td>3532</td>
<td>台胜科</td>
</tr>
<tr>
<td>3533</td>
<td>嘉泽</td>
</tr>
<tr>
<td>3535</td>
<td>晶彩科</td>
</tr>
<tr>
<td>3536</td>
<td>诚创</td>
</tr>
<tr>
<td>3537</td>
<td>堡达</td>
</tr>
<tr>
<td>3540</td>
<td>曜越</td>
</tr>
<tr>
<td>3541</td>
<td>西柏</td>
</tr>
<tr>
<td>3543</td>
<td>州巧</td>
</tr>
<tr>
<td>3545</td>
<td>敦泰</td>
</tr>
<tr>
<td>3548</td>
<td>兆利</td>
</tr>
<tr>
<td>3550</td>
<td>联颖</td>
</tr>
<tr>
<td>3551</td>
<td>世禾</td>
</tr>
<tr>
<td>3552</td>
<td>同致</td>
</tr>
<tr>
<td>3555</td>
<td>重鹏</td>
</tr>
<tr>
<td>3556</td>
<td>禾瑞亚</td>
</tr>
<tr>
<td>3557</td>
<td>嘉威</td>
</tr>
<tr>
<td>3558</td>
<td>神准</td>
</tr>
<tr>
<td>3561</td>
<td>升阳光电</td>
</tr>
<tr>
<td>3562</td>
<td>顶晶科</td>
</tr>
<tr>
<td>3563</td>
<td>牧德</td>
</tr>
<tr>
<td>3564</td>
<td>其阳</td>
</tr>
<tr>
<td>3566</td>
<td>太阳光</td>
</tr>
<tr>
<td>3567</td>
<td>逸昌</td>
</tr>
<tr>
<td>3570</td>
<td>大冢</td>
</tr>
<tr>
<td>3576</td>
<td>新日光</td>
</tr>
<tr>
<td>3577</td>
<td>泓格</td>
</tr>
<tr>
<td>3579</td>
<td>尚志</td>
</tr>
<tr>
<td>3580</td>
<td>友威科</td>
</tr>
<tr>
<td>3581</td>
<td>博磊</td>
</tr>
<tr>
<td>3583</td>
<td>辛耘</td>
</tr>
<tr>
<td>3585</td>
<td>联致</td>
</tr>
<tr>
<td>3587</td>
<td>闳康</td>
</tr>
<tr>
<td>3588</td>
<td>通嘉</td>
</tr>
<tr>
<td>3591</td>
<td>艾笛森</td>
</tr>
<tr>
<td>3592</td>
<td>瑞鼎</td>
</tr>
<tr>
<td>3593</td>
<td>力铭</td>
</tr>
<tr>
<td>3594</td>
<td>磐仪</td>
</tr>
<tr>
<td>3595</td>
<td>山太士</td>
</tr>
<tr>
<td>3596</td>
<td>智易</td>
</tr>
<tr>
<td>3597</td>
<td>映兴</td>
</tr>
<tr>
<td>3601</td>
<td>前源</td>
</tr>
<tr>
<td>3603</td>
<td>建祥国际</td>
</tr>
<tr>
<td>3605</td>
<td>宏致</td>
</tr>
<tr>
<td>3607</td>
<td>谷崧</td>
</tr>
<tr>
<td>3609</td>
<td>东林</td>
</tr>
<tr>
<td>3611</td>
<td>鼎翰</td>
</tr>
<tr>
<td>3615</td>
<td>安可</td>
</tr>
<tr>
<td>3617</td>
<td>硕天</td>
</tr>
<tr>
<td>3622</td>
<td>洋华</td>
</tr>
<tr>
<td>3623</td>
<td>富晶通</td>
</tr>
<tr>
<td>3624</td>
<td>光颉</td>
</tr>
<tr>
<td>3625</td>
<td>西胜</td>
</tr>
<tr>
<td>3627</td>
<td>华信科</td>
</tr>
<tr>
<td>3628</td>
<td>盈正</td>
</tr>
<tr>
<td>3629</td>
<td>地心引力</td>
</tr>
<tr>
<td>3630</td>
<td>新钜科</td>
</tr>
<tr>
<td>3631</td>
<td>晟楠</td>
</tr>
<tr>
<td>3632</td>
<td>研勤</td>
</tr>
<tr>
<td>3633</td>
<td>云光</td>
</tr>
<tr>
<td>3642</td>
<td>骏熠电</td>
</tr>
<tr>
<td>3644</td>
<td>凌嘉科</td>
</tr>
<tr>
<td>3645</td>
<td>达迈</td>
</tr>
<tr>
<td>3646</td>
<td>艾恩特</td>
</tr>
<tr>
<td>3652</td>
<td>精联</td>
</tr>
<tr>
<td>3653</td>
<td>健策</td>
</tr>
<tr>
<td>3659</td>
<td>百辰</td>
</tr>
<tr>
<td>3661</td>
<td>世芯-KY</td>
</tr>
<tr>
<td>3663</td>
<td>鑫科</td>
</tr>
<tr>
<td>3664</td>
<td>安瑞-KY</td>
</tr>
<tr>
<td>3665</td>
<td>贸联-KY</td>
</tr>
<tr>
<td>3666</td>
<td>光耀</td>
</tr>
<tr>
<td>3669</td>
<td>圆展</td>
</tr>
<tr>
<td>3672</td>
<td>康联讯</td>
</tr>
<tr>
<td>3673</td>
<td>TPK-KY</td>
</tr>
<tr>
<td>3674</td>
<td>康讯</td>
</tr>
<tr>
<td>3675</td>
<td>德微</td>
</tr>
<tr>
<td>3678</td>
<td>联享</td>
</tr>
<tr>
<td>3679</td>
<td>新至升</td>
</tr>
<tr>
<td>3680</td>
<td>家登</td>
</tr>
<tr>
<td>3682</td>
<td>亚太电</td>
</tr>
<tr>
<td>3684</td>
<td>荣昌</td>
</tr>
<tr>
<td>3685</td>
<td>元创精密</td>
</tr>
<tr>
<td>3686</td>
<td>达能</td>
</tr>
<tr>
<td>3688</td>
<td>华立捷</td>
</tr>
<tr>
<td>3689</td>
<td>涌德</td>
</tr>
<tr>
<td>3691</td>
<td>硕禾</td>
</tr>
<tr>
<td>3693</td>
<td>营邦</td>
</tr>
<tr>
<td>3694</td>
<td>海华</td>
</tr>
<tr>
<td>3697</td>
<td>F-晨星</td>
</tr>
<tr>
<td>3698</td>
<td>隆达</td>
</tr>
<tr>
<td>3701</td>
<td>大众控</td>
</tr>
<tr>
<td>3702</td>
<td>大联大</td>
</tr>
<tr>
<td>3704</td>
<td>合勤控</td>
</tr>
<tr>
<td>3706</td>
<td>神达</td>
</tr>
<tr>
<td>3707</td>
<td>汉磊</td>
</tr>
<tr>
<td>3709</td>
<td>鑫联大投控</td>
</tr>
<tr>
<td>3710</td>
<td>连展投控</td>
</tr>
<tr>
<td>3711</td>
<td>日月光投控</td>
</tr>
<tr>
<td>3712</td>
<td>永崴投控</td>
</tr>
<tr>
<td>4537</td>
<td>旭东</td>
</tr>
<tr>
<td>4542</td>
<td>科峤</td>
</tr>
<tr>
<td>4545</td>
<td>铭钰</td>
</tr>
<tr>
<td>4554</td>
<td>橙的</td>
</tr>
<tr>
<td>4729</td>
<td>荧茂</td>
</tr>
<tr>
<td>4760</td>
<td>勤凯</td>
</tr>
<tr>
<td>4903</td>
<td>联光通</td>
</tr>
<tr>
<td>4904</td>
<td>远传</td>
</tr>
<tr>
<td>4905</td>
<td>台联电</td>
</tr>
<tr>
<td>4906</td>
<td>正文</td>
</tr>
<tr>
<td>4908</td>
<td>前鼎</td>
</tr>
<tr>
<td>4909</td>
<td>新复兴</td>
</tr>
<tr>
<td>4912</td>
<td>联德控股-KY</td>
</tr>
<tr>
<td>4915</td>
<td>致伸</td>
</tr>
<tr>
<td>4916</td>
<td>事欣科</td>
</tr>
<tr>
<td>4919</td>
<td>新唐</td>
</tr>
<tr>
<td>4921</td>
<td>宏阳</td>
</tr>
<tr>
<td>4923</td>
<td>力士</td>
</tr>
<tr>
<td>4924</td>
<td>欣厚-KY</td>
</tr>
<tr>
<td>4925</td>
<td>智微</td>
</tr>
<tr>
<td>4927</td>
<td>泰鼎-KY</td>
</tr>
<tr>
<td>4931</td>
<td>新盛力</td>
</tr>
<tr>
<td>4933</td>
<td>友辉</td>
</tr>
<tr>
<td>4934</td>
<td>太极</td>
</tr>
<tr>
<td>4935</td>
<td>茂林-KY</td>
</tr>
<tr>
<td>4938</td>
<td>和硕</td>
</tr>
<tr>
<td>4939</td>
<td>亚电</td>
</tr>
<tr>
<td>4942</td>
<td>嘉彰</td>
</tr>
<tr>
<td>4943</td>
<td>康控-KY</td>
</tr>
<tr>
<td>4944</td>
<td>兆远</td>
</tr>
<tr>
<td>4947</td>
<td>昂宝-KY</td>
</tr>
<tr>
<td>4949</td>
<td>有成</td>
</tr>
<tr>
<td>4951</td>
<td>精拓科</td>
</tr>
<tr>
<td>4952</td>
<td>凌通</td>
</tr>
<tr>
<td>4953</td>
<td>纬软</td>
</tr>
<tr>
<td>4956</td>
<td>光鋐</td>
</tr>
<tr>
<td>4958</td>
<td>臻鼎-KY</td>
</tr>
<tr>
<td>4960</td>
<td>诚美材</td>
</tr>
<tr>
<td>4961</td>
<td>天钰</td>
</tr>
<tr>
<td>4966</td>
<td>谱瑞-KY</td>
</tr>
<tr>
<td>4967</td>
<td>十铨</td>
</tr>
<tr>
<td>4968</td>
<td>立积</td>
</tr>
<tr>
<td>4971</td>
<td>IET-KY</td>
</tr>
<tr>
<td>4972</td>
<td>汤石照明</td>
</tr>
<tr>
<td>4973</td>
<td>广颖</td>
</tr>
<tr>
<td>4974</td>
<td>亚泰</td>
</tr>
<tr>
<td>4976</td>
<td>佳凌</td>
</tr>
<tr>
<td>4977</td>
<td>众达-KY</td>
</tr>
<tr>
<td>4979</td>
<td>华星光</td>
</tr>
<tr>
<td>4980</td>
<td>佐臻</td>
</tr>
<tr>
<td>4984</td>
<td>科纳-KY</td>
</tr>
<tr>
<td>4987</td>
<td>科诚</td>
</tr>
<tr>
<td>4989</td>
<td>荣科</td>
</tr>
<tr>
<td>4991</td>
<td>环宇-KY</td>
</tr>
<tr>
<td>4994</td>
<td>传奇</td>
</tr>
<tr>
<td>4995</td>
<td>晶达</td>
</tr>
<tr>
<td>4999</td>
<td>鑫禾</td>
</tr>
<tr>
<td>5201</td>
<td>凯卫</td>
</tr>
<tr>
<td>5202</td>
<td>力新</td>
</tr>
<tr>
<td>5203</td>
<td>讯连</td>
</tr>
<tr>
<td>5205</td>
<td>中茂</td>
</tr>
<tr>
<td>5209</td>
<td>新鼎</td>
</tr>
<tr>
<td>5210</td>
<td>宝硕</td>
</tr>
<tr>
<td>5211</td>
<td>蒙恬</td>
</tr>
<tr>
<td>5212</td>
<td>凌网</td>
</tr>
<tr>
<td>5215</td>
<td>科嘉-KY</td>
</tr>
<tr>
<td>5216</td>
<td>优灯</td>
</tr>
<tr>
<td>5220</td>
<td>万达光电</td>
</tr>
<tr>
<td>5222</td>
<td>全讯</td>
</tr>
<tr>
<td>5223</td>
<td>安力-KY</td>
</tr>
<tr>
<td>5225</td>
<td>东科-KY</td>
</tr>
<tr>
<td>5227</td>
<td>立凯-KY</td>
</tr>
<tr>
<td>5228</td>
<td>钰铠</td>
</tr>
<tr>
<td>5230</td>
<td>雷笛克光学</td>
</tr>
<tr>
<td>5233</td>
<td>有量</td>
</tr>
<tr>
<td>5234</td>
<td>达兴材料</td>
</tr>
<tr>
<td>5240</td>
<td>建腾</td>
</tr>
<tr>
<td>5243</td>
<td>乙盛-KY</td>
</tr>
<tr>
<td>5244</td>
<td>弘凯</td>
</tr>
<tr>
<td>5245</td>
<td>智晶</td>
</tr>
<tr>
<td>5248</td>
<td>景传</td>
</tr>
<tr>
<td>5251</td>
<td>天钺电</td>
</tr>
<tr>
<td>5255</td>
<td>美桀</td>
</tr>
<tr>
<td>5256</td>
<td>锐捷</td>
</tr>
<tr>
<td>5258</td>
<td>虹堡</td>
</tr>
<tr>
<td>5259</td>
<td>清惠</td>
</tr>
<tr>
<td>5262</td>
<td>立达</td>
</tr>
<tr>
<td>5264</td>
<td>铠胜-KY</td>
</tr>
<tr>
<td>5267</td>
<td>龙翩</td>
</tr>
<tr>
<td>5269</td>
<td>祥硕</td>
</tr>
<tr>
<td>5271</td>
<td>紘通</td>
</tr>
<tr>
<td>5272</td>
<td>笙科</td>
</tr>
<tr>
<td>5274</td>
<td>信骅</td>
</tr>
<tr>
<td>5277</td>
<td>葳天</td>
</tr>
<tr>
<td>5281</td>
<td>大峡谷-KY</td>
</tr>
<tr>
<td>5283</td>
<td>禾联硕</td>
</tr>
<tr>
<td>5285</td>
<td>界霖</td>
</tr>
<tr>
<td>5289</td>
<td>宜鼎</td>
</tr>
<tr>
<td>5291</td>
<td>邑升</td>
</tr>
<tr>
<td>5294</td>
<td>捷音特</td>
</tr>
<tr>
<td>5297</td>
<td>广化</td>
</tr>
<tr>
<td>5299</td>
<td>杰力</td>
</tr>
<tr>
<td>5302</td>
<td>太欣</td>
</tr>
<tr>
<td>5304</td>
<td>鼎创达</td>
</tr>
<tr>
<td>5305</td>
<td>敦南</td>
</tr>
<tr>
<td>5309</td>
<td>系统电</td>
</tr>
<tr>
<td>5310</td>
<td>天刚</td>
</tr>
<tr>
<td>5314</td>
<td>世纪</td>
</tr>
<tr>
<td>5315</td>
<td>光联</td>
</tr>
<tr>
<td>5317</td>
<td>凯美</td>
</tr>
<tr>
<td>5321</td>
<td>友铨</td>
</tr>
<tr>
<td>5328</td>
<td>华容</td>
</tr>
<tr>
<td>5340</td>
<td>建荣</td>
</tr>
<tr>
<td>5344</td>
<td>立卫</td>
</tr>
<tr>
<td>5345</td>
<td>天扬</td>
</tr>
<tr>
<td>5347</td>
<td>世界</td>
</tr>
<tr>
<td>5348</td>
<td>系通</td>
</tr>
<tr>
<td>5349</td>
<td>先丰</td>
</tr>
<tr>
<td>5351</td>
<td>钰创</td>
</tr>
<tr>
<td>5353</td>
<td>台林</td>
</tr>
<tr>
<td>5355</td>
<td>佳总</td>
</tr>
<tr>
<td>5356</td>
<td>协益</td>
</tr>
<tr>
<td>5371</td>
<td>中光电</td>
</tr>
<tr>
<td>5381</td>
<td>合正</td>
</tr>
<tr>
<td>5383</td>
<td>金利</td>
</tr>
<tr>
<td>5386</td>
<td>青云</td>
</tr>
<tr>
<td>5388</td>
<td>中磊</td>
</tr>
<tr>
<td>5392</td>
<td>应华</td>
</tr>
<tr>
<td>5398</td>
<td>慕康生医</td>
</tr>
<tr>
<td>5403</td>
<td>中菲</td>
</tr>
<tr>
<td>5410</td>
<td>国众</td>
</tr>
<tr>
<td>5425</td>
<td>台半</td>
</tr>
<tr>
<td>5426</td>
<td>振发</td>
</tr>
<tr>
<td>5432</td>
<td>达威</td>
</tr>
<tr>
<td>5434</td>
<td>崇越</td>
</tr>
<tr>
<td>5438</td>
<td>东友</td>
</tr>
<tr>
<td>5439</td>
<td>高技</td>
</tr>
<tr>
<td>5443</td>
<td>均豪</td>
</tr>
<tr>
<td>5450</td>
<td>宝联通</td>
</tr>
<tr>
<td>5452</td>
<td>佶优</td>
</tr>
<tr>
<td>5457</td>
<td>宣德</td>
</tr>
<tr>
<td>5460</td>
<td>同协</td>
</tr>
<tr>
<td>5464</td>
<td>霖宏</td>
</tr>
<tr>
<td>5465</td>
<td>富骅</td>
</tr>
<tr>
<td>5468</td>
<td>凯钰</td>
</tr>
<tr>
<td>5469</td>
<td>瀚宇博</td>
</tr>
<tr>
<td>5471</td>
<td>松翰</td>
</tr>
<tr>
<td>5474</td>
<td>聪泰</td>
</tr>
<tr>
<td>5475</td>
<td>德宏</td>
</tr>
<tr>
<td>5480</td>
<td>统盟</td>
</tr>
<tr>
<td>5481</td>
<td>新华</td>
</tr>
<tr>
<td>5483</td>
<td>中美晶</td>
</tr>
<tr>
<td>5484</td>
<td>慧友</td>
</tr>
<tr>
<td>5487</td>
<td>通泰</td>
</tr>
<tr>
<td>5488</td>
<td>松普</td>
</tr>
<tr>
<td>5489</td>
<td>彩富</td>
</tr>
<tr>
<td>5490</td>
<td>同亨</td>
</tr>
<tr>
<td>5493</td>
<td>三联</td>
</tr>
<tr>
<td>5498</td>
<td>凯崴</td>
</tr>
<tr>
<td>5536</td>
<td>圣晖</td>
</tr>
<tr>
<td>6103</td>
<td>合邦</td>
</tr>
<tr>
<td>6104</td>
<td>创惟</td>
</tr>
<tr>
<td>6108</td>
<td>竞国</td>
</tr>
<tr>
<td>6109</td>
<td>亚元</td>
</tr>
<tr>
<td>6112</td>
<td>聚硕</td>
</tr>
<tr>
<td>6113</td>
<td>亚矽</td>
</tr>
<tr>
<td>6114</td>
<td>久威</td>
</tr>
<tr>
<td>6115</td>
<td>镒胜</td>
</tr>
<tr>
<td>6116</td>
<td>彩晶</td>
</tr>
<tr>
<td>6117</td>
<td>迎广</td>
</tr>
<tr>
<td>6118</td>
<td>建达</td>
</tr>
<tr>
<td>6120</td>
<td>达运</td>
</tr>
<tr>
<td>6121</td>
<td>新普</td>
</tr>
<tr>
<td>6123</td>
<td>上奇</td>
</tr>
<tr>
<td>6124</td>
<td>业强</td>
</tr>
<tr>
<td>6125</td>
<td>广运</td>
</tr>
<tr>
<td>6126</td>
<td>信音</td>
</tr>
<tr>
<td>6127</td>
<td>九豪</td>
</tr>
<tr>
<td>6128</td>
<td>上福</td>
</tr>
<tr>
<td>6129</td>
<td>普诚</td>
</tr>
<tr>
<td>6131</td>
<td>悠克</td>
</tr>
<tr>
<td>6133</td>
<td>金桥</td>
</tr>
<tr>
<td>6134</td>
<td>万旭</td>
</tr>
<tr>
<td>6136</td>
<td>富尔特</td>
</tr>
<tr>
<td>6138</td>
<td>茂达</td>
</tr>
<tr>
<td>6139</td>
<td>亚翔</td>
</tr>
<tr>
<td>6140</td>
<td>讯达</td>
</tr>
<tr>
<td>6141</td>
<td>柏承</td>
</tr>
<tr>
<td>6142</td>
<td>友劲</td>
</tr>
<tr>
<td>6143</td>
<td>振曜</td>
</tr>
<tr>
<td>6145</td>
<td>劲永</td>
</tr>
<tr>
<td>6146</td>
<td>耕兴</td>
</tr>
<tr>
<td>6147</td>
<td>颀邦</td>
</tr>
<tr>
<td>6148</td>
<td>骅宏资</td>
</tr>
<tr>
<td>6150</td>
<td>撼讯</td>
</tr>
<tr>
<td>6151</td>
<td>晋伦</td>
</tr>
<tr>
<td>6152</td>
<td>百一</td>
</tr>
<tr>
<td>6153</td>
<td>嘉联益</td>
</tr>
<tr>
<td>6154</td>
<td>顺发</td>
</tr>
<tr>
<td>6155</td>
<td>钧宝</td>
</tr>
<tr>
<td>6156</td>
<td>松上</td>
</tr>
<tr>
<td>6158</td>
<td>禾昌</td>
</tr>
<tr>
<td>6160</td>
<td>欣技</td>
</tr>
<tr>
<td>6161</td>
<td>捷波</td>
</tr>
<tr>
<td>6163</td>
<td>华电网</td>
</tr>
<tr>
<td>6164</td>
<td>华兴</td>
</tr>
<tr>
<td>6165</td>
<td>捷泰</td>
</tr>
<tr>
<td>6166</td>
<td>凌华</td>
</tr>
<tr>
<td>6167</td>
<td>久正</td>
</tr>
<tr>
<td>6168</td>
<td>宏齐</td>
</tr>
<tr>
<td>6170</td>
<td>统振</td>
</tr>
<tr>
<td>6172</td>
<td>互亿</td>
</tr>
<tr>
<td>6173</td>
<td>信昌电</td>
</tr>
<tr>
<td>6174</td>
<td>安棋</td>
</tr>
<tr>
<td>6175</td>
<td>立敦</td>
</tr>
<tr>
<td>6176</td>
<td>瑞仪</td>
</tr>
<tr>
<td>6182</td>
<td>合晶</td>
</tr>
<tr>
<td>6183</td>
<td>关贸</td>
</tr>
<tr>
<td>6185</td>
<td>帏翔</td>
</tr>
<tr>
<td>6187</td>
<td>万润</td>
</tr>
<tr>
<td>6188</td>
<td>广明</td>
</tr>
<tr>
<td>6189</td>
<td>丰艺</td>
</tr>
<tr>
<td>6190</td>
<td>万泰科</td>
</tr>
<tr>
<td>6191</td>
<td>精成科</td>
</tr>
<tr>
<td>6192</td>
<td>巨路</td>
</tr>
<tr>
<td>6194</td>
<td>育富</td>
</tr>
<tr>
<td>6196</td>
<td>帆宣</td>
</tr>
<tr>
<td>6197</td>
<td>佳必琪</td>
</tr>
<tr>
<td>6198</td>
<td>凌泰</td>
</tr>
<tr>
<td>6201</td>
<td>亚弘电</td>
</tr>
<tr>
<td>6202</td>
<td>盛群</td>
</tr>
<tr>
<td>6203</td>
<td>海韵电</td>
</tr>
<tr>
<td>6204</td>
<td>艾华</td>
</tr>
<tr>
<td>6205</td>
<td>诠欣</td>
</tr>
<tr>
<td>6206</td>
<td>飞捷</td>
</tr>
<tr>
<td>6207</td>
<td>雷科</td>
</tr>
<tr>
<td>6208</td>
<td>日扬</td>
</tr>
<tr>
<td>6209</td>
<td>今国光</td>
</tr>
<tr>
<td>6210</td>
<td>庆生</td>
</tr>
<tr>
<td>6213</td>
<td>联茂</td>
</tr>
<tr>
<td>6214</td>
<td>精诚</td>
</tr>
<tr>
<td>6215</td>
<td>和椿</td>
</tr>
<tr>
<td>6216</td>
<td>居易</td>
</tr>
<tr>
<td>6217</td>
<td>中探针</td>
</tr>
<tr>
<td>6218</td>
<td>豪勉</td>
</tr>
<tr>
<td>6220</td>
<td>岳丰</td>
</tr>
<tr>
<td>6221</td>
<td>晋泰</td>
</tr>
<tr>
<td>6222</td>
<td>上扬</td>
</tr>
<tr>
<td>6223</td>
<td>旺矽</td>
</tr>
<tr>
<td>6224</td>
<td>聚鼎</td>
</tr>
<tr>
<td>6225</td>
<td>天瀚</td>
</tr>
<tr>
<td>6226</td>
<td>光鼎</td>
</tr>
<tr>
<td>6227</td>
<td>茂纶</td>
</tr>
<tr>
<td>6228</td>
<td>全谱</td>
</tr>
<tr>
<td>6229</td>
<td>研通</td>
</tr>
<tr>
<td>6230</td>
<td>超众</td>
</tr>
<tr>
<td>6231</td>
<td>系微</td>
</tr>
<tr>
<td>6233</td>
<td>旺玖</td>
</tr>
<tr>
<td>6234</td>
<td>高侨</td>
</tr>
<tr>
<td>6235</td>
<td>华孚</td>
</tr>
<tr>
<td>6237</td>
<td>骅讯</td>
</tr>
<tr>
<td>6238</td>
<td>胜丽</td>
</tr>
<tr>
<td>6239</td>
<td>力成</td>
</tr>
<tr>
<td>6240</td>
<td>松岗</td>
</tr>
<tr>
<td>6241</td>
<td>易通展</td>
</tr>
<tr>
<td>6243</td>
<td>迅杰</td>
</tr>
<tr>
<td>6244</td>
<td>茂迪</td>
</tr>
<tr>
<td>6245</td>
<td>立端</td>
</tr>
<tr>
<td>6246</td>
<td>台龙</td>
</tr>
<tr>
<td>6247</td>
<td>淇誉电</td>
</tr>
<tr>
<td>6251</td>
<td>定颖</td>
</tr>
<tr>
<td>6257</td>
<td>矽格</td>
</tr>
<tr>
<td>6259</td>
<td>百徽</td>
</tr>
<tr>
<td>6261</td>
<td>久元</td>
</tr>
<tr>
<td>6263</td>
<td>普莱德</td>
</tr>
<tr>
<td>6265</td>
<td>方土昶</td>
</tr>
<tr>
<td>6266</td>
<td>泰咏</td>
</tr>
<tr>
<td>6269</td>
<td>台郡</td>
</tr>
<tr>
<td>6270</td>
<td>倍微</td>
</tr>
<tr>
<td>6271</td>
<td>同欣电</td>
</tr>
<tr>
<td>6272</td>
<td>骅升</td>
</tr>
<tr>
<td>6274</td>
<td>台燿</td>
</tr>
<tr>
<td>6275</td>
<td>元山</td>
</tr>
<tr>
<td>6276</td>
<td>安钛克</td>
</tr>
<tr>
<td>6277</td>
<td>宏正</td>
</tr>
<tr>
<td>6278</td>
<td>台表科</td>
</tr>
<tr>
<td>6279</td>
<td>胡连</td>
</tr>
<tr>
<td>6281</td>
<td>全国电</td>
</tr>
<tr>
<td>6282</td>
<td>康舒</td>
</tr>
<tr>
<td>6283</td>
<td>淳安</td>
</tr>
<tr>
<td>6284</td>
<td>佳邦</td>
</tr>
<tr>
<td>6285</td>
<td>启棋</td>
</tr>
<tr>
<td>6287</td>
<td>元隆</td>
</tr>
<tr>
<td>6288</td>
<td>联嘉</td>
</tr>
<tr>
<td>6289</td>
<td>华上</td>
</tr>
<tr>
<td>6290</td>
<td>良维</td>
</tr>
<tr>
<td>6291</td>
<td>沛亨</td>
</tr>
<tr>
<td>6292</td>
<td>迅德</td>
</tr>
<tr>
<td>6298</td>
<td>崴强</td>
</tr>
<tr>
<td>6403</td>
<td>群登</td>
</tr>
<tr>
<td>6404</td>
<td>通讯-KY</td>
</tr>
<tr>
<td>6405</td>
<td>悦城</td>
</tr>
<tr>
<td>6407</td>
<td>相互</td>
</tr>
<tr>
<td>6409</td>
<td>旭隼</td>
</tr>
<tr>
<td>6411</td>
<td>晶焱</td>
</tr>
<tr>
<td>6412</td>
<td>群电</td>
</tr>
<tr>
<td>6414</td>
<td>桦汉</td>
</tr>
<tr>
<td>6415</td>
<td>矽力-KY</td>
</tr>
<tr>
<td>6416</td>
<td>瑞祺电通</td>
</tr>
<tr>
<td>6417</td>
<td>韦侨</td>
</tr>
<tr>
<td>6418</td>
<td>咏升</td>
</tr>
<tr>
<td>6419</td>
<td>京晨科</td>
</tr>
<tr>
<td>6422</td>
<td>君耀-KY</td>
</tr>
<tr>
<td>6423</td>
<td>亿而得</td>
</tr>
<tr>
<td>6425</td>
<td>易发</td>
</tr>
<tr>
<td>6426</td>
<td>统新</td>
</tr>
<tr>
<td>6431</td>
<td>光丽-KY</td>
</tr>
<tr>
<td>6432</td>
<td>今展科</td>
</tr>
<tr>
<td>6434</td>
<td>达辉光电</td>
</tr>
<tr>
<td>6435</td>
<td>大中</td>
</tr>
<tr>
<td>6438</td>
<td>迅得</td>
</tr>
<tr>
<td>6441</td>
<td>广锭</td>
</tr>
<tr>
<td>6442</td>
<td>光圣</td>
</tr>
<tr>
<td>6443</td>
<td>元晶</td>
</tr>
<tr>
<td>6449</td>
<td>钰邦</td>
</tr>
<tr>
<td>6451</td>
<td>讯芯-KY</td>
</tr>
<tr>
<td>6456</td>
<td>GIS-KY</td>
</tr>
<tr>
<td>6457</td>
<td>紘康</td>
</tr>
<tr>
<td>6462</td>
<td>神盾</td>
</tr>
<tr>
<td>6465</td>
<td>威润</td>
</tr>
<tr>
<td>6470</td>
<td>宇智</td>
</tr>
<tr>
<td>6474</td>
<td>华豫宁</td>
</tr>
<tr>
<td>6475</td>
<td>岱炜</td>
</tr>
<tr>
<td>6477</td>
<td>安集</td>
</tr>
<tr>
<td>6485</td>
<td>点序</td>
</tr>
<tr>
<td>6486</td>
<td>互动</td>
</tr>
<tr>
<td>6488</td>
<td>环球晶</td>
</tr>
<tr>
<td>6489</td>
<td>德晶</td>
</tr>
<tr>
<td>6490</td>
<td>凌升科</td>
</tr>
<tr>
<td>6494</td>
<td>九齐</td>
</tr>
<tr>
<td>6498</td>
<td>久禾光</td>
</tr>
<tr>
<td>6510</td>
<td>精测</td>
</tr>
<tr>
<td>6511</td>
<td>绿晁</td>
</tr>
<tr>
<td>6512</td>
<td>启发电</td>
</tr>
<tr>
<td>6514</td>
<td>芮特-KY</td>
</tr>
<tr>
<td>6516</td>
<td>勤崴</td>
</tr>
<tr>
<td>6525</td>
<td>捷敏-KY</td>
</tr>
<tr>
<td>6529</td>
<td>研鼎</td>
</tr>
<tr>
<td>6530</td>
<td>创威</td>
</tr>
<tr>
<td>6531</td>
<td>爱普</td>
</tr>
<tr>
<td>6532</td>
<td>瑞耘</td>
</tr>
<tr>
<td>6533</td>
<td>晶心科</td>
</tr>
<tr>
<td>6536</td>
<td>硕丰</td>
</tr>
<tr>
<td>6538</td>
<td>仓和</td>
</tr>
<tr>
<td>6545</td>
<td>擎力</td>
</tr>
<tr>
<td>6548</td>
<td>长华科</td>
</tr>
<tr>
<td>6552</td>
<td>易华电</td>
</tr>
<tr>
<td>6555</td>
<td>荣炭</td>
</tr>
<tr>
<td>6556</td>
<td>胜品</td>
</tr>
<tr>
<td>6558</td>
<td>兴能高</td>
</tr>
<tr>
<td>6559</td>
<td>研晶</td>
</tr>
<tr>
<td>6560</td>
<td>欣普罗</td>
</tr>
<tr>
<td>6561</td>
<td>是方</td>
</tr>
<tr>
<td>6565</td>
<td>物联</td>
</tr>
<tr>
<td>6568</td>
<td>宏观</td>
</tr>
<tr>
<td>6570</td>
<td>维田</td>
</tr>
<tr>
<td>6573</td>
<td>虹扬-KY</td>
</tr>
<tr>
<td>6577</td>
<td>劲丰</td>
</tr>
<tr>
<td>6579</td>
<td>研扬</td>
</tr>
<tr>
<td>6584</td>
<td>南俊国际</td>
</tr>
<tr>
<td>6588</td>
<td>东典光电</td>
</tr>
<tr>
<td>6590</td>
<td>普鸿</td>
</tr>
<tr>
<td>6591</td>
<td>动力-KY</td>
</tr>
<tr>
<td>6593</td>
<td>台湾铭板</td>
</tr>
<tr>
<td>6594</td>
<td>展汇科</td>
</tr>
<tr>
<td>6597</td>
<td>立诚</td>
</tr>
<tr>
<td>6599</td>
<td>普达</td>
</tr>
<tr>
<td>6613</td>
<td>朋亿</td>
</tr>
<tr>
<td>6638</td>
<td>沅圣</td>
</tr>
<tr>
<td>6640</td>
<td>均华</td>
</tr>
<tr>
<td>6642</td>
<td>富致</td>
</tr>
<tr>
<td>6643</td>
<td>M31</td>
</tr>
<tr>
<td>6648</td>
<td>斯其大</td>
</tr>
<tr>
<td>6651</td>
<td>全宇昕</td>
</tr>
<tr>
<td>6653</td>
<td>嘉贸</td>
</tr>
<tr>
<td>6654</td>
<td>天正国际</td>
</tr>
<tr>
<td>6664</td>
<td>群翊</td>
</tr>
<tr>
<td>6667</td>
<td>信紘</td>
</tr>
<tr>
<td>6668</td>
<td>中扬光</td>
</tr>
<tr>
<td>6669</td>
<td>纬颖</td>
</tr>
<tr>
<td>6672</td>
<td>腾辉电子-KY</td>
</tr>
<tr>
<td>6673</td>
<td>和诠</td>
</tr>
<tr>
<td>6674</td>
<td>鋐寶科技</td>
</tr>
<tr>
<td>6679</td>
<td>钰太科技</td>
</tr>
<tr>
<td>6680</td>
<td>鑫创电子</td>
</tr>
<tr>
<td>6681</td>
<td>宏星技术</td>
</tr>
<tr>
<td>6682</td>
<td>硕钻材料</td>
</tr>
<tr>
<td>6683</td>
<td>雍智科技</td>
</tr>
<tr>
<td>6684</td>
<td>安格</td>
</tr>
<tr>
<td>6689</td>
<td>伊云谷</td>
</tr>
<tr>
<td>6690</td>
<td>安棋资讯</td>
</tr>
<tr>
<td>6691</td>
<td>洋基工程</td>
</tr>
<tr>
<td>7402</td>
<td>邑錡</td>
</tr>
<tr>
<td>7419</td>
<td>达胜</td>
</tr>
<tr>
<td>7423</td>
<td>奇多比</td>
</tr>
<tr>
<td>7428</td>
<td>戴维</td>
</tr>
<tr>
<td>7449</td>
<td>元皓</td>
</tr>
<tr>
<td>7455</td>
<td>桦纬</td>
</tr>
<tr>
<td>7492</td>
<td>一等一</td>
</tr>
<tr>
<td>7493</td>
<td>耀达</td>
</tr>
<tr>
<td>7495</td>
<td>凌云</td>
</tr>
<tr>
<td>7497</td>
<td>卡讯</td>
</tr>
<tr>
<td>7501</td>
<td>瀚铭</td>
</tr>
<tr>
<td>7503</td>
<td>自由系统</td>
</tr>
<tr>
<td>7504</td>
<td>时尚美人</td>
</tr>
<tr>
<td>7505</td>
<td>立达科</td>
</tr>
<tr>
<td>7506</td>
<td>动心医电</td>
</tr>
<tr>
<td>7510</td>
<td>棋苓</td>
</tr>
<tr>
<td>7511</td>
<td>宏景智权科技</td>
</tr>
<tr>
<td>7514</td>
<td>顶程国际</td>
</tr>
<tr>
<td>7517</td>
<td>都以特</td>
</tr>
<tr>
<td>7522</td>
<td>亚太开</td>
</tr>
<tr>
<td>7523</td>
<td>亚科国际</td>
</tr>
<tr>
<td>7531</td>
<td>昱家科技</td>
</tr>
<tr>
<td>7533</td>
<td>鑫豪</td>
</tr>
<tr>
<td>7541</td>
<td>彬腾</td>
</tr>
<tr>
<td>7545</td>
<td>台邦企业</td>
</tr>
<tr>
<td>7556</td>
<td>意德士</td>
</tr>
<tr>
<td>7557</td>
<td>牧阳能控</td>
</tr>
<tr>
<td>8011</td>
<td>台通</td>
</tr>
<tr>
<td>8016</td>
<td>矽创</td>
</tr>
<tr>
<td>8021</td>
<td>尖点</td>
</tr>
<tr>
<td>8024</td>
<td>佑华</td>
</tr>
<tr>
<td>8028</td>
<td>升阳半导体</td>
</tr>
<tr>
<td>8032</td>
<td>光菱</td>
</tr>
<tr>
<td>8034</td>
<td>荣群</td>
</tr>
<tr>
<td>8038</td>
<td>长园科</td>
</tr>
<tr>
<td>8039</td>
<td>台虹</td>
</tr>
<tr>
<td>8040</td>
<td>九暘</td>
</tr>
<tr>
<td>8042</td>
<td>金山电</td>
</tr>
<tr>
<td>8043</td>
<td>蜜望实</td>
</tr>
<tr>
<td>8045</td>
<td>达运光电</td>
</tr>
<tr>
<td>8046</td>
<td>南电</td>
</tr>
<tr>
<td>8047</td>
<td>星云</td>
</tr>
<tr>
<td>8048</td>
<td>德胜</td>
</tr>
<tr>
<td>8049</td>
<td>晶采</td>
</tr>
<tr>
<td>8050</td>
<td>广积</td>
</tr>
<tr>
<td>8054</td>
<td>安国</td>
</tr>
<tr>
<td>8059</td>
<td>凯硕</td>
</tr>
<tr>
<td>8064</td>
<td>东捷</td>
</tr>
<tr>
<td>8067</td>
<td>志旭</td>
</tr>
<tr>
<td>8068</td>
<td>全达</td>
</tr>
<tr>
<td>8069</td>
<td>元太</td>
</tr>
<tr>
<td>8070</td>
<td>长华</td>
</tr>
<tr>
<td>8071</td>
<td>能率网通</td>
</tr>
<tr>
<td>8072</td>
<td>升泰</td>
</tr>
<tr>
<td>8074</td>
<td>钜橡</td>
</tr>
<tr>
<td>8076</td>
<td>伍丰</td>
</tr>
<tr>
<td>8080</td>
<td>奥斯特</td>
</tr>
<tr>
<td>8081</td>
<td>致新</td>
</tr>
<tr>
<td>8084</td>
<td>巨虹</td>
</tr>
<tr>
<td>8085</td>
<td>福华</td>
</tr>
<tr>
<td>8086</td>
<td>宏捷科</td>
</tr>
<tr>
<td>8087</td>
<td>华镁鑫</td>
</tr>
<tr>
<td>8088</td>
<td>品安</td>
</tr>
<tr>
<td>8089</td>
<td>康全电讯</td>
</tr>
<tr>
<td>8091</td>
<td>翔名</td>
</tr>
<tr>
<td>8092</td>
<td>建萋</td>
</tr>
<tr>
<td>8093</td>
<td>保锐</td>
</tr>
<tr>
<td>8096</td>
<td>擎亚</td>
</tr>
<tr>
<td>8097</td>
<td>常珵</td>
</tr>
<tr>
<td>8099</td>
<td>大世科</td>
</tr>
<tr>
<td>8101</td>
<td>华冠</td>
</tr>
<tr>
<td>8103</td>
<td>瀚荃</td>
</tr>
<tr>
<td>8104</td>
<td>铼宝</td>
</tr>
<tr>
<td>8105</td>
<td>凌巨</td>
</tr>
<tr>
<td>8109</td>
<td>博大</td>
</tr>
<tr>
<td>8110</td>
<td>华东</td>
</tr>
<tr>
<td>8111</td>
<td>立棋</td>
</tr>
<tr>
<td>8112</td>
<td>至上</td>
</tr>
<tr>
<td>8114</td>
<td>振桦电</td>
</tr>
<tr>
<td>8115</td>
<td>帝闻</td>
</tr>
<tr>
<td>8119</td>
<td>公信</td>
</tr>
<tr>
<td>8121</td>
<td>越峰</td>
</tr>
<tr>
<td>8122</td>
<td>神通</td>
</tr>
<tr>
<td>8127</td>
<td>利泛</td>
</tr>
<tr>
<td>8131</td>
<td>福懋科</td>
</tr>
<tr>
<td>8147</td>
<td>正凌</td>
</tr>
<tr>
<td>8150</td>
<td>南茂</td>
</tr>
<tr>
<td>8155</td>
<td>博智</td>
</tr>
<tr>
<td>8163</td>
<td>达方</td>
</tr>
<tr>
<td>8171</td>
<td>天宇</td>
</tr>
<tr>
<td>8176</td>
<td>智捷</td>
</tr>
<tr>
<td>8179</td>
<td>旭德</td>
</tr>
<tr>
<td>8182</td>
<td>加高</td>
</tr>
<tr>
<td>8183</td>
<td>精星</td>
</tr>
<tr>
<td>8201</td>
<td>无敌</td>
</tr>
<tr>
<td>8210</td>
<td>勤诚</td>
</tr>
<tr>
<td>8213</td>
<td>志超</td>
</tr>
<tr>
<td>8215</td>
<td>明基材</td>
</tr>
<tr>
<td>8234</td>
<td>新汉</td>
</tr>
<tr>
<td>8240</td>
<td>华宏</td>
</tr>
<tr>
<td>8249</td>
<td>菱光</td>
</tr>
<tr>
<td>8261</td>
<td>富鼎</td>
</tr>
<tr>
<td>8271</td>
<td>宇瞻</td>
</tr>
<tr>
<td>8277</td>
<td>商丞</td>
</tr>
<tr>
<td>8281</td>
<td>欧普罗</td>
</tr>
<tr>
<td>8284</td>
<td>三竹</td>
</tr>
<tr>
<td>8287</td>
<td>英格尔</td>
</tr>
<tr>
<td>8289</td>
<td>泰艺</td>
</tr>
<tr>
<td>8291</td>
<td>尚茂</td>
</tr>
<tr>
<td>8298</td>
<td>威睿</td>
</tr>
<tr>
<td>8299</td>
<td>群联</td>
</tr>
<tr>
<td>8358</td>
<td>金居</td>
</tr>
<tr>
<td>8383</td>
<td>千附</td>
</tr>
<tr>
<td>8410</td>
<td>森田</td>
</tr>
<tr>
<td>8416</td>
<td>实威</td>
</tr>
<tr>
<td>8431</td>
<td>汇钻科</td>
</tr>
<tr>
<td>8455</td>
<td>大拓-KY</td>
</tr>
<tr>
<td>9912</td>
<td>伟联</td>
</tr>
</tbody></table>