# 台湾电子产业月营收

**文档ID**: 88
**原始链接**: https://tushare.pro/document/2?doc_id=88

---

## 台湾电子产业月营收

接口：tmt_twincome描述：获取台湾TMT电子产业领域各类产品月度营收数据。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>N</td>
<td>报告期</td>
</tr>
<tr>
<td>item</td>
<td>str</td>
<td>Y</td>
<td>产品代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>报告期开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>报告期结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>date</td>
<td>str</td>
<td>报告期</td>
</tr>
<tr>
<td>item</td>
<td>str</td>
<td>产品代码</td>
</tr>
<tr>
<td>op_income</td>
<td>str</td>
<td>月度收入</td>
</tr>
</tbody></table>
由于服务器压力，单次最多获取30个月数据，后续再逐步全部开放，目前可根据日期范围多次获取数据。

调用代码示例

```

pro = ts.pro_api()

#获取PCB月度营收
df = pro.tmt_twincome(item='8')

#获取PCB月度营收（20120101-20181010）
df = pro.tmt_twincome(item='8', start_date='20120101', end_date='20181010')

```

数据样例

```
        date item   op_income
0   20180731    8  35144753.0
1   20180629    8  30940090.0
2   20180531    8  30982240.0
3   20180430    8  30431976.0
4   20180331    8  29491108.0
5   20180227    8  24700223.0
6   20180131    8  32962014.0
7   20171229    8  32850818.0
8   20171130    8  34436396.0
9   20171031    8  33331667.0
10  20170930    8  34220623.0
11  20170831    8  32621006.0
12  20170731    8  30284562.0
13  20170630    8  29003264.0
14  20170531    8  28382449.0
15  20170428    8  27140270.0
16  20170331    8  29015642.0
17  20170224    8  26508381.0
18  20170124    8  26927481.0
19  20161230    8  29784865.0
20  20161130    8  31234845.0
21  20161031    8  30305625.0
22  20160930    8  30523650.0
23  20160831    8  30600923.0
24  20160729    8  29066800.0
25  20160630    8  27350576.0
26  20160531    8  27752376.0
27  20160429    8  26664433.0
28  20160331    8  27428746.0
29  20160226    8  22218229.0
```

产品代码列表

<table>
<thead>
<tr>
<th>TS代码</th>
<th>类别名称</th>
</tr>
</thead>
<tbody><tr>
<td>1</td>
<td>PC</td>
</tr>
<tr>
<td>2</td>
<td>NB</td>
</tr>
<tr>
<td>3</td>
<td>主机板</td>
</tr>
<tr>
<td>4</td>
<td>印刷电路板</td>
</tr>
<tr>
<td>5</td>
<td>IC载板</td>
</tr>
<tr>
<td>6</td>
<td>PCB组装</td>
</tr>
<tr>
<td>7</td>
<td>软板</td>
</tr>
<tr>
<td>8</td>
<td>PCB</td>
</tr>
<tr>
<td>9</td>
<td>PCB原料</td>
</tr>
<tr>
<td>10</td>
<td>铜箔基板</td>
</tr>
<tr>
<td>11</td>
<td>玻纤纱布</td>
</tr>
<tr>
<td>12</td>
<td>FCCL</td>
</tr>
<tr>
<td>13</td>
<td>显示卡</td>
</tr>
<tr>
<td>14</td>
<td>绘图卡</td>
</tr>
<tr>
<td>15</td>
<td>电视卡</td>
</tr>
<tr>
<td>16</td>
<td>泛工业电脑</td>
</tr>
<tr>
<td>17</td>
<td>POS</td>
</tr>
<tr>
<td>18</td>
<td>工业电脑</td>
</tr>
<tr>
<td>19</td>
<td>光电IO</td>
</tr>
<tr>
<td>20</td>
<td>监视器</td>
</tr>
<tr>
<td>21</td>
<td>扫描器</td>
</tr>
<tr>
<td>22</td>
<td>PC周边</td>
</tr>
<tr>
<td>23</td>
<td>储存媒体</td>
</tr>
<tr>
<td>24</td>
<td>光碟</td>
</tr>
<tr>
<td>25</td>
<td>硬盘磁盘</td>
</tr>
<tr>
<td>26</td>
<td>发光二极体</td>
</tr>
<tr>
<td>27</td>
<td>太阳能</td>
</tr>
<tr>
<td>28</td>
<td>LCD面板</td>
</tr>
<tr>
<td>29</td>
<td>背光模组</td>
</tr>
<tr>
<td>30</td>
<td>LCD原料</td>
</tr>
<tr>
<td>31</td>
<td>LCD其它</td>
</tr>
<tr>
<td>32</td>
<td>触控面板</td>
</tr>
<tr>
<td>33</td>
<td>监控系统</td>
</tr>
<tr>
<td>34</td>
<td>其它光电</td>
</tr>
<tr>
<td>35</td>
<td>电子零组件</td>
</tr>
<tr>
<td>36</td>
<td>二极体整流</td>
</tr>
<tr>
<td>37</td>
<td>连接器</td>
</tr>
<tr>
<td>38</td>
<td>电源供应器</td>
</tr>
<tr>
<td>39</td>
<td>机壳</td>
</tr>
<tr>
<td>40</td>
<td>被动元件</td>
</tr>
<tr>
<td>41</td>
<td>石英元件</td>
</tr>
<tr>
<td>42</td>
<td>3C二次电源</td>
</tr>
<tr>
<td>43</td>
<td>网路设备</td>
</tr>
<tr>
<td>44</td>
<td>数据机</td>
</tr>
<tr>
<td>45</td>
<td>网路卡</td>
</tr>
<tr>
<td>46</td>
<td>半导体</td>
</tr>
<tr>
<td>47</td>
<td>晶圆制造</td>
</tr>
<tr>
<td>48</td>
<td>IC封测</td>
</tr>
<tr>
<td>49</td>
<td>特用IC</td>
</tr>
<tr>
<td>50</td>
<td>记忆体模组</td>
</tr>
<tr>
<td>51</td>
<td>晶圆材料</td>
</tr>
<tr>
<td>52</td>
<td>IC设计</td>
</tr>
<tr>
<td>53</td>
<td>IC光罩</td>
</tr>
<tr>
<td>54</td>
<td>电子设备</td>
</tr>
<tr>
<td>55</td>
<td>手机</td>
</tr>
<tr>
<td>56</td>
<td>通讯设备</td>
</tr>
<tr>
<td>57</td>
<td>电信业</td>
</tr>
<tr>
<td>58</td>
<td>网路服务</td>
</tr>
<tr>
<td>59</td>
<td>卫星通讯</td>
</tr>
<tr>
<td>60</td>
<td>光纤通讯</td>
</tr>
<tr>
<td>61</td>
<td>3C通路</td>
</tr>
<tr>
<td>62</td>
<td>消费性电子</td>
</tr>
<tr>
<td>63</td>
<td>照相机</td>
</tr>
<tr>
<td>64</td>
<td>软件服务</td>
</tr>
<tr>
<td>65</td>
<td>系统整合</td>
</tr>
</tbody></table>