# 可转债转股价变动

**文档ID**: 246
**原始链接**: https://tushare.pro/document/2?doc_id=246

---

## 可转债转股价变动

接口：cb_price_chg描述：获取可转债转股价变动限量：单次最大2000，总量不限制权限：本接口需单独开权限（跟积分没关系），具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>转债代码，支持多值输入</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>转债代码</td>
</tr>
<tr>
<td>bond_short_name</td>
<td>str</td>
<td>Y</td>
<td>转债简称</td>
</tr>
<tr>
<td>publish_date</td>
<td>str</td>
<td>Y</td>
<td>公告日期</td>
</tr>
<tr>
<td>change_date</td>
<td>str</td>
<td>Y</td>
<td>变动日期</td>
</tr>
<tr>
<td>convert_price_initial</td>
<td>float</td>
<td>Y</td>
<td>初始转股价格</td>
</tr>
<tr>
<td>convertprice_bef</td>
<td>float</td>
<td>Y</td>
<td>修正前转股价格</td>
</tr>
<tr>
<td>convertprice_aft</td>
<td>float</td>
<td>Y</td>
<td>修正后转股价格</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api(your token)
#获取可转债转股价变动
df = pro.cb_price_chg(ts_code="113556.SH,128114.SZ,128110.SZ",fields="ts_code,bond_short_name,change_date,convert_price_initial,convertprice_bef,convertprice_aft")

```

数据示例

```
 ts_code bond_short_name change_date convert_price_initial convertprice_bef convertprice_aft
0  113556.SH    至纯转债    20191220           29.4700             None             None
1  113556.SH    至纯转债    20200629           29.4700          29.4700          29.3800
2  128110.SZ    永兴转债    20200609           17.1600             None             None
3  128114.SZ    正邦转债    20200617           16.0900             None             None

```
