# 可转债票面利率

**文档ID**: 305
**原始链接**: https://tushare.pro/document/2?doc_id=305

---

## 可转债票面利率

接口：cb_rate描述：获取可转债票面利率限量：单次最大2000，总量不限制权限：用户需要至少5000积分才可以调取，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>转债代码，支持多值输入</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>转债代码</td>
</tr>
<tr>
<td>rate_freq</td>
<td>int</td>
<td>N</td>
<td>付息频率(次/年)</td>
</tr>
<tr>
<td>rate_start_date</td>
<td>str</td>
<td>N</td>
<td>付息开始日期</td>
</tr>
<tr>
<td>rate_end_date</td>
<td>str</td>
<td>N</td>
<td>付息结束日期</td>
</tr>
<tr>
<td>coupon_rate</td>
<td>float</td>
<td>N</td>
<td>票面利率(%)</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api(your token)
#获取可转债基础信息列表
df = pro.cb_rate(ts_code='123046.SZ,127064.SZ',fields="ts_code,rate_freq,rate_start_date,rate_end_date,coupon_rate")

```

数据示例

```
            ts_code  rate_freq rate_start_date rate_end_date coupon_rate
0   123046.SZ          1        20200319      20210318    0.500000
1   123046.SZ          1        20210319      20220318    0.700000
2   123046.SZ          1        20220319      20230318    1.000000
3   123046.SZ          1        20230319      20240318    1.500000
4   123046.SZ          1        20240319      20250318    2.500000
5   123046.SZ          1        20250319      20260318    3.000000
6   127064.SZ          1        20220519      20230518    0.200000
7   127064.SZ          1        20230519      20240518    0.400000
8   127064.SZ          1        20240519      20250518    0.600000
9   127064.SZ          1        20250519      20260518    1.500000
10  127064.SZ          1        20260519      20270518    1.800000
11  127064.SZ          1        20270519      20280518    2.000000

```
