# 可转债技术面因子(专业版）

**文档ID**: 392
**原始链接**: https://tushare.pro/document/2?doc_id=392

---

## 可转债技术因子(专业版)

接口：cb_factor_pro描述：获取可转债每日技术面因子数据，用于跟踪可转债当前走势情况，数据由Tushare社区自产，覆盖全历史；输出参数_bfq表示不复权，_qfq表示前复权 _hfq表示后复权，描述中说明了因子的默认传参，如需要特殊参数或者更多因子可以联系管理员评估限量：单次调取最多返回10000条数据，可以通过日期参数循环积分：5000积分每分钟可以请求30次，8000积分以上每分钟500次，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>可转债代码</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>转债代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>Y</td>
<td>交易日期</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>Y</td>
<td>昨收价</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>Y</td>
<td>涨跌额</td>
</tr>
<tr>
<td>pct_change</td>
<td>float</td>
<td>Y</td>
<td>涨跌幅 （未复权，如果是复权请用 通用行情接口 ）</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>Y</td>
<td>成交量 （手）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额(万元)</td>
</tr>
<tr>
<td>asi_bfq</td>
<td>float</td>
<td>Y</td>
<td>振动升降指标-OPEN, CLOSE, HIGH, LOW, M1=26, M2=10</td>
</tr>
<tr>
<td>asit_bfq</td>
<td>float</td>
<td>Y</td>
<td>振动升降指标-OPEN, CLOSE, HIGH, LOW, M1=26, M2=10</td>
</tr>
<tr>
<td>atr_bfq</td>
<td>float</td>
<td>Y</td>
<td>真实波动N日平均值-CLOSE, HIGH, LOW, N=20</td>
</tr>
<tr>
<td>bbi_bfq</td>
<td>float</td>
<td>Y</td>
<td>BBI多空指标-CLOSE, M1=3, M2=6, M3=12, M4=20</td>
</tr>
<tr>
<td>bias1_bfq</td>
<td>float</td>
<td>Y</td>
<td>BIAS乖离率-CLOSE, L1=6, L2=12, L3=24</td>
</tr>
<tr>
<td>bias2_bfq</td>
<td>float</td>
<td>Y</td>
<td>BIAS乖离率-CLOSE, L1=6, L2=12, L3=24</td>
</tr>
<tr>
<td>bias3_bfq</td>
<td>float</td>
<td>Y</td>
<td>BIAS乖离率-CLOSE, L1=6, L2=12, L3=24</td>
</tr>
<tr>
<td>boll_lower_bfq</td>
<td>float</td>
<td>Y</td>
<td>BOLL指标，布林带-CLOSE, N=20, P=2</td>
</tr>
<tr>
<td>boll_mid_bfq</td>
<td>float</td>
<td>Y</td>
<td>BOLL指标，布林带-CLOSE, N=20, P=2</td>
</tr>
<tr>
<td>boll_upper_bfq</td>
<td>float</td>
<td>Y</td>
<td>BOLL指标，布林带-CLOSE, N=20, P=2</td>
</tr>
<tr>
<td>brar_ar_bfq</td>
<td>float</td>
<td>Y</td>
<td>BRAR情绪指标-OPEN, CLOSE, HIGH, LOW, M1=26</td>
</tr>
<tr>
<td>brar_br_bfq</td>
<td>float</td>
<td>Y</td>
<td>BRAR情绪指标-OPEN, CLOSE, HIGH, LOW, M1=26</td>
</tr>
<tr>
<td>cci_bfq</td>
<td>float</td>
<td>Y</td>
<td>顺势指标又叫CCI指标-CLOSE, HIGH, LOW, N=14</td>
</tr>
<tr>
<td>cr_bfq</td>
<td>float</td>
<td>Y</td>
<td>CR价格动量指标-CLOSE, HIGH, LOW, N=20</td>
</tr>
<tr>
<td>dfma_dif_bfq</td>
<td>float</td>
<td>Y</td>
<td>平行线差指标-CLOSE, N1=10, N2=50, M=10</td>
</tr>
<tr>
<td>dfma_difma_bfq</td>
<td>float</td>
<td>Y</td>
<td>平行线差指标-CLOSE, N1=10, N2=50, M=10</td>
</tr>
<tr>
<td>dmi_adx_bfq</td>
<td>float</td>
<td>Y</td>
<td>动向指标-CLOSE, HIGH, LOW, M1=14, M2=6</td>
</tr>
<tr>
<td>dmi_adxr_bfq</td>
<td>float</td>
<td>Y</td>
<td>动向指标-CLOSE, HIGH, LOW, M1=14, M2=6</td>
</tr>
<tr>
<td>dmi_mdi_bfq</td>
<td>float</td>
<td>Y</td>
<td>动向指标-CLOSE, HIGH, LOW, M1=14, M2=6</td>
</tr>
<tr>
<td>dmi_pdi_bfq</td>
<td>float</td>
<td>Y</td>
<td>动向指标-CLOSE, HIGH, LOW, M1=14, M2=6</td>
</tr>
<tr>
<td>downdays</td>
<td>float</td>
<td>Y</td>
<td>连跌天数</td>
</tr>
<tr>
<td>updays</td>
<td>float</td>
<td>Y</td>
<td>连涨天数</td>
</tr>
<tr>
<td>dpo_bfq</td>
<td>float</td>
<td>Y</td>
<td>区间震荡线-CLOSE, M1=20, M2=10, M3=6</td>
</tr>
<tr>
<td>madpo_bfq</td>
<td>float</td>
<td>Y</td>
<td>区间震荡线-CLOSE, M1=20, M2=10, M3=6</td>
</tr>
<tr>
<td>ema_bfq_10</td>
<td>float</td>
<td>Y</td>
<td>指数移动平均-N=10</td>
</tr>
<tr>
<td>ema_bfq_20</td>
<td>float</td>
<td>Y</td>
<td>指数移动平均-N=20</td>
</tr>
<tr>
<td>ema_bfq_250</td>
<td>float</td>
<td>Y</td>
<td>指数移动平均-N=250</td>
</tr>
<tr>
<td>ema_bfq_30</td>
<td>float</td>
<td>Y</td>
<td>指数移动平均-N=30</td>
</tr>
<tr>
<td>ema_bfq_5</td>
<td>float</td>
<td>Y</td>
<td>指数移动平均-N=5</td>
</tr>
<tr>
<td>ema_bfq_60</td>
<td>float</td>
<td>Y</td>
<td>指数移动平均-N=60</td>
</tr>
<tr>
<td>ema_bfq_90</td>
<td>float</td>
<td>Y</td>
<td>指数移动平均-N=90</td>
</tr>
<tr>
<td>emv_bfq</td>
<td>float</td>
<td>Y</td>
<td>简易波动指标-HIGH, LOW, VOL, N=14, M=9</td>
</tr>
<tr>
<td>maemv_bfq</td>
<td>float</td>
<td>Y</td>
<td>简易波动指标-HIGH, LOW, VOL, N=14, M=9</td>
</tr>
<tr>
<td>expma_12_bfq</td>
<td>float</td>
<td>Y</td>
<td>EMA指数平均数指标-CLOSE, N1=12, N2=50</td>
</tr>
<tr>
<td>expma_50_bfq</td>
<td>float</td>
<td>Y</td>
<td>EMA指数平均数指标-CLOSE, N1=12, N2=50</td>
</tr>
<tr>
<td>kdj_bfq</td>
<td>float</td>
<td>Y</td>
<td>KDJ指标-CLOSE, HIGH, LOW, N=9, M1=3, M2=3</td>
</tr>
<tr>
<td>kdj_d_bfq</td>
<td>float</td>
<td>Y</td>
<td>KDJ指标-CLOSE, HIGH, LOW, N=9, M1=3, M2=3</td>
</tr>
<tr>
<td>kdj_k_bfq</td>
<td>float</td>
<td>Y</td>
<td>KDJ指标-CLOSE, HIGH, LOW, N=9, M1=3, M2=3</td>
</tr>
<tr>
<td>ktn_down_bfq</td>
<td>float</td>
<td>Y</td>
<td>肯特纳交易通道, N选20日，ATR选10日-CLOSE, HIGH, LOW, N=20, M=10</td>
</tr>
<tr>
<td>ktn_mid_bfq</td>
<td>float</td>
<td>Y</td>
<td>肯特纳交易通道, N选20日，ATR选10日-CLOSE, HIGH, LOW, N=20, M=10</td>
</tr>
<tr>
<td>ktn_upper_bfq</td>
<td>float</td>
<td>Y</td>
<td>肯特纳交易通道, N选20日，ATR选10日-CLOSE, HIGH, LOW, N=20, M=10</td>
</tr>
<tr>
<td>lowdays</td>
<td>float</td>
<td>Y</td>
<td>LOWRANGE(LOW)表示当前最低价是近多少周期内最低价的最小值</td>
</tr>
<tr>
<td>topdays</td>
<td>float</td>
<td>Y</td>
<td>TOPRANGE(HIGH)表示当前最高价是近多少周期内最高价的最大值</td>
</tr>
<tr>
<td>ma_bfq_10</td>
<td>float</td>
<td>Y</td>
<td>简单移动平均-N=10</td>
</tr>
<tr>
<td>ma_bfq_20</td>
<td>float</td>
<td>Y</td>
<td>简单移动平均-N=20</td>
</tr>
<tr>
<td>ma_bfq_250</td>
<td>float</td>
<td>Y</td>
<td>简单移动平均-N=250</td>
</tr>
<tr>
<td>ma_bfq_30</td>
<td>float</td>
<td>Y</td>
<td>简单移动平均-N=30</td>
</tr>
<tr>
<td>ma_bfq_5</td>
<td>float</td>
<td>Y</td>
<td>简单移动平均-N=5</td>
</tr>
<tr>
<td>ma_bfq_60</td>
<td>float</td>
<td>Y</td>
<td>简单移动平均-N=60</td>
</tr>
<tr>
<td>ma_bfq_90</td>
<td>float</td>
<td>Y</td>
<td>简单移动平均-N=90</td>
</tr>
<tr>
<td>macd_bfq</td>
<td>float</td>
<td>Y</td>
<td>MACD指标-CLOSE, SHORT=12, LONG=26, M=9</td>
</tr>
<tr>
<td>macd_dea_bfq</td>
<td>float</td>
<td>Y</td>
<td>MACD指标-CLOSE, SHORT=12, LONG=26, M=9</td>
</tr>
<tr>
<td>macd_dif_bfq</td>
<td>float</td>
<td>Y</td>
<td>MACD指标-CLOSE, SHORT=12, LONG=26, M=9</td>
</tr>
<tr>
<td>mass_bfq</td>
<td>float</td>
<td>Y</td>
<td>梅斯线-HIGH, LOW, N1=9, N2=25, M=6</td>
</tr>
<tr>
<td>ma_mass_bfq</td>
<td>float</td>
<td>Y</td>
<td>梅斯线-HIGH, LOW, N1=9, N2=25, M=6</td>
</tr>
<tr>
<td>mfi_bfq</td>
<td>float</td>
<td>Y</td>
<td>MFI指标是成交量的RSI指标-CLOSE, HIGH, LOW, VOL, N=14</td>
</tr>
<tr>
<td>mtm_bfq</td>
<td>float</td>
<td>Y</td>
<td>动量指标-CLOSE, N=12, M=6</td>
</tr>
<tr>
<td>mtmma_bfq</td>
<td>float</td>
<td>Y</td>
<td>动量指标-CLOSE, N=12, M=6</td>
</tr>
<tr>
<td>obv_bfq</td>
<td>float</td>
<td>Y</td>
<td>能量潮指标-CLOSE, VOL</td>
</tr>
<tr>
<td>psy_bfq</td>
<td>float</td>
<td>Y</td>
<td>投资者对股市涨跌产生心理波动的情绪指标-CLOSE, N=12, M=6</td>
</tr>
<tr>
<td>psyma_bfq</td>
<td>float</td>
<td>Y</td>
<td>投资者对股市涨跌产生心理波动的情绪指标-CLOSE, N=12, M=6</td>
</tr>
<tr>
<td>roc_bfq</td>
<td>float</td>
<td>Y</td>
<td>变动率指标-CLOSE, N=12, M=6</td>
</tr>
<tr>
<td>maroc_bfq</td>
<td>float</td>
<td>Y</td>
<td>变动率指标-CLOSE, N=12, M=6</td>
</tr>
<tr>
<td>rsi_bfq_12</td>
<td>float</td>
<td>Y</td>
<td>RSI指标-CLOSE, N=12</td>
</tr>
<tr>
<td>rsi_bfq_24</td>
<td>float</td>
<td>Y</td>
<td>RSI指标-CLOSE, N=24</td>
</tr>
<tr>
<td>rsi_bfq_6</td>
<td>float</td>
<td>Y</td>
<td>RSI指标-CLOSE, N=6</td>
</tr>
<tr>
<td>taq_down_bfq</td>
<td>float</td>
<td>Y</td>
<td>唐安奇通道(海龟)交易指标-HIGH, LOW, 20</td>
</tr>
<tr>
<td>taq_mid_bfq</td>
<td>float</td>
<td>Y</td>
<td>唐安奇通道(海龟)交易指标-HIGH, LOW, 20</td>
</tr>
<tr>
<td>taq_up_bfq</td>
<td>float</td>
<td>Y</td>
<td>唐安奇通道(海龟)交易指标-HIGH, LOW, 20</td>
</tr>
<tr>
<td>trix_bfq</td>
<td>float</td>
<td>Y</td>
<td>三重指数平滑平均线-CLOSE, M1=12, M2=20</td>
</tr>
<tr>
<td>trma_bfq</td>
<td>float</td>
<td>Y</td>
<td>三重指数平滑平均线-CLOSE, M1=12, M2=20</td>
</tr>
<tr>
<td>vr_bfq</td>
<td>float</td>
<td>Y</td>
<td>VR容量比率-CLOSE, VOL, M1=26</td>
</tr>
<tr>
<td>wr_bfq</td>
<td>float</td>
<td>Y</td>
<td>W&amp;R 威廉指标-CLOSE, HIGH, LOW, N=10, N1=6</td>
</tr>
<tr>
<td>wr1_bfq</td>
<td>float</td>
<td>Y</td>
<td>W&amp;R 威廉指标-CLOSE, HIGH, LOW, N=10, N1=6</td>
</tr>
<tr>
<td>xsii_td1_bfq</td>
<td>float</td>
<td>Y</td>
<td>薛斯通道II-CLOSE, HIGH, LOW, N=102, M=7</td>
</tr>
<tr>
<td>xsii_td2_bfq</td>
<td>float</td>
<td>Y</td>
<td>薛斯通道II-CLOSE, HIGH, LOW, N=102, M=7</td>
</tr>
<tr>
<td>xsii_td3_bfq</td>
<td>float</td>
<td>Y</td>
<td>薛斯通道II-CLOSE, HIGH, LOW, N=102, M=7</td>
</tr>
<tr>
<td>xsii_td4_bfq</td>
<td>float</td>
<td>Y</td>
<td>薛斯通道II-CLOSE, HIGH, LOW, N=102, M=7</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

#获取鹤21转债113632.SH所以有历史因子数据
df = pro.cb_factor_pro(ts_code=113632.SH')

#获取交易日期为20250724当天所有可转债的因子数据
df = pro.hk_income(trade_date='20250724')

```

数据样例

```
             ts_code trade_date     open  ...  xsii_td2_bfq  xsii_td3_bfq  xsii_td4_bfq
0    113632.SH   20250724  129.050  ...     125.93711     133.15621     115.73390
1    113632.SH   20250723  129.323  ...     125.15884     132.97290     115.57458
2    113632.SH   20250722  128.783  ...     124.46147     132.83027     115.45061
3    113632.SH   20250721  126.404  ...     123.75651     132.68214     115.32186
4    113632.SH   20250718  126.229  ...     123.16743     132.56631     115.22119
..         ...        ...      ...  ...           ...           ...           ...
873  113632.SH   20211215  130.950  ...     128.94497     139.66710     121.39290
874  113632.SH   20211214  131.010  ...           NaN     140.18070     121.83930
875  113632.SH   20211213  133.890  ...           NaN     141.11160     122.64840
876  113632.SH   20211210  129.990  ...           NaN     143.65820     124.86180
877  113632.SH   20211209  127.000  ...           NaN     140.12720     121.79280

```
