# 可转债基础信息

**文档ID**: 185
**原始链接**: https://tushare.pro/document/2?doc_id=185

---

## 可转债基本信息

接口：cb_basic描述：获取可转债基本信息限量：单次最大2000，总量不限制权限：用户需要至少2000积分才可以调取，但有流量控制，5000积分以上频次相对较高，积分越多权限越大，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>转债代码</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>N</td>
<td>上市日期</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>N</td>
<td>上市地点</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>转债代码</td>
</tr>
<tr>
<td>bond_full_name</td>
<td>str</td>
<td>Y</td>
<td>转债名称</td>
</tr>
<tr>
<td>bond_short_name</td>
<td>str</td>
<td>Y</td>
<td>转债简称</td>
</tr>
<tr>
<td>cb_code</td>
<td>str</td>
<td>Y</td>
<td>转股申报代码</td>
</tr>
<tr>
<td>stk_code</td>
<td>str</td>
<td>Y</td>
<td>正股代码</td>
</tr>
<tr>
<td>stk_short_name</td>
<td>str</td>
<td>Y</td>
<td>正股简称</td>
</tr>
<tr>
<td>maturity</td>
<td>float</td>
<td>Y</td>
<td>发行期限（年）</td>
</tr>
<tr>
<td>par</td>
<td>float</td>
<td>Y</td>
<td>面值</td>
</tr>
<tr>
<td>issue_price</td>
<td>float</td>
<td>Y</td>
<td>发行价格</td>
</tr>
<tr>
<td>issue_size</td>
<td>float</td>
<td>Y</td>
<td>发行总额（元）</td>
</tr>
<tr>
<td>remain_size</td>
<td>float</td>
<td>Y</td>
<td>债券余额（元）</td>
</tr>
<tr>
<td>value_date</td>
<td>str</td>
<td>Y</td>
<td>起息日期</td>
</tr>
<tr>
<td>maturity_date</td>
<td>str</td>
<td>Y</td>
<td>到期日期</td>
</tr>
<tr>
<td>rate_type</td>
<td>str</td>
<td>Y</td>
<td>利率类型</td>
</tr>
<tr>
<td>coupon_rate</td>
<td>float</td>
<td>Y</td>
<td>票面利率（%）</td>
</tr>
<tr>
<td>add_rate</td>
<td>float</td>
<td>Y</td>
<td>补偿利率（%）</td>
</tr>
<tr>
<td>pay_per_year</td>
<td>int</td>
<td>Y</td>
<td>年付息次数</td>
</tr>
<tr>
<td>list_date</td>
<td>str</td>
<td>Y</td>
<td>上市日期</td>
</tr>
<tr>
<td>delist_date</td>
<td>str</td>
<td>Y</td>
<td>摘牌日</td>
</tr>
<tr>
<td>exchange</td>
<td>str</td>
<td>Y</td>
<td>上市地点</td>
</tr>
<tr>
<td>conv_start_date</td>
<td>str</td>
<td>Y</td>
<td>转股起始日</td>
</tr>
<tr>
<td>conv_end_date</td>
<td>str</td>
<td>Y</td>
<td>转股截止日</td>
</tr>
<tr>
<td>conv_stop_date</td>
<td>str</td>
<td>Y</td>
<td>停止转股日(提前到期)</td>
</tr>
<tr>
<td>first_conv_price</td>
<td>float</td>
<td>Y</td>
<td>初始转股价</td>
</tr>
<tr>
<td>conv_price</td>
<td>float</td>
<td>Y</td>
<td>最新转股价</td>
</tr>
<tr>
<td>rate_clause</td>
<td>str</td>
<td>Y</td>
<td>利率说明</td>
</tr>
<tr>
<td>put_clause</td>
<td>str</td>
<td>N</td>
<td>赎回条款</td>
</tr>
<tr>
<td>maturity_put_price</td>
<td>str</td>
<td>N</td>
<td>到期赎回价格(含税)</td>
</tr>
<tr>
<td>call_clause</td>
<td>str</td>
<td>N</td>
<td>回售条款</td>
</tr>
<tr>
<td>reset_clause</td>
<td>str</td>
<td>N</td>
<td>特别向下修正条款</td>
</tr>
<tr>
<td>conv_clause</td>
<td>str</td>
<td>N</td>
<td>转股条款</td>
</tr>
<tr>
<td>guarantor</td>
<td>str</td>
<td>N</td>
<td>担保人</td>
</tr>
<tr>
<td>guarantee_type</td>
<td>str</td>
<td>N</td>
<td>担保方式</td>
</tr>
<tr>
<td>issue_rating</td>
<td>str</td>
<td>N</td>
<td>发行信用等级</td>
</tr>
<tr>
<td>newest_rating</td>
<td>str</td>
<td>N</td>
<td>最新信用等级</td>
</tr>
<tr>
<td>rating_comp</td>
<td>str</td>
<td>N</td>
<td>最新评级机构</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api(your token)
#获取可转债基础信息列表
df = pro.cb_basic(fields="ts_code,bond_short_name,stk_code,stk_short_name,list_date,delist_date")

```

数据示例

```
    ts_code bond_short_name   stk_code stk_short_name   list_date delist_date
0    125002.SZ            万科转债  000002.SZ            万科Ａ  2002-06-28  2004-04-30
1    125009.SZ            宝安转券  000009.SZ           中国宝安  1993-02-10  1996-01-01
2    125069.SZ            侨城转债  000069.SZ           华侨城Ａ  2004-01-16  2005-04-29
3    125301.SZ            丝绸转债  000301.SZ           东方盛虹  1998-09-15  2003-08-28
4    126301.SZ            丝绸转2  000301.SZ           东方盛虹  2002-09-24  2006-09-18

```
