# 可转债发行

**文档ID**: 186
**原始链接**: https://tushare.pro/document/2?doc_id=186

---

## 可转债发行

接口：cb_issue描述：获取可转债发行数据限量：单次最大2000，可多次提取，总量不限制积分：用户需要至少2000积分才可以调取，5000积分以上频次相对较高，积分越多权限越大，具体请参阅积分获取办法

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>TS代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>N</td>
<td>发行公告日</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>公告开始日期</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>公告结束日期</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>转债代码</td>
</tr>
<tr>
<td>ann_date</td>
<td>str</td>
<td>Y</td>
<td>发行公告日</td>
</tr>
<tr>
<td>res_ann_date</td>
<td>str</td>
<td>Y</td>
<td>发行结果公告日</td>
</tr>
<tr>
<td>plan_issue_size</td>
<td>float</td>
<td>Y</td>
<td>计划发行总额（元）</td>
</tr>
<tr>
<td>issue_size</td>
<td>float</td>
<td>Y</td>
<td>发行总额（元）</td>
</tr>
<tr>
<td>issue_price</td>
<td>float</td>
<td>Y</td>
<td>发行价格</td>
</tr>
<tr>
<td>issue_type</td>
<td>str</td>
<td>Y</td>
<td>发行方式</td>
</tr>
<tr>
<td>issue_cost</td>
<td>float</td>
<td>N</td>
<td>发行费用（元）</td>
</tr>
<tr>
<td>onl_code</td>
<td>str</td>
<td>Y</td>
<td>网上申购代码</td>
</tr>
<tr>
<td>onl_name</td>
<td>str</td>
<td>Y</td>
<td>网上申购简称</td>
</tr>
<tr>
<td>onl_date</td>
<td>str</td>
<td>Y</td>
<td>网上发行日期</td>
</tr>
<tr>
<td>onl_size</td>
<td>float</td>
<td>Y</td>
<td>网上发行总额（张）</td>
</tr>
<tr>
<td>onl_pch_vol</td>
<td>float</td>
<td>Y</td>
<td>网上发行有效申购数量（张）</td>
</tr>
<tr>
<td>onl_pch_num</td>
<td>int</td>
<td>Y</td>
<td>网上发行有效申购户数</td>
</tr>
<tr>
<td>onl_pch_excess</td>
<td>float</td>
<td>Y</td>
<td>网上发行超额认购倍数</td>
</tr>
<tr>
<td>onl_winning_rate</td>
<td>float</td>
<td>N</td>
<td>网上发行中签率（%）</td>
</tr>
<tr>
<td>shd_ration_code</td>
<td>str</td>
<td>Y</td>
<td>老股东配售代码</td>
</tr>
<tr>
<td>shd_ration_name</td>
<td>str</td>
<td>Y</td>
<td>老股东配售简称</td>
</tr>
<tr>
<td>shd_ration_date</td>
<td>str</td>
<td>Y</td>
<td>老股东配售日</td>
</tr>
<tr>
<td>shd_ration_record_date</td>
<td>str</td>
<td>Y</td>
<td>老股东配售股权登记日</td>
</tr>
<tr>
<td>shd_ration_pay_date</td>
<td>str</td>
<td>Y</td>
<td>老股东配售缴款日</td>
</tr>
<tr>
<td>shd_ration_price</td>
<td>float</td>
<td>Y</td>
<td>老股东配售价格</td>
</tr>
<tr>
<td>shd_ration_ratio</td>
<td>float</td>
<td>Y</td>
<td>老股东配售比例</td>
</tr>
<tr>
<td>shd_ration_size</td>
<td>float</td>
<td>Y</td>
<td>老股东配售数量（张）</td>
</tr>
<tr>
<td>shd_ration_vol</td>
<td>float</td>
<td>N</td>
<td>老股东配售有效申购数量（张）</td>
</tr>
<tr>
<td>shd_ration_num</td>
<td>int</td>
<td>N</td>
<td>老股东配售有效申购户数</td>
</tr>
<tr>
<td>shd_ration_excess</td>
<td>float</td>
<td>N</td>
<td>老股东配售超额认购倍数</td>
</tr>
<tr>
<td>offl_size</td>
<td>float</td>
<td>Y</td>
<td>网下发行总额（张）</td>
</tr>
<tr>
<td>offl_deposit</td>
<td>float</td>
<td>N</td>
<td>网下发行定金比例（%）</td>
</tr>
<tr>
<td>offl_pch_vol</td>
<td>float</td>
<td>N</td>
<td>网下发行有效申购数量（张）</td>
</tr>
<tr>
<td>offl_pch_num</td>
<td>int</td>
<td>N</td>
<td>网下发行有效申购户数</td>
</tr>
<tr>
<td>offl_pch_excess</td>
<td>float</td>
<td>N</td>
<td>网下发行超额认购倍数</td>
</tr>
<tr>
<td>offl_winning_rate</td>
<td>float</td>
<td>N</td>
<td>网下发行中签率</td>
</tr>
<tr>
<td>lead_underwriter</td>
<td>str</td>
<td>N</td>
<td>主承销商</td>
</tr>
<tr>
<td>lead_underwriter_vol</td>
<td>float</td>
<td>N</td>
<td>主承销商包销数量（张）</td>
</tr>
</tbody></table>
接口示例

```

pro = ts.pro_api()


#获取可转债发行数据
df = pro.cb_issue(ann_date='20190612')


#获取可转债发行数据，自定义字段
df = pro.cb_issue(fields='ts_code,ann_date,issue_size')

```

数据示例

```
    ts_code  ann_date issue_size
0    110072.SH  20200814    33.7000
1    113600.SH  20200811     5.9500
2    113598.SH  20200729     3.3000
3    113038.SH  20200729    50.0000
4    128125.SZ  20200728     4.5000
..         ...       ...        ...
489  100009.SH  20000223    13.5000
490  125302.SZ  19990727    15.0000
491  125301.SZ  19980826     2.0000
492  100001.SH  19980730     1.5000
493  125009.SZ      None     5.0000
```
