# 历史日线

**文档ID**: 27
**原始链接**: https://tushare.pro/document/2?doc_id=27

---

## A股日线行情

接口：daily，可以通过数据工具调试和查看数据数据说明：交易日每天15点～16点之间入库。本接口是未复权行情，停牌期间不提供数据调取说明：基础积分每分钟内可调取500次，每次6000条数据，一次请求相当于提取一个股票23年历史描述：获取股票行情数据，或通过通用行情接口获取数据，包含了前后复权数据

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>N</td>
<td>股票代码（支持多个股票同时提取，逗号分隔）</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>N</td>
<td>交易日期（YYYYMMDD）</td>
</tr>
<tr>
<td>start_date</td>
<td>str</td>
<td>N</td>
<td>开始日期(YYYYMMDD)</td>
</tr>
<tr>
<td>end_date</td>
<td>str</td>
<td>N</td>
<td>结束日期(YYYYMMDD)</td>
</tr>
</tbody>
</table>
注：日期都填YYYYMMDD格式，比如20181010

输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>描述</th>
</tr>
</thead>
<tbody>
<tr>
<td>ts_code</td>
<td>str</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_date</td>
<td>str</td>
<td>交易日期</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>开盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>最低价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>收盘价</td>
</tr>
<tr>
<td>pre_close</td>
<td>float</td>
<td>昨收价【除权价】</td>
</tr>
<tr>
<td>change</td>
<td>float</td>
<td>涨跌额</td>
</tr>
<tr>
<td>pct_chg</td>
<td>float</td>
<td>涨跌幅 【基于除权后的昨收计算的涨跌幅：（今收-除权昨收）/除权昨收 】</td>
</tr>
<tr>
<td>vol</td>
<td>float</td>
<td>成交量 （手）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>成交额 （千元）</td>
</tr>
</tbody>
</table>
接口示例

```
pro = ts.pro_api()

df = pro.daily(ts_code='000001.SZ', start_date='20180701', end_date='20180718')

#多个股票
df = pro.daily(ts_code='000001.SZ,600000.SH', start_date='20180701', end_date='20180718')

```

或者

```
df = pro.query('daily', ts_code='000001.SZ', start_date='20180701', end_date='20180718')

```

也可以通过日期取历史某一天的全部历史

```
df = pro.daily(trade_date='20180810')

```

数据样例

```
 ts_code     trade_date  open  high   low  close  pre_close  change    pct_chg  vol        amount
0  000001.SZ   20180718  8.75  8.85  8.69   8.70       8.72   -0.02       -0.23   525152.77   460697.377
1  000001.SZ   20180717  8.74  8.75  8.66   8.72       8.73   -0.01       -0.11   375356.33   326396.994
2  000001.SZ   20180716  8.85  8.90  8.69   8.73       8.88   -0.15       -1.69   689845.58   603427.713
3  000001.SZ   20180713  8.92  8.94  8.82   8.88       8.88    0.00        0.00   603378.21   535401.175
4  000001.SZ   20180712  8.60  8.97  8.58   8.88       8.64    0.24        2.78  1140492.31  1008658.828
5  000001.SZ   20180711  8.76  8.83  8.68   8.78       8.98   -0.20       -2.23   851296.70   744765.824
6  000001.SZ   20180710  9.02  9.02  8.89   8.98       9.03   -0.05       -0.55   896862.02   803038.965
7  000001.SZ   20180709  8.69  9.03  8.68   9.03       8.66    0.37        4.27  1409954.60  1255007.609
8  000001.SZ   20180706  8.61  8.78  8.45   8.66       8.60    0.06        0.70   988282.69   852071.526
9  000001.SZ   20180705  8.62  8.73  8.55   8.60       8.61   -0.01       -0.12   835768.77   722169.579

```
