# 历史分钟行情

**文档ID**: 313
**原始链接**: https://tushare.pro/document/2?doc_id=313

---

## 期货历史分钟行情

接口：ft_mins描述：获取全市场期货合约分钟数据，支持1min/5min/15min/30min/60min行情，提供Python SDK和 http Restful API两种方式，如果需要主力合约分钟，请先通过主力mapping接口获取对应的合约代码后提取分钟。限量：单次最大8000行数据，可以通过期货合约代码和时间循环获取，本接口可以提供超过10年历史分钟数据。权限：120积分可以调取2次接口查看数据，正式权限请参阅权限说明。

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码，e.g.CU2310.SHF</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>分钟频度（1min/5min/15min/30min/60min）</td>
</tr>
<tr>
<td>start_date</td>
<td>datetime</td>
<td>N</td>
<td>开始日期 格式：2023-08-25 09:00:00</td>
</tr>
<tr>
<td>end_date</td>
<td>datetime</td>
<td>N</td>
<td>结束时间 格式：2023-08-25 19:00:00</td>
</tr>
</tbody></table>
freq参数说明

<table>
<thead>
<tr>
<th>freq</th>
<th>说明</th>
</tr>
</thead>
<tbody><tr>
<td>1min</td>
<td>1分钟</td>
</tr>
<tr>
<td>5min</td>
<td>5分钟</td>
</tr>
<tr>
<td>15min</td>
<td>15分钟</td>
</tr>
<tr>
<td>30min</td>
<td>30分钟</td>
</tr>
<tr>
<td>60min</td>
<td>60分钟</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_time</td>
<td>str</td>
<td>Y</td>
<td>交易时间</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价（元）</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价（元）</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价（元）</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价（元）</td>
</tr>
<tr>
<td>vol</td>
<td>int</td>
<td>Y</td>
<td>成交量（手）</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额（元）</td>
</tr>
<tr>
<td>oi</td>
<td>float</td>
<td>Y</td>
<td>持仓量（手）</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

df = pro.df = pro.ft_mins(ts_code='CU2310.SHF', freq='1min', start_date='2023-08-25 09:00:00', end_date='2023-08-25 19:00:00')

```

数据样例

```
       ts_code           trade_time     open    close     high      low    vol       amount        oi
0    CU2310.SHF  2023-08-25 15:00:00  68920.0  68930.0  68940.0  68910.0  373.0  128543250.0  146733.0
1    CU2310.SHF  2023-08-25 14:59:00  68910.0  68920.0  68930.0  68910.0  300.0  103379650.0  146751.0
2    CU2310.SHF  2023-08-25 14:58:00  68930.0  68920.0  68940.0  68910.0  207.0   71340500.0  146777.0
3    CU2310.SHF  2023-08-25 14:57:00  68910.0  68930.0  68930.0  68910.0  317.0  109246900.0  146812.0
4    CU2310.SHF  2023-08-25 14:56:00  68900.0  68910.0  68920.0  68900.0  237.0   81659550.0  146852.0
..          ...                  ...      ...      ...      ...      ...    ...          ...       ...
220  CU2310.SHF  2023-08-25 09:05:00  68750.0  68760.0  68770.0  68740.0  103.0   35412050.0  145101.0
221  CU2310.SHF  2023-08-25 09:04:00  68750.0  68750.0  68770.0  68730.0  232.0   79741550.0  145105.0
222  CU2310.SHF  2023-08-25 09:03:00  68740.0  68750.0  68750.0  68720.0  205.0   70453700.0  145087.0
223  CU2310.SHF  2023-08-25 09:02:00  68710.0  68740.0  68740.0  68690.0  278.0   95514550.0  145132.0
224  CU2310.SHF  2023-08-25 09:01:00  68680.0  68710.0  68740.0  68680.0  868.0  298156350.0  145178.0

[225 rows x 9 columns]

```
