# 历史分钟

**文档ID**: 370
**原始链接**: https://tushare.pro/document/2?doc_id=370

---

## 股票历史分钟行情

接口：stk_mins描述：获取A股分钟数据，支持1min/5min/15min/30min/60min行情，提供Python SDK和 http Restful API两种方式限量：单次最大8000行数据，可以通过股票代码和时间循环获取，本接口可以提供超过10年历史分钟数据权限：需单独开权限，正式权限请参阅权限说明

输入参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>必选</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码，e.g. 600000.SH</td>
</tr>
<tr>
<td>freq</td>
<td>str</td>
<td>Y</td>
<td>分钟频度（1min/5min/15min/30min/60min）</td>
</tr>
<tr>
<td>start_date</td>
<td>datetime</td>
<td>N</td>
<td>开始日期 格式：2023-08-25 09:00:00</td>
</tr>
<tr>
<td>end_date</td>
<td>datetime</td>
<td>N</td>
<td>结束时间 格式：2023-08-25 19:00:00</td>
</tr>
</tbody></table>
freq参数说明

<table>
<thead>
<tr>
<th>freq</th>
<th>说明</th>
</tr>
</thead>
<tbody><tr>
<td>1min</td>
<td>1分钟</td>
</tr>
<tr>
<td>5min</td>
<td>5分钟</td>
</tr>
<tr>
<td>15min</td>
<td>15分钟</td>
</tr>
<tr>
<td>30min</td>
<td>30分钟</td>
</tr>
<tr>
<td>60min</td>
<td>60分钟</td>
</tr>
</tbody></table>
输出参数

<table>
<thead>
<tr>
<th>名称</th>
<th>类型</th>
<th>默认显示</th>
<th>描述</th>
</tr>
</thead>
<tbody><tr>
<td>ts_code</td>
<td>str</td>
<td>Y</td>
<td>股票代码</td>
</tr>
<tr>
<td>trade_time</td>
<td>str</td>
<td>Y</td>
<td>交易时间</td>
</tr>
<tr>
<td>open</td>
<td>float</td>
<td>Y</td>
<td>开盘价</td>
</tr>
<tr>
<td>close</td>
<td>float</td>
<td>Y</td>
<td>收盘价</td>
</tr>
<tr>
<td>high</td>
<td>float</td>
<td>Y</td>
<td>最高价</td>
</tr>
<tr>
<td>low</td>
<td>float</td>
<td>Y</td>
<td>最低价</td>
</tr>
<tr>
<td>vol</td>
<td>int</td>
<td>Y</td>
<td>成交量</td>
</tr>
<tr>
<td>amount</td>
<td>float</td>
<td>Y</td>
<td>成交金额</td>
</tr>
</tbody></table>
接口用法

```

pro = ts.pro_api()

#获取浦发银行60000.SH的历史分钟数据
df = pro.stk_mins(ts_code='600000.SH', freq='1min', start_date='2023-08-25 09:00:00', end_date='2023-08-25 19:00:00')

```

数据样例

```
     ts_code             trade_time  close  open  high   low       vol     amount
0    600000.SH  2023-08-25 15:00:00   7.05  7.05  7.05  7.05  235500.0  1660275.0
1    600000.SH  2023-08-25 14:59:00   7.05  7.05  7.05  7.05       0.0        0.0
2    600000.SH  2023-08-25 14:58:00   7.05  7.05  7.05  7.05       0.0        0.0
3    600000.SH  2023-08-25 14:57:00   7.05  7.06  7.06  7.05   51800.0   365491.0
4    600000.SH  2023-08-25 14:56:00   7.05  7.05  7.06  7.04   92700.0   653831.0
..         ...                  ...    ...   ...   ...   ...       ...        ...
236  600000.SH  2023-08-25 09:34:00   7.01  7.02  7.02  7.00  120500.0   845311.0
237  600000.SH  2023-08-25 09:33:00   7.01  7.01  7.02  7.00  126000.0   883188.0
238  600000.SH  2023-08-25 09:32:00   7.01  7.02  7.02  6.99  236699.0  1659260.0
239  600000.SH  2023-08-25 09:31:00   7.02  6.99  7.02  6.97  807500.0  5649956.0
240  600000.SH  2023-08-25 09:30:00   6.99  6.99  6.99  6.99  103700.0   724863.0

```
